/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.json.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class RequestValidationService {
    private static final Logger logger = LoggerFactory.getLogger(RequestValidationService.class);
    @Inject
    private ConfigurationService confService;

    public boolean isAuthenticationAllowed(HttpServletRequest request) {
        Collection<String> trustedNetworks;
        try {
            trustedNetworks = this.confService.getTrustedNetworks();
        }
        catch (GuacamoleException e) {
            logger.warn("Authentication request from \"{}\" is DENIED due to parse error: {}", (Object)request.getRemoteAddr(), (Object)e.getMessage());
            logger.debug("Error parsing authentication request restrictions from guacamole.properties.", (Throwable)e);
            return false;
        }
        if (trustedNetworks.isEmpty()) {
            logger.debug("Authentication request from \"{}\" is ALLOWED (no restrictions).", (Object)request.getRemoteAddr());
            return true;
        }
        ArrayList<IpAddressMatcher> matchers = new ArrayList<IpAddressMatcher>(trustedNetworks.size());
        for (String network : trustedNetworks) {
            matchers.add(new IpAddressMatcher(network));
        }
        for (IpAddressMatcher matcher : matchers) {
            if (!matcher.matches(request)) continue;
            logger.debug("Authentication request from \"{}\" is ALLOWED (matched subnet).", (Object)request.getRemoteAddr());
            return true;
        }
        logger.debug("Authentication request from \"{}\" is DENIED (did not match subnet).", (Object)request.getRemoteAddr());
        return false;
    }
}

