/*
 * This file is part of the Code::Blocks IDE and licensed under the GNU Lesser General Public License, version 3
 * http://www.gnu.org/licenses/lgpl-3.0.html
 */

#ifndef EDITARRAYFILEDLG_H
#define EDITARRAYFILEDLG_H

#include "scrollingdialog.h"
#include <wx/intl.h>
#include "settings.h"

class DLLIMPORT EditArrayFileDlg : public wxScrollingDialog
{
	public:
		EditArrayFileDlg(wxWindow* parent, wxArrayString& array, bool useRelativePaths = false, const wxString& basePath = _T(""));
		~EditArrayFileDlg() override;
		EditArrayFileDlg& operator=(const EditArrayFileDlg&){ return *this; } // just to satisfy script bindings (never used)
		void EndModal(int retCode) override;
	protected:
		void OnAdd(wxCommandEvent& event);
		void OnEdit(wxCommandEvent& event);
		void OnDelete(wxCommandEvent& event);
		void OnUpdateUI(wxUpdateUIEvent& event);
		wxArrayString& m_Array;
		bool m_UseRelativePaths;
		wxString m_BasePath;
	private:
		DECLARE_EVENT_TABLE()
};

#endif // EDITARRAYFILEDLG_H

