/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.Alignment;
import jalview.ColourScheme;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.ScoreSequence;
import jalview.Sequence;
import jalview.SequenceGroup;
import jalview.SequenceNode;
import jalview.SwissprotFile;
import jalview.TreeFile;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.io.IOException;
import java.util.Vector;

public class DrawableAlignment
extends Alignment {
    DrawableSequence[] ds;
    ScoreSequence qualityScore;
    boolean autoConsensus = false;

    public DrawableAlignment(DrawableSequence[] drawableSequenceArray) {
        super(drawableSequenceArray);
        this.ds = drawableSequenceArray;
    }

    public void getFeatures(String string, TextArea textArea, String string2, String string3) {
        try {
            textArea.setText("Querying srs server " + string2 + " and database " + string3);
            FileParse fileParse = new FileParse("http://" + string2 + "wgetz?-e+[" + string3 + "-id:" + string + "]", "URL");
            fileParse.readLines();
            int n = 0;
            while (n < fileParse.lineArray.size()) {
                String string4 = "";
                while (n < fileParse.lineArray.size() && ((String)fileParse.lineArray.elementAt(n)).indexOf("//") != 0) {
                    string4 = String.valueOf(string4) + (String)fileParse.lineArray.elementAt(n) + "\n";
                    ++n;
                }
                string4 = String.valueOf(string4) + "//";
                textArea.setText("Reading features");
                SwissprotFile swissprotFile = new SwissprotFile(string4);
                if (!swissprotFile.id.equals("")) {
                    textArea.setText("Read features for " + swissprotFile.id);
                    int n2 = 0;
                    while (n2 < this.ds.length && this.ds[n2] != null) {
                        if (this.ds[n2].name.equals(swissprotFile.id)) {
                            textArea.setText("Attaching features to sequence " + this.ds[n2].name);
                            String string5 = AlignSeq.extractChars(". -", this.ds[n2].sequence);
                            System.out.println(string5);
                            System.out.println(swissprotFile.sequence.sequence);
                            System.out.println(String.valueOf(this.ds[n2].start) + " " + this.ds[n2].end);
                            System.out.println(swissprotFile.sequence.sequence.indexOf(string5));
                            if (swissprotFile.sequence.sequence.indexOf(string5) == -1) {
                                System.out.println("ERROR: id " + swissprotFile.id + "sequence doesn't match alignment sequence");
                            } else if (swissprotFile.sequence.sequence.indexOf(string5) != this.ds[n2].start - 1) {
                                System.out.println("Adjusting start end positions for " + swissprotFile.id);
                                this.ds[n2].start = swissprotFile.sequence.sequence.indexOf(string5) + 1;
                                this.ds[n2].end = this.ds[n2].start + this.ds[n2].sequence.length() - 1;
                            }
                            this.ds[n2].features = swissprotFile.features;
                            this.ds[n2].pdbcode = swissprotFile.pdbcode;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception in fetching features " + iOException);
            textArea.setText("ERROR: Exception in fetching features from " + string2 + " : " + iOException);
            return;
        }
    }

    public Vector getPDBCodes() {
        int n = 0;
        Vector vector = new Vector();
        while (n < this.ds.length && this.ds[n] != null) {
            if (this.ds[n].pdbcode != null && this.ds[n].pdbcode.size() != 0) {
                int n2 = 0;
                while (n2 < this.ds[n].pdbcode.size()) {
                    vector.addElement(this.ds[n].pdbcode.elementAt(n2));
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    public void getFeatures(TextArea textArea, String string, String string2) {
        int n = 0;
        String string3 = "";
        while (n < this.sequences.length && this.sequences[n] != null) {
            if (this.ds[n].features == null) {
                String string4 = this.ds[n].name;
                if (string4.indexOf("/") > 0) {
                    string4 = string4.substring(0, string4.indexOf("/"));
                }
                if (n % 20 == 0) {
                    if ((string3 = String.valueOf(string3) + string4).substring(string3.length() - 1).equals("|")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    this.getFeatures(string3, textArea, string, string2);
                    string3 = "";
                } else {
                    string3 = String.valueOf(string3) + string4 + "|";
                }
            }
            ++n;
        }
        if (!string3.equals("")) {
            if (string3.substring(string3.length() - 1).equals("|")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            this.getFeatures(string3, textArea, string, string2);
        }
        textArea.setText("done");
    }

    public void getFeatures(TextArea textArea, Vector vector, String string, String string2) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof Sequence && ((Sequence)vector.elementAt((int)n)).features == null) {
                ((Sequence)vector.elementAt(n)).getFeatures(string, string2);
                textArea.setText("Fetched features for " + this.ds[n].name + " (" + (n + 1) + "/" + vector.size() + ")");
            }
            ++n;
        }
    }

    public void getFeatures(Vector vector, String string, String string2) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof Sequence && ((Sequence)vector.elementAt((int)n)).features == null) {
                ((Sequence)vector.elementAt(n)).getFeatures(string, string2);
            }
            ++n;
        }
    }

    public void getFeatures(String string, String string2) {
        int n = 0;
        while (n < this.sequences.length && this.sequences[n] != null) {
            if (this.ds[n].features == null) {
                this.ds[n].getFeatures(string, string2);
            }
            ++n;
        }
    }

    public int getHeight() {
        int n = 0;
        int n2 = 0;
        while (n < this.ds.length && this.ds[n] != null) {
            n2 += this.ds[n].charHeight;
            ++n;
        }
        return n2;
    }

    public int getHeight(int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += this.ds[n].charHeight;
            ++n;
        }
        return n3;
    }

    public int getHeight(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n && n2 < this.ds.length && this.ds[n2] != null) {
            if (n2 > 0) {
                n3 += this.ds[n2 - 1].charHeight;
            }
            ++n2;
        }
        return n3;
    }

    public void findQuality() {
        super.findQuality();
        System.out.println("Done quality");
        if (this.quality != null) {
            ScoreSequence scoreSequence;
            String string = new String(this.sequences[0].sequence);
            DrawableSequence drawableSequence = new DrawableSequence("Quality", string, 1, this.maxLength);
            drawableSequence.score[0] = this.quality;
            this.qualityScore = scoreSequence = new ScoreSequence(drawableSequence, 0, (int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        }
    }

    public int getHeight(DrawableSequence drawableSequence) {
        int n = 0;
        int n2 = 0;
        while (n < this.ds.length && this.ds[n] != null) {
            if (this.ds[n] != drawableSequence) {
                n2 += this.ds[n].charHeight;
            }
            ++n;
        }
        return n2;
    }

    public void addSequence(DrawableSequence[] drawableSequenceArray) {
        int n = this.ds.length;
        DrawableSequence[] drawableSequenceArray2 = new DrawableSequence[this.ds.length + drawableSequenceArray.length];
        int n2 = 0;
        while (n2 < n && this.ds[n2] != null) {
            drawableSequenceArray2[n2] = this.ds[n2];
            ++n2;
        }
        n = n2;
        System.out.println(String.valueOf(n) + " " + n2 + " " + drawableSequenceArray.length);
        while (n2 < drawableSequenceArray2.length && n2 - n < drawableSequenceArray.length && drawableSequenceArray[n2 - n] != null) {
            System.out.println(String.valueOf(n) + " " + n2 + " " + drawableSequenceArray.length);
            drawableSequenceArray2[n2] = drawableSequenceArray[n2 - n];
            ++n2;
        }
        this.ds = drawableSequenceArray2;
        this.sequences = drawableSequenceArray2;
        this.size = this.size();
    }

    public void addSequence(DrawableSequence drawableSequence) {
        DrawableSequence[] drawableSequenceArray = new DrawableSequence[this.ds.length + 1];
        int n = 0;
        while (n < this.ds.length && this.ds[n] != null) {
            drawableSequenceArray[n] = this.ds[n];
            ++n;
        }
        drawableSequenceArray[n] = drawableSequence;
        this.ds = drawableSequenceArray;
        this.sequences = drawableSequenceArray;
        this.size = this.size();
    }

    public void sortByTree(TreeFile treeFile) {
        DrawableSequence[] drawableSequenceArray = new DrawableSequence[this.ds.length];
        Vector vector = new Vector();
        vector = this._sortByTree(treeFile.top, vector);
        int n = 0;
        while (n < vector.size()) {
            drawableSequenceArray[n] = (DrawableSequence)vector.elementAt(n);
            ++n;
        }
        this.sequences = drawableSequenceArray;
        this.ds = drawableSequenceArray;
    }

    public Vector _sortByTree(SequenceNode sequenceNode, Vector vector) {
        if (sequenceNode == null) {
            return vector;
        }
        if (sequenceNode.left == null && sequenceNode.right == null) {
            if (sequenceNode.element instanceof DrawableSequence) {
                vector.addElement((DrawableSequence)sequenceNode.element);
                return vector;
            }
        } else {
            this._sortByTree((SequenceNode)sequenceNode.left, vector);
            this._sortByTree((SequenceNode)sequenceNode.right, vector);
        }
        return vector;
    }

    public void sortByGroup() {
        DrawableSequence[] drawableSequenceArray = new DrawableSequence[this.ds.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.groups.elementAt(n2);
            int n3 = 0;
            while (n3 < sequenceGroup.sequences.size()) {
                drawableSequenceArray[n] = (DrawableSequence)sequenceGroup.sequences.elementAt(n3);
                ++n;
                ++n3;
            }
            ++n2;
        }
        this.ds = drawableSequenceArray;
        this.sequences = drawableSequenceArray;
    }

    public void trimLeft(int n) {
        super.trimLeft(n);
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = 0;
            while (n3 < n) {
                if (this.ds[n2].textColour.size() > n3) {
                    this.ds[n2].textColour.removeElementAt(0);
                }
                if (this.ds[n2].boxColour.size() > n3) {
                    this.ds[n2].boxColour.removeElementAt(0);
                }
                int n4 = 0;
                while (n4 < this.ds[n2].score.length && this.ds[n2].score[n4] != null) {
                    if (this.ds[n2].score[n4].size() > n3) {
                        this.ds[n2].score[n4].removeElementAt(0);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void deleteSequence(Sequence sequence) {
        int n = 0;
        while (n < this.size) {
            if (this.ds[n] == sequence) {
                this.deleteSequence(n);
            }
            ++n;
        }
    }

    public void deleteSequence(int n) {
        int n2 = 0;
        while (n2 < this.groups.size()) {
            if (((SequenceGroup)this.groups.elementAt((int)n2)).sequences.contains(this.sequences[n])) {
                ((SequenceGroup)this.groups.elementAt((int)n2)).sequences.removeElement(this.sequences[n]);
            }
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.size()) {
            this.sequences[n3 - 1] = this.sequences[n3];
            this.ds[n3 - 1] = this.ds[n3];
            ++n3;
        }
        this.ds[this.size - 1] = null;
        this.sequences[this.size - 1] = null;
        this.size = this.size();
    }

    public void removeGappedColumns() {
        int n;
        Vector<String> vector = new Vector<String>(this.maxLength());
        int n2 = 0;
        while (n2 < this.maxLength()) {
            n = 1;
            int n3 = 0;
            while (n3 < this.ds.length) {
                String string;
                if (!(this.ds[n3] == null || (string = this.ds[n3].sequence.substring(n2, n2 + 1)).equals("-") || string.equals(".") || string.equals(" "))) {
                    n = 0;
                    break;
                }
                ++n3;
            }
            if (n != 0) {
                vector.addElement("0");
            } else {
                vector.addElement("1");
            }
            ++n2;
        }
        n = 0;
        while (n < vector.size()) {
            if ((String)vector.elementAt(n) == "0") {
                this.deleteColumns(n, n);
                vector.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public void deleteColumns(int n, int n2) {
        super.deleteColumns(n, n2);
        int n3 = 0;
        System.out.println("*********** in deletreColumns ***********");
        while (n3 < this.ds.length && this.ds[n3] != null) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = 0;
                while (this.ds[n3].score != null && n5 < this.ds[n3].score.length && this.ds[n3].score[n5] != null) {
                    if (this.ds[n3].score[n5].size() > n) {
                        this.ds[n3].score[n5].removeElementAt(n);
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void colourText(SequenceGroup sequenceGroup) {
        int n = 0;
        while (n < sequenceGroup.sequences.size()) {
            DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n);
            drawableSequence.colourText = sequenceGroup.colourText;
            ++n;
        }
    }

    public void displayText(SequenceGroup sequenceGroup) {
        int n = 0;
        while (n < sequenceGroup.sequences.size()) {
            DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n);
            drawableSequence.displayText = sequenceGroup.displayText;
            ++n;
        }
    }

    public void displayBoxes(SequenceGroup sequenceGroup) {
        int n = 0;
        while (n < sequenceGroup.sequences.size()) {
            DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n);
            drawableSequence.displayBoxes = sequenceGroup.displayBoxes;
            ++n;
        }
    }

    public void setColourScheme(SequenceGroup sequenceGroup) {
        sequenceGroup.colourScheme.setColours(sequenceGroup);
    }

    public void setColourScheme(ColourScheme colourScheme) {
        int n = 0;
        while (n < this.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.groups.elementAt(n);
            sequenceGroup.colourScheme = colourScheme;
            System.out.println("Setting colour scheme for " + n);
            sequenceGroup.colourScheme.setColours(sequenceGroup);
            ++n;
        }
    }

    public int maxIdLength(FontMetrics fontMetrics) {
        int n = 0;
        int n2 = 0;
        while (n < this.sequences.length && this.sequences[n] != null) {
            Sequence sequence = this.sequences[n];
            String string = String.valueOf(sequence.getName()) + "/" + sequence.start + "-" + sequence.end;
            if (fontMetrics.stringWidth(string) > n2) {
                n2 = fontMetrics.stringWidth(string);
            }
            ++n;
        }
        return n2;
    }

    public void trimRight(int n) {
        super.trimRight(n);
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = n + 1;
            while (n3 < this.ds[n2].sequence.length()) {
                if (this.ds[n2].textColour.size() > n + 1) {
                    this.ds[n2].textColour.removeElementAt(n + 1);
                }
                if (this.ds[n2].boxColour.size() > n + 1) {
                    this.ds[n2].boxColour.removeElementAt(n + 1);
                }
                int n4 = 0;
                while (n4 < this.ds[n2].score.length && this.ds[n2].score[n4] != null) {
                    if (this.ds[n2].score[n4].size() > n + 1) {
                        this.ds[n2].score[n4].removeElementAt(n + 1);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }
}

