/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.Pattern;

class OrPattern
extends Pattern {
    private final Pattern[] patterns;

    OrPattern(Pattern ... patterns) {
        this.patterns = patterns;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        for (Pattern pattern : this.patterns) {
            int l = pattern.match(src, begin, end);
            if (l == -1) continue;
            return l;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('(');
        for (Pattern pattern : this.patterns) {
            sb.append(pattern).append(" | ");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 3, sb.length());
        }
        return sb.append(')').toString();
    }
}

