/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports.common;

import javax.inject.Inject;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public class TripsConfig {
    private final double minimalTripDistance;
    private final long minimalTripDuration;
    private final long minimalParkingDuration;
    private final long minimalNoDataDuration;
    private final boolean useIgnition;
    private final boolean processInvalidPositions;
    private final double speedThreshold;

    @Inject
    public TripsConfig(Config config) {
        this(config.getLong(Keys.REPORT_TRIP_MINIMAL_TRIP_DISTANCE), config.getLong(Keys.REPORT_TRIP_MINIMAL_TRIP_DURATION) * 1000L, config.getLong(Keys.REPORT_TRIP_MINIMAL_PARKING_DURATION) * 1000L, config.getLong(Keys.REPORT_TRIP_MINIMAL_NO_DATA_DURATION) * 1000L, config.getBoolean(Keys.REPORT_TRIP_USE_IGNITION), config.getBoolean(Keys.EVENT_MOTION_PROCESS_INVALID_POSITIONS), config.getDouble(Keys.EVENT_MOTION_SPEED_THRESHOLD));
    }

    public TripsConfig(double minimalTripDistance, long minimalTripDuration, long minimalParkingDuration, long minimalNoDataDuration, boolean useIgnition, boolean processInvalidPositions, double speedThreshold) {
        this.minimalTripDistance = minimalTripDistance;
        this.minimalTripDuration = minimalTripDuration;
        this.minimalParkingDuration = minimalParkingDuration;
        this.minimalNoDataDuration = minimalNoDataDuration;
        this.useIgnition = useIgnition;
        this.processInvalidPositions = processInvalidPositions;
        this.speedThreshold = speedThreshold;
    }

    public double getMinimalTripDistance() {
        return this.minimalTripDistance;
    }

    public long getMinimalTripDuration() {
        return this.minimalTripDuration;
    }

    public long getMinimalParkingDuration() {
        return this.minimalParkingDuration;
    }

    public long getMinimalNoDataDuration() {
        return this.minimalNoDataDuration;
    }

    public boolean getUseIgnition() {
        return this.useIgnition;
    }

    public boolean getProcessInvalidPositions() {
        return this.processInvalidPositions;
    }

    public double getSpeedThreshold() {
        return this.speedThreshold;
    }
}

