/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.Block;
import liquibase.repackaged.net.sf.jsqlparser.statement.Commit;
import liquibase.repackaged.net.sf.jsqlparser.statement.CreateFunctionalStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DescribeStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ExplainStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.IfElseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.PurgeStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ResetStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.RollbackStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.SavepointStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.SetStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ShowColumnsStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ShowStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.statement.UseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSession;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.comment.Comment;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.function.CreateFunction;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.index.CreateIndex;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.procedure.CreateProcedure;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.schema.CreateSchema;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.AlterView;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.CreateView;
import liquibase.repackaged.net.sf.jsqlparser.statement.delete.Delete;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.repackaged.net.sf.jsqlparser.statement.execute.Execute;
import liquibase.repackaged.net.sf.jsqlparser.statement.grant.Grant;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.Insert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.Merge;
import liquibase.repackaged.net.sf.jsqlparser.statement.replace.Replace;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.show.ShowTablesStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.truncate.Truncate;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.Update;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.values.ValuesStatement;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AlterSequenceValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AlterValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AlterViewValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.CreateIndexValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.CreateSequenceValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.CreateSynonymValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.CreateTableValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.CreateViewValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.DeclareStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.DeleteValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.DropValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ExecuteValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.GrantValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.InsertValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.MergeValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ReplaceValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ResetStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SetStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ShowColumnsStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ShowStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ShowTablesStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.UpdateValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.UpsertValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.UseStatementValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ValuesStatementValidator;

public class StatementValidator
extends AbstractValidator<Statement>
implements StatementVisitor {
    @Override
    public void visit(CreateIndex createIndex) {
        this.getValidator(CreateIndexValidator.class).validate(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        this.getValidator(CreateTableValidator.class).validate(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        this.getValidator(CreateViewValidator.class).validate(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        this.getValidator(AlterViewValidator.class).validate(alterView);
    }

    @Override
    public void visit(Delete delete) {
        this.getValidator(DeleteValidator.class).validate(delete);
    }

    @Override
    public void visit(Drop drop) {
        this.getValidator(DropValidator.class).validate(drop);
    }

    @Override
    public void visit(Insert insert) {
        this.getValidator(InsertValidator.class).validate(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.getValidator(ReplaceValidator.class).validate(replace);
    }

    @Override
    public void visit(Select select) {
        this.validateFeature(Feature.select);
        SelectValidator selectValidator = this.getValidator(SelectValidator.class);
        if (select.getWithItemsList() != null) {
            select.getWithItemsList().forEach(withItem -> withItem.accept(selectValidator));
        }
        select.getSelectBody().accept(selectValidator);
    }

    @Override
    public void visit(Truncate truncate) {
        this.validateFeature(Feature.truncate);
        this.validateOptionalFromItem(truncate.getTable());
    }

    @Override
    public void visit(Update update) {
        this.getValidator(UpdateValidator.class).validate(update);
    }

    @Override
    public void visit(Alter alter) {
        this.getValidator(AlterValidator.class).validate(alter);
    }

    @Override
    public void visit(Statements statements) {
        statements.getStatements().forEach(statement -> statement.accept(this));
    }

    @Override
    public void visit(Execute execute) {
        this.getValidator(ExecuteValidator.class).validate(execute);
    }

    @Override
    public void visit(SetStatement setStatement) {
        this.getValidator(SetStatementValidator.class).validate(setStatement);
    }

    @Override
    public void visit(ResetStatement resetStatement) {
        this.getValidator(ResetStatementValidator.class).validate(resetStatement);
    }

    @Override
    public void visit(Merge merge) {
        this.getValidator(MergeValidator.class).validate(merge);
    }

    @Override
    public void visit(Commit commit) {
        this.validateFeature(Feature.commit);
    }

    @Override
    public void visit(Upsert upsert) {
        this.getValidator(UpsertValidator.class).validate(upsert);
    }

    @Override
    public void visit(UseStatement useStatement) {
        this.getValidator(UseStatementValidator.class).validate(useStatement);
    }

    @Override
    public void visit(ShowStatement showStatement) {
        this.getValidator(ShowStatementValidator.class).validate(showStatement);
    }

    @Override
    public void visit(ShowColumnsStatement showColumnsStatement) {
        this.getValidator(ShowColumnsStatementValidator.class).validate(showColumnsStatement);
    }

    @Override
    public void visit(ShowTablesStatement showTablesStatement) {
        this.getValidator(ShowTablesStatementValidator.class).validate(showTablesStatement);
    }

    @Override
    public void visit(Block block) {
        this.validateFeature(Feature.block);
        block.getStatements().accept(this);
    }

    @Override
    public void visit(Comment comment) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.comment);
            this.validateOptionalFeature(validationCapability, comment.getTable(), Feature.commentOnTable);
            this.validateOptionalFeature(validationCapability, comment.getColumn(), Feature.commentOnColumn);
            this.validateOptionalFeature(validationCapability, comment.getView(), Feature.commentOnView);
        }
    }

    @Override
    public void visit(ValuesStatement valuesStatement) {
        this.getValidator(ValuesStatementValidator.class).validate(valuesStatement);
    }

    @Override
    public void visit(DescribeStatement describeStatement) {
        this.validateFeature(Feature.describe);
        this.validateOptionalFromItem(describeStatement.getTable());
    }

    @Override
    public void visit(ExplainStatement explainStatement) {
        this.validateFeature(Feature.explain);
        explainStatement.getStatement().accept(this);
    }

    @Override
    public void visit(DeclareStatement declareStatement) {
        this.getValidator(DeclareStatementValidator.class).validate(declareStatement);
    }

    @Override
    public void visit(Grant grant) {
        this.getValidator(GrantValidator.class).validate(grant);
    }

    @Override
    public void visit(CreateSchema createSchema) {
        this.validateFeatureAndName(Feature.createSchema, NamedObject.schema, createSchema.getSchemaName());
        createSchema.getStatements().forEach(statement -> statement.accept(this));
    }

    @Override
    public void visit(CreateSequence createSequence) {
        this.getValidator(CreateSequenceValidator.class).validate(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        this.getValidator(AlterSequenceValidator.class).validate(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.validateFeature(Feature.functionalStatement);
        if (createFunctionalStatement instanceof CreateFunction) {
            this.validateFeature(Feature.createFunction);
            return;
        }
        if (createFunctionalStatement instanceof CreateProcedure) {
            this.validateFeature(Feature.createProcedure);
        }
    }

    @Override
    public void validate(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        this.getValidator(CreateSynonymValidator.class).validate(createSynonym);
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
    }

    @Override
    public void visit(AlterSession alterSession) {
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.getIfStatement().accept(this);
        if (ifElseStatement.getElseStatement() != null) {
            ifElseStatement.getElseStatement().accept(this);
        }
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
    }
}

