<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Настройки аккаунта',
    'sidebar_personalization' => 'Персонализация',
    'sidebar_settings_storage' => 'Хранилище',
    'sidebar_settings_export' => 'Экспорт данных',
    'sidebar_settings_users' => 'Пользователи',
    'sidebar_settings_subscriptions' => 'Подписка',
    'sidebar_settings_import' => 'Импорт данных',
    'sidebar_settings_tags' => 'Управление тегами',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Ресурсы DAV',
    'sidebar_settings_security' => 'Безопасность',
    'sidebar_settings_auditlogs' => 'Журнал аудита',

    'title_general' => 'Общая информация',
    'title_i18n' => 'Международные настройки',
    'title_layout' => 'Макет',

    'me_title' => 'Я как контакт',
    'me_help' => 'Это контакт, который представляет <em>вас</em> в Monica',
    'me_select' => 'Выберите контакт',
    'me_no_contact' => 'Контакт еще не выбран.',
    'me_select_click' => 'Нажмите здесь, чтобы выбрать контакт.',
    'me_remove_contact' => 'Удалить связь',
    'me_choose' => 'Выберите себя',
    'me_choose_placeholder' => 'Выберите себя',

    'export_title' => 'Экспортировать данные вашего аккаунта',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Имя',
    'lastname' => 'Фамилия',
    'name_order' => 'Сортировка имени',
    'name_order_firstname_lastname' => '<Имя> <Фамилия> – Иван Иванов',
    'name_order_lastname_firstname' => '<Фамилия> <Имя> – Иванов Иван',
    'name_order_firstname_lastname_nickname' => '<Имя> <Фамилия> (<Псевдоним>) – Иван Иванов (Ivan228)',
    'name_order_firstname_nickname_lastname' => '<Имя> (<Псевдоним>) <Фамилия> - Иван (Ivan228) Иванов',
    'name_order_lastname_firstname_nickname' => '<Фамилия> <Имя> (<Псевдоним>) - Иванов Иван (Ivan228)',
    'name_order_lastname_nickname_firstname' => '<Фамилия> (<Псевдоним>) <Имя> - Иван (Ivan228) Иванов',
    'name_order_nickname_firstname_lastname' => '<Псевдоним> (<Имя> <Фамилия>) – Ivan228 (Иван Иванов)',
    'name_order_nickname_lastname_firstname' => '<Псевдоним> (<Фамилия> <Имя>) – Ivan228 (Иванов Иван)',
    'name_order_nickname' => '<Псевдоним> - Ivan228',
    'currency' => 'Валюта',
    'name' => 'Ваше имя: :name',
    'email' => 'Email',
    'email_placeholder' => 'Введите email',
    'email_help' => 'Это почта, используемая для входа в Monica и эту почту будут приходить напоминания.',
    'timezone' => 'Часовой пояс',
    'temperature_scale' => 'Температура',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Дизайн',
    'layout_small' => 'Максимум шириной в 1200 пикселей',
    'layout_big' => 'Шириной во весь экран',
    'save' => 'Обновить настройки',
    'delete_title' => 'Удалить аккаунт',
    'delete_desc' => 'Вы хотите удалить свою учетную запись? Удаление необратимо и все ваши данные будут удалены навсегда. Если у вас есть подписка, она будет немедленно отменена.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Вы хотите сбросить учетную запись? Это удалит все ваши контакты и все связанные с ними данные. Ваша учетная запись не будет удалена.',
    'reset_title' => 'Сброс аккаунта',
    'reset_cta' => 'Сбросить аккаунт',
    'reset_notice' => 'Вы уверены, что хотите сбросить свою учетную запись? Это окончательно и не может быть отменено.',
    'reset_success' => 'Ваша учетная запись успешно сброшена.',
    'delete_notice' => 'Are you sure you want to delete your account? This is permanent and cannot be undone. All of your data will be deleted and will not be recoverable.',
    'delete_cta' => 'Удалить аккаунт',
    'settings_success' => 'Настройки обновлены!',
    'locale' => 'Язык',
    'locale_help' => 'Хотите помочь с переводом Monica или добавить новый язык? Перейдите по <a href=":url" target="_blank" lang="en">этой ссылке для получения дополнительной информации</a>.',
    'locale_ar' => 'Арабский',
    'locale_cs' => 'Чешский',
    'locale_de' => 'Немецкий',
    'locale_el' => 'Греческий',
    'locale_en' => 'Английский',
    'locale_en-GB' => 'Английский (Великобритания)',
    'locale_es' => 'Испанский',
    'locale_fr' => 'Французский',
    'locale_he' => 'Иврит',
    'locale_hr' => 'Хорватский',
    'locale_id' => 'Индонезийский',
    'locale_it' => 'Итальянский',
    'locale_ja' => 'Японский',
    'locale_nl' => 'Нидерландский',
    'locale_pt' => 'Португальский',
    'locale_pt-BR' => 'Бразильский португальский',
    'locale_ru' => 'Русский',
    'locale_sv' => 'Шведский',
    'locale_vi' => 'Vietnamese',
    'locale_zh' => 'Китайский упрощенный',
    'locale_zh-TW' => 'Китайский традиционный',
    'locale_tr' => 'Турецкий',

    'security_title' => 'Безопасность',
    'security_help' => 'Изменение вопросов безопасности для вашей учетной записи.',
    'password_change' => 'Изменить пароль',
    'password_current' => 'Текущий пароль',
    'password_current_placeholder' => 'Введите ваш текущий пароль',
    'password_new1' => 'Новый пароль',
    'password_new1_placeholder' => 'Введите новый пароль',
    'password_new2' => 'Подтвердите новый пароль',
    'password_new2_placeholder' => 'Повторите новый пароль',
    'password_btn' => 'Изменить пароль',
    '2fa_title' => 'Двухфакторная аутентификация',
    '2fa_otp_title' => 'Мобильное приложение для двухфакторной аутентификации',
    '2fa_enable_title' => 'Включить двухфакторную аутентификацию',
    '2fa_enable_description' => 'Включите двухфакторную аутентификацию, чтобы повысить безопасность вашей учетной записи.',
    '2fa_enable_otp' => 'Откройте ваше мобильное приложение двухфакторной аутентификации и отсканируйте следующий QR-код:',
    '2fa_enable_otp_help' => 'Если ваше мобильное приложение двухфакторной аутентификации не поддерживает QR-коды, введите следующий код:',
    '2fa_enable_otp_validate' => 'Пожалуйста, проверьте новое устройство, которое вы только что настроили:',
    '2fa_enable_success' => 'Двухфакторная аутентификация активирована',
    '2fa_enable_error' => 'Error when trying to activate Two Factor Authentication',
    '2fa_enable_error_already_set' => 'Двухфакторная аутентификация уже включена',
    '2fa_disable_title' => 'Отключить двухфакторную аутентификацию',
    '2fa_disable_description' => 'Disable Two Factor Authentication for your account. Be careful, your account will be much less secure!',
    '2fa_disable_success' => 'Двухфакторная аутентификация отключена',
    '2fa_disable_error' => 'Ошибка при попытке отключить двухфакторную аутентификацию',

    'webauthn_title' => 'Ключ безопасности — протокол WebAuthn',
    'webauthn_enable_description' => 'Добавить новый ключ безопасности',
    'webauthn_key_name_help' => 'Дайте вашему ключу имя.',
    'webauthn_key_name' => 'Имя ключа:',
    'webauthn_success' => 'Ваш ключ обнаружен и проверен.',
    'webauthn_last_use' => 'Последнее использование: {timestamp}',
    'webauthn_delete_confirmation' => 'Вы действительно хотите удалить этот ключ?',
    'webauthn_delete_success' => 'Ключ удалён',
    'webauthn_insertKey' => 'Вставьте ваш ключ безопасности.',
    'webauthn_buttonAdvise' => 'Если в вашем ключе безопасности есть кнопка, нажмите ее.',
    'webauthn_noButtonAdvise' => 'If it does not, remove it and insert it again.',
    'webauthn_not_supported' => 'Ваш браузер в настоящее время не поддерживает WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn поддерживает только безопасные соединения. Загрузите эту страницу через https.',
    'webauthn_error_already_used' => 'Этот ключ уже зарегистрирован. Нет необходимости в его повторной регистрации.',
    'webauthn_error_not_allowed' => 'Операция истекла или не была разрешена.',

    'recovery_title' => 'Коды восстановления',
    'recovery_show' => 'Получить коды восстановления',
    'recovery_copy_help' => 'Скопировать коды в буфер обмена',
    'recovery_help_intro' => 'Ваши коды восстановления:',
    'recovery_help_information' => 'Вы можете использовать каждый код восстановления один раз.',
    'recovery_clipboard' => 'Codes copied to the clipboard.',
    'recovery_generate' => 'Сгенерировать новые коды…',
    'recovery_generate_help' => 'Создание новых кодов аннулирует ранее сгенерированные коды.',
    'recovery_already_used_help' => 'This code has already been used.',

    'users_list_title' => 'Пользователи с доступом к вашей учетной записи',
    'users_list_add_user' => 'Пригласить нового пользователя',
    'users_list_you' => 'Это вы',
    'users_list_invitations_title' => 'Приглашения, ожидающие ответа',
    'users_list_invitations_explanation' => 'Below are the people you’ve invited to join Monica as a collaborator.',
    'users_list_invitations_invited_by' => 'invited by :name',
    'users_list_invitations_sent_date' => 'sent on :date',
    'users_blank_title' => 'Вы единственный, кто имеет доступ к этому аккаунту.',
    'users_blank_add_title' => 'Хотите пригласить кого-нибудь?',
    'users_blank_description' => 'Этот человек будет иметь такой же доступ, как у вас, и сможет добавлять, редактировать или удалять контактную информацию.',
    'users_blank_cta' => 'Пригласить кого-нибудь',
    'users_add_title' => 'Invite a new user to your account by email',
    'users_add_description' => 'This person will have the same access as you do, including inviting or deleting other users, including you. Make sure you trust this person before giving them access.',
    'users_add_email_field' => 'Enter the email of the person you want to invite',
    'users_add_confirmation' => 'I confirm that I want to invite this user to my account. I understand that this person will have access to ALL of my data and see exactly what I see.',
    'users_add_cta' => 'Invite user by email',
    'users_accept_title' => 'Принять приглашение и создать аккаунт',
    'users_error_please_confirm' => 'Please confirm that you want to invite this before proceeding with the invitation',
    'users_error_email_already_taken' => 'Этот адрес уже используется. Пожалуйста, выберите другой',
    'users_error_already_invited' => 'Вы уже пригласили этого пользователя. Пожалуйста, выберите другой адрес электронной почты.',
    'users_error_email_not_similar' => 'This is not the email of the person who’ve invited you.',
    'users_invitation_deleted_confirmation_message' => 'Приглашение успешно удалено',
    'users_invitations_delete_confirmation' => 'Вы действительно хотите удалить это приглашение?',
    'users_list_delete_confirmation' => 'Вы точно хотите удалить этого пользователя из вашего аккаунта?',
    'users_invitation_need_subscription' => 'Adding more users requires a subscription.',

    'subscriptions_account_current_plan' => 'Your current plan',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => 'You are on the :name plan. Thanks so much for being a subscriber.',

    'subscriptions_account_next_billing_title' => 'Следующий платёж',
    'subscriptions_account_next_billing' => 'Your subscription will auto-renew on <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Изменить план',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Отменить подписку',
    'subscriptions_account_cancel' => 'You can cancel your subscription at any time.',
    'subscriptions_account_free_plan' => 'Вы на бесплатном тарифном плане.',
    'subscriptions_account_free_plan_upgrade' => 'You can upgrade your account to the :name plan, which costs $:price per month. Here are the advantages:',
    'subscriptions_account_free_plan_benefits_users' => 'Неограниченное количество пользователей',
    'subscriptions_account_free_plan_benefits_reminders' => 'Напоминания по электронной почте',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Import your contacts with vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Support the project in the long run, so we can introduce more great features.',
    'subscriptions_account_upgrade' => 'Upgrade your account',
    'subscriptions_account_upgrade_title' => 'Upgrade Monica today and have more meaningful relationships.',
    'subscriptions_account_upgrade_choice' => 'Pick a plan below and join over :customers persons who upgraded their Monica.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Invoices',
    'subscriptions_account_invoices_download' => 'Download',
    'subscriptions_account_invoices_subscription' => 'Subscription from :startDate to :endDate',
    'subscriptions_account_payment' => 'Which payment option fits you best?',
    'subscriptions_account_confirm_payment' => 'Your payment is currently incomplete, please <a href=":url">confirm your payment</a>.',
    'subscriptions_downgrade_title' => 'Downgrade your account to the free plan',
    'subscriptions_downgrade_limitations' => 'The free plan has limitations. In order to be able to downgrade, you need to pass the checklist below:',
    'subscriptions_downgrade_rule_users' => 'You must have only 1 user in your account',
    'subscriptions_downgrade_rule_users_constraint' => 'You currently have <a href=":url">1 user</a> in your account.|You currently have <a href=":url">:count users</a> in your account.',
    'subscriptions_downgrade_rule_invitations' => 'You must not have any pending invitations',
    'subscriptions_downgrade_rule_invitations_constraint' => 'You currently have <a href=":url">1 pending invitation</a>.|You currently have <a href=":url">:count pending invitations</a>.',
    'subscriptions_downgrade_rule_contacts' => 'You must not have more than :number active contacts',
    'subscriptions_downgrade_rule_contacts_constraint' => 'You currently have <a href=":url">1 contact</a>.|You currently have <a href=":url">:count contacts</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Downgrade',
    'subscriptions_downgrade_success' => 'You are back to the Free plan!',
    'subscriptions_downgrade_thanks' => 'Thanks so much for trying the paid plan. We keep adding new features on Monica all the time – so you might want to come back in the future to see if you might be interested in taking a subscription again.',
    'subscriptions_back' => 'Back to settings',
    'subscriptions_upgrade_title' => 'Upgrade your account',
    'subscriptions_upgrade_choose' => 'You picked the :plan plan.',
    'subscriptions_upgrade_infos' => 'We couldn’t be happier. Enter your payment info below.',
    'subscriptions_upgrade_name' => 'Имя держателя карты',
    'subscriptions_upgrade_zip' => 'Почтовый индекс',
    'subscriptions_upgrade_credit' => 'Кредитная или дебетовая карта',
    'subscriptions_upgrade_submit' => 'Pay {amount}',
    'subscriptions_upgrade_charge' => 'We’ll charge your card :price now. The next charge will be on :date. If you ever change your mind, you can cancel at any time, no questions asked.',
    'subscriptions_upgrade_charge_handled' => 'The payment is handled by <a href=":url">Stripe</a>. No card information touches our server.',
    'subscriptions_upgrade_success' => 'Thank you! You are now subscribed.',
    'subscriptions_upgrade_thanks' => 'Welcome to the community of people who try to make the world a better place.',

    'subscriptions_payment_confirm_title' => 'Confirm your :amount payment',
    'subscriptions_payment_confirm_information' => 'Extra confirmation is needed to process your payment. Please confirm your payment by filling out your payment details below.',
    'subscriptions_payment_succeeded_title' => 'Платеж выполнен',
    'subscriptions_payment_succeeded' => 'Этот платеж уже был успешно подтвержден.',
    'subscriptions_payment_cancelled_title' => 'Платеж отменен',
    'subscriptions_payment_cancelled' => 'Этот платеж был отменен.',
    'subscriptions_payment_error_name' => 'Please provide your name.',
    'subscriptions_payment_success' => 'The payment was successful.',

    'subscriptions_pdf_title' => 'Your :name monthly subscription',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Choose this plan',
    'subscriptions_plan_year_title' => 'Pay annually',
    'subscriptions_plan_year_bonus' => 'Peace of mind for a whole year',
    'subscriptions_plan_month_title' => 'Pay monthly',
    'subscriptions_plan_month_bonus' => 'Можно отменить в любой момент',
    'subscriptions_plan_include1' => 'Included with your upgrade:',
    'subscriptions_plan_include2' => 'Unlimited number of contacts • Unlimited number of users • Reminders by email • Import with vCard • Personalization of the contact sheet',
    'subscriptions_plan_include3' => '100% of the profits go the development of this great open source project.',
    'subscriptions_help_title' => 'Additional details you may be curious about',
    'subscriptions_help_opensource_title' => 'Что такое проект с открытым исходным кодом?',
    'subscriptions_help_opensource_desc' => 'Monica is an open source project.  This means it is built by a community who wants to build a great tool for the greater good. Being open source means the code is publicly available on GitHub, and everyone can inspect it, modify it or enhance it. All the money we raise is dedicated to building better features, paying for more powerful servers, and paying other costs. Thanks for your help. We couldn’t do it without you.',
    'subscriptions_help_limits_title' => 'Is there a limit to the number of contacts we can have on the free plan?',
    'subscriptions_help_limits_plan' => 'Yes. Free plans let you manage :number contacts.',
    'subscriptions_help_discounts_title' => 'Do you have discounts for non-profits and education?',
    'subscriptions_help_discounts_desc' => 'We do! Monica is free for students, and free for non-profits and charities. Just contact <a href=":support">the support</a> with a proof of your status and we’ll apply this special status in your account.',
    'subscriptions_help_change_title' => 'Что если я передумаю?',
    'subscriptions_help_change_desc' => 'Вы можете отменить это в любое время, без вопросов и самостоятельно – без необходимости обращаться в службу поддержки. Тем не менее, вам не будет осуществлен возврат средств за текущий период.',

    'stripe_error_card' => 'Your card was declined. Decline message is: :message',
    'stripe_error_api_connection' => 'Network communication with Stripe failed. Try again later.',
    'stripe_error_rate_limit' => 'Too many requests with Stripe right now. Try again later.',
    'stripe_error_invalid_request' => 'Invalid parameters. Try again later.',
    'stripe_error_authentication' => 'Wrong authentication with Stripe',

    'import_title' => 'Import contacts in your account',
    'import_cta' => 'Upload contacts',
    'import_stat' => 'You’ve imported :number files so far.',
    'import_result_stat' => 'Uploaded vCard with 1 contact (:total_imported imported, :total_skipped skipped)|Uploaded vCard with :total_contacts contacts (:total_imported imported, :total_skipped skipped)',
    'import_view_report' => 'View report',
    'import_in_progress' => 'The import is in progress. Reload the page in one minute.',
    'import_upload_title' => 'Import your contacts from a vCard file',
    'import_upload_rules_desc' => 'We do however have some rules:',
    'import_upload_rule_format' => 'We support <code>.vcard</code> and <code>.vcf</code> files.',
    'import_upload_rule_vcard' => 'We support the vCard 3.0 format, which is the default format for macOS’s Contacts.app and Google Contacts.',
    'import_upload_rule_instructions' => 'Export instructions for <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> and <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'If your contacts have multiple email addresses or phone numbers, only the first entry will be saved.',
    'import_upload_rule_limit' => 'Files are limited to 10 MB.',
    'import_upload_rule_time' => 'It might take up to a minute to upload the contacts and process them. Please be patient.',
    'import_upload_rule_cant_revert' => 'Please make sure data is accurate before uploading, as you can’t undo the upload.',
    'import_upload_form_file' => 'Your <code>.vcf</code> or <code>.vCard</code> file:',
    'import_upload_behaviour' => 'Import behaviour:',
    'import_upload_behaviour_add' => 'Add new contacts and skip existing',
    'import_upload_behaviour_replace' => 'Replace existing contacts',
    'import_upload_behaviour_help' => 'Replacing will replace all data found in the vCard, but will keep existing contact fields.',
    'import_report_title' => 'Importing report',
    'import_report_date' => 'Date of the import',
    'import_report_type' => 'Type of import',
    'import_report_number_contacts' => 'Number of contacts in the file',
    'import_report_number_contacts_imported' => 'Number of imported contacts',
    'import_report_number_contacts_skipped' => 'Number of skipped contacts',
    'import_report_status_imported' => 'Imported',
    'import_report_status_skipped' => 'Skipped',
    'import_vcard_parse_error' => 'Error when parsing the vCard entry',
    'import_vcard_contact_exist' => 'Contact already exists',
    'import_vcard_contact_no_firstname' => 'No first name (mandatory)',
    'import_vcard_file_not_found' => 'File not found',
    'import_vcard_unknown_entry' => 'Unknown contact name',
    'import_vcard_file_no_entries' => 'File contains no entries',
    'import_blank_title' => 'You haven’t imported any contacts yet.',
    'import_blank_question' => 'Would you like to import contacts now?',
    'import_blank_description' => 'We can import vCard files that you can get from Google Contacts or your Contact manager.',
    'import_blank_cta' => 'Import vCard',
    'import_need_subscription' => 'Importing data requires a subscription.',

    'tags_list_title' => 'Tags',
    'tags_list_description' => 'You can organize your contacts by setting up tags. Tags work like folders, but you can add more than one tag to a contact.',
    'tags_list_contact_number' => '1 contact|:count contacts',
    'tags_list_delete_success' => 'The tag has been successfully with success',
    'tags_list_delete_confirmation' => 'Are you sure you want to delete the tag? No contacts will be deleted, only the tag.',
    'tags_blank_title' => 'Tags are a great way of categorizing your contacts.',
    'tags_blank_description' => 'Tags work like folders, but you can add more than one tag to a contact. Go to a contact and tag a friend, right below the name. Once a contact is tagged, come back here to manage all the tags in your account.',

    'api_title' => 'Доступ к API',
    'api_description' => 'API может использоваться для работы с данными Monica из внешнего приложения, например – мобильного приложения.',
    'api_help' => 'To use the API, a token is mandatory. You can either create a personal access token (Bearer authentication), or authorize an OAuth client to create it for you. See <a href=":url">API documentation</a>.',
    'api_endpoint' => 'Конечная точка API для этого экземпляра Monica:',

    'api_personal_access_tokens' => 'Personal access tokens',
    'api_pao_description' => 'Make sure you give this token to a source you trust – as they allow you to access all your data.',
    'api_token_title' => 'Personal Access Tokens',
    'api_token_create_new' => 'Create New Token',
    'api_token_not_created' => 'You have not created any personal access tokens.',
    'api_token_name' => 'Token name',
    'api_token_expire' => 'Expires at {date}',
    'api_token_delete' => 'Delete',
    'api_token_create' => 'Create Token',
    'api_token_scopes' => 'Scopes',
    'api_token_help' => 'Here is your new personal access token. This is the only time it will be shown so don’t lose it! You may now use this token to make API requests.',

    'api_oauth_clients' => 'Ваши клиенты OAuth',
    'api_oauth_clients_desc' => 'This section lets you register your own OAuth clients.',
    'api_oauth_clients_desc2' => 'Use this client id to request a new token, and convert authorization codes to access tokens. See <a href="{url}">Laravel Passport documentation</a> for more information.',
    'api_oauth_title' => 'Клиенты OAuth',
    'api_oauth_create_new' => 'Create New Client',
    'api_oauth_edit' => 'Edit Client',
    'api_oauth_not_created' => 'You have not created any OAuth clients.',
    'api_oauth_clientid' => 'Client ID',
    'api_oauth_name' => 'Name',
    'api_oauth_name_help' => 'Something your users will recognize and trust.',
    'api_oauth_secret' => 'Secret',
    'api_oauth_create' => 'Create Client',
    'api_oauth_redirecturl' => 'Redirect URL',
    'api_oauth_redirecturl_help' => 'Your application’s authorization callback URL.',

    'api_authorized_clients' => 'List of authorized clients',
    'api_authorized_clients_desc' => 'This section lists all the clients you’ve authorized to access your application data. You can revoke this authorization at anytime.',
    'api_authorized_clients_title' => 'Authorized Applications',
    'api_authorized_clients_none' => 'There are no authorized clients yet.',
    'api_authorized_clients_name' => 'Name',
    'api_authorized_clients_scopes' => 'Scopes',

    'personalization_tab_title' => 'Personalize your account',

    'personalization_title' => 'Here you will find different settings to configure your account. These features are intended for “power users” who want maximum control over Monica.',
    'personalization_contact_field_type_title' => 'Contact field types',
    'personalization_contact_field_type_add' => 'Add new field type',
    'personalization_contact_field_type_description' => 'You can configure all the different types of contact fields that you can associate to all your contacts. For example, if a new social network appears in the future, you will be able to add this new way of communicating with your contacts right here.',
    'personalization_contact_field_type_table_name' => 'Name',
    'personalization_contact_field_type_table_protocol' => 'Protocol',
    'personalization_contact_field_type_table_actions' => 'Actions',
    'personalization_contact_field_type_modal_title' => 'Add a new contact field type',
    'personalization_contact_field_type_modal_edit_title' => 'Edit an existing contact field type',
    'personalization_contact_field_type_modal_delete_title' => 'Delete an existing contact field type',
    'personalization_contact_field_type_modal_delete_description' => 'Are you sure you want to delete this contact field type? Deleting this type of contact field will delete ALL the data with this type for all of your contacts.',
    'personalization_contact_field_type_modal_name' => 'Name',
    'personalization_contact_field_type_modal_protocol' => 'Protocol (optional)',
    'personalization_contact_field_type_modal_protocol_help' => 'Each new contact field type can be clickable. If a protocol is set, we will use it to trigger the action that is set.',
    'personalization_contact_field_type_modal_icon' => 'Icon (optional)',
    'personalization_contact_field_type_modal_icon_help' => 'You can associate an icon with this contact field type. You need to add a reference to a Font Awesome icon.',
    'personalization_contact_field_type_delete_success' => 'The contact field type has been successfully deleted.',
    'personalization_contact_field_type_add_success' => 'The contact field type has been successfully added.',
    'personalization_contact_field_type_edit_success' => 'The contact field type has been successfully updated.',

    'personalization_genders_title' => 'Gender types',
    'personalization_genders_add' => 'Add new gender type',
    'personalization_genders_desc' => 'You can define as many genders as you need to. You need at least one gender type in your account.',
    'personalization_genders_modal_add' => 'Add gender type',
    'personalization_genders_modal_edit' => 'Update gender type',
    'personalization_genders_modal_name' => 'Name',
    'personalization_genders_modal_name_help' => 'The name used to display the gender on a contact page.',
    'personalization_genders_modal_sex' => 'Sex',
    'personalization_genders_modal_sex_help' => 'Used to define the relationships, and during the VCard import/export process.',
    'personalization_genders_modal_default' => 'Select the default gender for a new contact',
    'personalization_genders_modal_delete' => 'Delete gender type',
    'personalization_genders_modal_delete_desc' => 'Are you sure you want to delete the gender “{name}”?',
    'personalization_genders_modal_delete_question' => 'You currently have {count} contact with this gender. If you delete this gender, what gender should this contact have?|You currently have {count} contacts with this gender. If you delete this gender, what gender should these contacts have?',
    'personalization_genders_modal_delete_question_default' => 'This gender is the default one. If you delete this gender, which one will be the new default?',
    'personalization_genders_modal_error' => 'Please choose a gender from the list.',
    'personalization_genders_list_contact_number' => '{count} contact|{count} contacts',
    'personalization_genders_table_name' => 'Name',
    'personalization_genders_table_sex' => 'Sex',
    'personalization_genders_table_default' => 'Default',
    'personalization_genders_default' => 'Default gender',
    'personalization_genders_make_default' => 'Change default gender',
    'personalization_genders_select_default' => 'Select default gender',
    'personalization_genders_m' => 'Male',
    'personalization_genders_f' => 'Female',
    'personalization_genders_o' => 'Other',
    'personalization_genders_u' => 'Unknown',
    'personalization_genders_n' => 'None or not applicable',

    'personalization_reminder_rule_save' => 'The change has been saved',
    'personalization_reminder_rule_title' => 'Reminder rules',
    'personalization_reminder_rule_line' => '{count} day before|{count} days before',
    'personalization_reminder_rule_desc' => 'For every reminder that you set, Monica can send you an email a number of days before the event happens.  You can adjust these notification settings here. These notifications only apply to monthly and yearly reminders.',

    'personalization_module_save' => 'The change has been saved',
    'personalization_module_title' => 'Features',
    'personalization_module_desc' => 'You may not need all of Monica’s features. Below you can toggle specific features that are used on a contact sheet. This change will affect ALL your contacts. Turning off a feature does not delete any data, it simply hides the feature.',

    'personalisation_paid_upgrade' => 'This is a premium feature that requires a Paid subscription to be active. Upgrade your account by visiting <a href=":url">Settings > Subscription</a>.',
    'personalisation_paid_upgrade_vue' => 'This is a premium feature that requires a Paid subscription to be active. Upgrade your account by visiting <a href="{url}">Settings > Subscription</a>.',

    'reminder_time_to_send' => 'Time of the day reminders will be sent',
    'reminder_time_to_send_help' => 'Your next reminder is scheduled to be sent on <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Activity type categories',
    'personalization_activity_type_category_add' => 'Add a new activity type category',
    'personalization_activity_type_category_table_name' => 'Name',
    'personalization_activity_type_category_description' => 'An activity with one of your contacts can have a type and a category type. Your account comes with a set of predefined category types by default, but you can customize these here.',
    'personalization_activity_type_category_table_actions' => 'Actions',
    'personalization_activity_type_category_modal_add' => 'Add a new activity type category',
    'personalization_activity_type_category_modal_edit' => 'Edit an activity type category',
    'personalization_activity_type_category_modal_question' => 'What should we name this new category?',
    'personalization_activity_type_add_button' => 'Add a new activity type',
    'personalization_activity_type_modal_add' => 'Add a new activity type',
    'personalization_activity_type_modal_question' => 'What should we name this new activity type?',
    'personalization_activity_type_modal_edit' => 'Edit an activity type',
    'personalization_activity_type_category_modal_delete' => 'Delete an activity type category',
    'personalization_activity_type_category_modal_delete_desc' => 'Are you sure you want to delete this category? Deleting it will delete all associated activity types. Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete' => 'Delete an activity type',
    'personalization_activity_type_modal_delete_desc' => 'Are you sure you want to delete this activity type? Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete_error' => 'We can’t find this activity type.',
    'personalization_activity_type_category_modal_delete_error' => 'We can’t find this activity type category.',

    'personalization_life_event_category_title' => 'Life event categories',
    'personalization_live_event_category_table_name' => 'Name',
    'personalization_life_event_category_description' => 'A life event can have a type and a category. Your account comes with a set of predefined categories and types by default, but you can customize life event types here.',
    'personalization_live_event_category_table_actions' => 'Actions',
    'personalization_life_event_type_add_button' => 'Add a new life event type',
    'personalization_life_event_type_modal_add' => 'Add a new life event type',
    'personalization_life_event_type_modal_question' => 'What should we name this new life event type?',
    'personalization_life_event_type_modal_edit' => 'Edit a life event type',
    'personalization_life_event_type_modal_delete' => 'Delete a life event type',
    'personalization_life_event_type_modal_delete_desc' => 'Are you sure you want to delete this life event type? Life events that belong to this type will be deleted by performing this action.',
    'personalization_life_event_type_modal_delete_error' => 'We can’t find this life event type.',

    'personalization_life_event_category_work_education' => 'Work & education',
    'personalization_life_event_category_family_relationships' => 'Family & relationships',
    'personalization_life_event_category_home_living' => 'Home & living',
    'personalization_life_event_category_travel_experiences' => 'Travel & experiences',
    'personalization_life_event_category_health_wellness' => 'Health & wellness',

    'personalization_life_event_type_new_job' => 'New job',
    'personalization_life_event_type_retirement' => 'Retirement',
    'personalization_life_event_type_new_school' => 'New school',
    'personalization_life_event_type_study_abroad' => 'Study abroad',
    'personalization_life_event_type_volunteer_work' => 'Volunteer work',
    'personalization_life_event_type_published_book_or_paper' => 'Published a book or paper',
    'personalization_life_event_type_military_service' => 'Military service',
    'personalization_life_event_type_first_met' => 'First met',
    'personalization_life_event_type_new_relationship' => 'New relationship',
    'personalization_life_event_type_engagement' => 'Engagement',
    'personalization_life_event_type_marriage' => 'Marriage',
    'personalization_life_event_type_anniversary' => 'Anniversary',
    'personalization_life_event_type_expecting_a_baby' => 'Expecting a baby',
    'personalization_life_event_type_new_child' => 'New child',
    'personalization_life_event_type_new_family_member' => 'New family member',
    'personalization_life_event_type_new_pet' => 'New pet',
    'personalization_life_event_type_end_of_relationship' => 'End of relationship',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Loss of a loved one',
    'personalization_life_event_type_moved' => 'Moved',
    'personalization_life_event_type_bought_a_home' => 'Bought a home',
    'personalization_life_event_type_home_improvement' => 'Home improvement',
    'personalization_life_event_type_holidays' => 'Holidays',
    'personalization_life_event_type_new_vehicle' => 'New vehicle',
    'personalization_life_event_type_new_roommate' => 'New roommate',
    'personalization_life_event_type_overcame_an_illness' => 'Overcame an illness',
    'personalization_life_event_type_quit_a_habit' => 'Quit a habit',
    'personalization_life_event_type_new_eating_habits' => 'New eating habits',
    'personalization_life_event_type_weight_loss' => 'Weight loss',
    'personalization_life_event_type_wear_glass_or_contact' => 'Started wearing glasses or contacts',
    'personalization_life_event_type_broken_bone' => 'Broke a bone',
    'personalization_life_event_type_removed_braces' => 'Had braces removed',
    'personalization_life_event_type_surgery' => 'Had surgery',
    'personalization_life_event_type_dentist' => 'Had dental treatment',
    'personalization_life_event_type_new_sport' => 'Started playing a new sport',
    'personalization_life_event_type_new_hobby' => 'Took up a new hobby',
    'personalization_life_event_type_new_instrument' => 'Started learning a new instrument',
    'personalization_life_event_type_new_language' => 'Started learning a new language',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tattoo or piercing',
    'personalization_life_event_type_new_license' => 'New license',
    'personalization_life_event_type_travel' => 'Travel',
    'personalization_life_event_type_achievement_or_award' => 'Achievement or award',
    'personalization_life_event_type_changed_beliefs' => 'Changed beliefs',
    'personalization_life_event_type_first_word' => 'First word',
    'personalization_life_event_type_first_kiss' => 'First kiss',

    'storage_title' => 'Storage',
    'storage_account_info' => 'Your account limit is :accountLimit MB. Your current usage is :currentAccountSize MB (about :percentUsage%).',
    'storage_upgrade_notice' => 'Upgrade your account to be able to upload documents and photos.',
    'storage_description' => 'Here you can see all the documents and photos uploaded about your contacts.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Here you can find all settings to use WebDAV resources for CardDAV and CalDAV exports.',
    'dav_copy_help' => 'Copy into your clipboard',
    'dav_clipboard_copied' => 'Value copied into your clipboard',
    'dav_url_base' => 'Base url for all CardDAV and CalDAV resources:',
    'dav_connect_help' => 'You can connect your contacts and/or calendars with this base url on you phone or computer.',
    'dav_connect_help2' => 'Use your login (email) and create an API token as the password to authenticate.',
    'dav_url_carddav' => 'CardDAV url for Contacts resource:',
    'dav_url_caldav_birthdays' => 'CalDAV url for Birthdays resources:',
    'dav_url_caldav_tasks' => 'CalDAV url for Tasks resources:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Export all contacts in one file',
    'dav_caldav_birthdays_export' => 'Export all birthdays in one file',
    'dav_caldav_tasks_export' => 'Export all tasks in one file',

    'archive_title' => 'Archive all of the contacts in your account',
    'archive_desc' => 'This will archive all of the contacts in your account.',
    'archive_cta' => 'Archive all of your contacts',

    'logs_title' => 'Everything that has happened to this account',
    'logs_actor' => 'Actor',
    'logs_timestamp' => 'Timestamp',
    'logs_description' => 'Description',
    'logs_subject' => 'Subject',
    'logs_size' => 'Size (Kb)',
    'logs_object' => 'Object',
];
