/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.conference.AddOrRemove;
import org.jitsi.jicofo.conference.SourceSignalingKt;
import org.jitsi.jicofo.conference.SourcesToAddOrRemove;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.utils.MediaType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\f\u0010!\u001a\u00020\r*\u00020\rH\u0002R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jitsi/jicofo/conference/SourceSignaling;", "", "audio", "", "video", "stripSimulcast", "supportsReceivingMultipleStreams", "(ZZZZ)V", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "mutedDesktopSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "signaledSources", "supportedMediaTypes", "", "Lorg/jitsi/utils/MediaType;", "updatedSources", "addSources", "", "sourcesToAdd", "remoteDesktopSourceIsMutedChanged", "owner", "Lorg/jxmpp/jid/Jid;", "muted", "removeSources", "sourcesToRemove", "reset", "s", "update", "", "Lorg/jitsi/jicofo/conference/SourcesToAddOrRemove;", "filter", "jicofo"})
public final class SourceSignaling {
    private final boolean stripSimulcast;
    private final boolean supportsReceivingMultipleStreams;
    @NotNull
    private final Set<MediaType> supportedMediaTypes;
    @NotNull
    private ConferenceSourceMap signaledSources;
    @NotNull
    private ConferenceSourceMap updatedSources;
    @NotNull
    private final ConferenceSourceMap mutedDesktopSources;

    /*
     * WARNING - void declaration
     */
    public SourceSignaling(boolean audio, boolean video, boolean stripSimulcast2, boolean supportsReceivingMultipleStreams) {
        void $this$supportedMediaTypes_u24lambda_u2d0;
        Set set;
        this.stripSimulcast = stripSimulcast2;
        this.supportsReceivingMultipleStreams = supportsReceivingMultipleStreams;
        Set set2 = set = SetsKt.createSetBuilder();
        SourceSignaling sourceSignaling = this;
        boolean bl = false;
        if (audio) {
            $this$supportedMediaTypes_u24lambda_u2d0.add(MediaType.AUDIO);
        }
        if (video) {
            $this$supportedMediaTypes_u24lambda_u2d0.add(MediaType.VIDEO);
        }
        sourceSignaling.supportedMediaTypes = SetsKt.build(set);
        this.signaledSources = new ConferenceSourceMap(null, 1, null);
        this.updatedSources = new ConferenceSourceMap(null, 1, null);
        this.mutedDesktopSources = new ConferenceSourceMap(null, 1, null);
    }

    public /* synthetic */ SourceSignaling(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        if ((n & 8) != 0) {
            bl4 = true;
        }
        this(bl, bl2, bl3, bl4);
    }

    public final void addSources(@NotNull ConferenceSourceMap sourcesToAdd) {
        Intrinsics.checkNotNullParameter(sourcesToAdd, "sourcesToAdd");
        Iterable $this$forEach$iv = sourcesToAdd.copy().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EndpointSourceSet desktopSources;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Jid owner = (Jid)entry.getKey();
            EndpointSourceSet ess = (EndpointSourceSet)entry.getValue();
            if (!Intrinsics.areEqual(this.mutedDesktopSources.get((Object)owner), SourceSignalingKt.access$getNO_SOURCES$p()) || (desktopSources = SourceSignalingKt.access$getDesktopSources(ess)).isEmpty()) continue;
            this.mutedDesktopSources.remove((Object)owner);
            this.mutedDesktopSources.add(owner, desktopSources);
            sourcesToAdd.remove(new ConferenceSourceMap(owner, desktopSources));
        }
        this.updatedSources.add(sourcesToAdd);
    }

    public final void removeSources(@NotNull ConferenceSourceMap sourcesToRemove) {
        Intrinsics.checkNotNullParameter(sourcesToRemove, "sourcesToRemove");
        this.updatedSources.remove(sourcesToRemove);
        this.mutedDesktopSources.remove(sourcesToRemove);
    }

    @NotNull
    public final List<SourcesToAddOrRemove> update() {
        List<SourcesToAddOrRemove> list;
        ConferenceSourceMap ss = this.filter(this.signaledSources);
        ConferenceSourceMap us = this.filter(this.updatedSources);
        ConferenceSourceMap sourcesToAdd = us.minus(ss);
        ConferenceSourceMap sourcesToRemove = ss.minus(us);
        this.reset(this.updatedSources);
        List<SourcesToAddOrRemove> $this$update_u24lambda_u2d2 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (!((Map)sourcesToRemove).isEmpty()) {
            $this$update_u24lambda_u2d2.add(new SourcesToAddOrRemove(AddOrRemove.Remove, sourcesToRemove));
        }
        if (!((Map)sourcesToAdd).isEmpty()) {
            $this$update_u24lambda_u2d2.add(new SourcesToAddOrRemove(AddOrRemove.Add, sourcesToAdd));
        }
        return CollectionsKt.build(list);
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u2d5 = jSONObject = new JSONObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u2d5).put("signaled_sources", this.signaledSources.toJson());
        ((Map)$this$_get_debugState__u24lambda_u2d5).put("sources", this.updatedSources.toJson());
        Map map = $this$_get_debugState__u24lambda_u2d5;
        String string = "supported_media_types";
        JSONArray $this$_get_debugState__u24lambda_u2d5_u24lambda_u2d4 = jSONArray = new JSONArray();
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.supportedMediaTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaType it = (MediaType)((Object)element$iv);
            boolean bl3 = false;
            $this$_get_debugState__u24lambda_u2d5_u24lambda_u2d4.add(it.toString());
        }
        map.put(string, jSONArray);
        return jSONObject;
    }

    @NotNull
    public final ConferenceSourceMap reset(@NotNull ConferenceSourceMap s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        this.signaledSources = s2.copy();
        this.updatedSources = this.signaledSources.copy();
        return this.filter(s2);
    }

    private final ConferenceSourceMap filter(ConferenceSourceMap $this$filter) {
        ConferenceSourceMap conferenceSourceMap;
        ConferenceSourceMap $this$filter_u24lambda_u2d6 = conferenceSourceMap = $this$filter.copy();
        boolean bl = false;
        $this$filter_u24lambda_u2d6.stripByMediaType(this.supportedMediaTypes);
        if (this.stripSimulcast) {
            $this$filter_u24lambda_u2d6.stripSimulcast();
        }
        if (!this.supportsReceivingMultipleStreams) {
            SourceSignalingKt.access$filterMultiStream($this$filter_u24lambda_u2d6);
        }
        return conferenceSourceMap;
    }

    public final void remoteDesktopSourceIsMutedChanged(@NotNull Jid owner, boolean muted) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        if (muted) {
            EndpointSourceSet endpointSourceSet = (EndpointSourceSet)this.updatedSources.get((Object)owner);
            if (endpointSourceSet == null) {
                endpointSourceSet = new EndpointSourceSet(null, null, 3, null);
            }
            EndpointSourceSet allParticipantSources = endpointSourceSet;
            EndpointSourceSet desktopSources = SourceSignalingKt.access$getDesktopSources(allParticipantSources);
            this.updatedSources.remove(new ConferenceSourceMap(owner, desktopSources));
            this.mutedDesktopSources.add(owner, desktopSources.isEmpty() ? SourceSignalingKt.access$getNO_SOURCES$p() : desktopSources);
        } else {
            EndpointSourceSet unmutedDesktopSources = (EndpointSourceSet)this.mutedDesktopSources.get((Object)owner);
            this.mutedDesktopSources.remove((Object)owner);
            if (unmutedDesktopSources != null && !Intrinsics.areEqual(unmutedDesktopSources, SourceSignalingKt.access$getNO_SOURCES$p())) {
                this.updatedSources.add(owner, unmutedDesktopSources);
            }
        }
    }

    public SourceSignaling() {
        this(false, false, false, false, 15, null);
    }
}

