/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.JicofoConfig;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class RegionBasedBridgeSelectionStrategy
extends BridgeSelectionStrategy {
    private static final Logger logger = new LoggerImpl(RegionBasedBridgeSelectionStrategy.class.getName());
    private final Map<String, Set<String>> regionGroups = new HashMap<String, Set<String>>();
    public final String localRegion = JicofoConfig.config.localRegion();

    public RegionBasedBridgeSelectionStrategy() {
        BridgeConfig.config.getRegionGroups().forEach(regionGroup -> regionGroup.forEach(region -> this.regionGroups.put((String)region, (Set<String>)regionGroup)));
    }

    @NotNull
    private Set<String> getRegionGroup(String region) {
        Set<String> regionGroup = this.regionGroups.get(region);
        return regionGroup != null ? regionGroup : Collections.singleton(region);
    }

    @Override
    public Bridge doSelect(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        String r;
        if (bridges.isEmpty()) {
            return null;
        }
        String string = r = participantRegion == null ? this.localRegion : participantRegion;
        if (this.localRegion != null) {
            Set<String> regionGroup = this.getRegionGroup(r);
            if (conferenceBridges.isEmpty() && !Objects.equals(r, JicofoConfig.config.localRegion()) && regionGroup.contains(this.localRegion)) {
                r = this.localRegion;
            }
            if (bridges.stream().noneMatch(b -> regionGroup.contains(b.getRegion()))) {
                r = this.localRegion;
            }
        }
        String region = r;
        return this.notLoadedAlreadyInConferenceInRegion(bridges, conferenceBridges, region).orElseGet(() -> this.notLoadedAlreadyInConferenceInRegionGroup(bridges, conferenceBridges, this.getRegionGroup(region)).orElseGet(() -> this.notLoadedInRegion(bridges, conferenceBridges, region).orElseGet(() -> this.notLoadedInRegionGroup(bridges, conferenceBridges, this.getRegionGroup(region)).orElseGet(() -> this.leastLoadedAlreadyInConferenceInRegion(bridges, conferenceBridges, region).orElseGet(() -> this.leastLoadedAlreadyInConferenceInRegionGroup(bridges, conferenceBridges, this.getRegionGroup(region)).orElseGet(() -> this.leastLoadedInRegion(bridges, conferenceBridges, region).orElseGet(() -> this.leastLoadedInRegionGroup(bridges, conferenceBridges, this.getRegionGroup(region)).orElseGet(() -> this.nonLoadedAlreadyInConference(bridges, conferenceBridges, region).orElseGet(() -> this.leastLoaded(bridges, conferenceBridges, region).orElse(null))))))))));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with region groups:" + BridgeConfig.config.getRegionGroups();
    }

    @Override
    public Bridge select(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion, boolean allowMultiBridge) {
        if (!allowMultiBridge) {
            logger.warn("Octo is disabled, but the selection strategy is RegionBased. Enable octo in jicofo.conf to allow use of multiple bridges in a conference.");
        }
        return super.select(bridges, conferenceBridges, participantRegion, allowMultiBridge);
    }
}

