/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.mysql.conf;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.TimeZone;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicy;
import org.apache.guacamole.auth.mysql.conf.MySQLDriver;
import org.apache.guacamole.auth.mysql.conf.MySQLGuacamoleProperties;
import org.apache.guacamole.auth.mysql.conf.MySQLPasswordPolicy;
import org.apache.guacamole.auth.mysql.conf.MySQLSSLMode;
import org.apache.guacamole.auth.mysql.conf.MySQLVersion;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLEnvironment
extends JDBCEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(MySQLEnvironment.class);
    private static final MySQLVersion MARIADB_SUPPORTS_CTE = new MySQLVersion(10, 2, 2, true);
    private static final MySQLVersion MYSQL_SUPPORTS_CTE = new MySQLVersion(8, 0, 1, false);
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 3306;
    private static final boolean DEFAULT_USER_REQUIRED = false;
    private final int DEFAULT_ABSOLUTE_MAX_CONNECTIONS = 0;
    private final int DEFAULT_MAX_CONNECTIONS_PER_USER = 1;
    private final int DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER = 1;
    private final int DEFAULT_MAX_CONNECTIONS = 0;
    private final int DEFAULT_MAX_GROUP_CONNECTIONS = 0;
    private final MySQLSSLMode DEFAULT_SSL_MODE = MySQLSSLMode.PREFERRED;

    @Override
    public boolean isUserRequired() throws GuacamoleException {
        return (Boolean)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_USER_REQUIRED, false);
    }

    @Override
    public int getAbsoluteMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_ABSOLUTE_MAX_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_DEFAULT_MAX_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxGroupConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_DEFAULT_MAX_GROUP_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_DEFAULT_MAX_CONNECTIONS_PER_USER, 1);
    }

    @Override
    public int getDefaultMaxGroupConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER, 1);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() {
        return new MySQLPasswordPolicy(this);
    }

    public MySQLDriver getMySQLDriver() throws GuacamoleException {
        MySQLDriver driver = (MySQLDriver)((Object)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_DRIVER));
        if (driver != null) {
            return driver;
        }
        if (MySQLDriver.MARIADB.isInstalled()) {
            logger.info("Installed JDBC driver for MySQL/MariaDB detected as \"MariaDB Connector/J\".");
            return MySQLDriver.MARIADB;
        }
        if (MySQLDriver.MYSQL.isInstalled()) {
            logger.info("Installed JDBC driver for MySQL/MariaDB detected as \"MySQL Connector/J\".");
            return MySQLDriver.MYSQL;
        }
        throw new GuacamoleServerException("No JDBC driver for MySQL/MariaDB is installed.");
    }

    public String getMySQLHostname() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_HOSTNAME, DEFAULT_HOSTNAME);
    }

    public int getMySQLPort() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_PORT, 3306);
    }

    public String getMySQLDatabase() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_DATABASE);
    }

    @Override
    public String getUsername() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_USERNAME);
    }

    @Override
    public String getPassword() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_PASSWORD);
    }

    @Override
    public boolean isRecursiveQuerySupported(SqlSession session) {
        String versionString;
        try {
            Connection connection = session.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            versionString = metaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot determine whether MySQL / MariaDB supports recursive queries.", e);
        }
        try {
            MySQLVersion version = new MySQLVersion(versionString);
            logger.debug("Database recognized as {}.", (Object)version);
            return version.isAtLeast(MARIADB_SUPPORTS_CTE) || version.isAtLeast(MYSQL_SUPPORTS_CTE);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unrecognized MySQL / MariaDB version string: \"{}\". Assuming database engine does not support recursive queries.", (Object)session);
            return false;
        }
    }

    public MySQLSSLMode getMySQLSSLMode() throws GuacamoleException {
        return (MySQLSSLMode)((Object)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_SSL_MODE, (Object)this.DEFAULT_SSL_MODE));
    }

    public File getMySQLSSLTrustStore() throws GuacamoleException {
        return (File)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_SSL_TRUST_STORE);
    }

    public String getMySQLSSLTrustPassword() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_SSL_TRUST_PASSWORD);
    }

    public File getMySQLSSLClientStore() throws GuacamoleException {
        return (File)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_SSL_CLIENT_STORE);
    }

    public String getMYSQLSSLClientPassword() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_SSL_CLIENT_PASSWORD);
    }

    @Override
    public boolean autoCreateAbsentAccounts() throws GuacamoleException {
        return (Boolean)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.MYSQL_AUTO_CREATE_ACCOUNTS, false);
    }

    public TimeZone getServerTimeZone() throws GuacamoleException {
        return (TimeZone)this.getProperty((GuacamoleProperty)MySQLGuacamoleProperties.SERVER_TIMEZONE);
    }
}

