/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.log4j2;

import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.log4j2.Log4j2Impl;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class Log4j2AbstractLoggerImpl
implements Log {
    private static final Marker MARKER = MarkerManager.getMarker((String)"MYBATIS");
    private static final String FQCN = Log4j2Impl.class.getName();
    private final ExtendedLoggerWrapper log;

    public Log4j2AbstractLoggerImpl(AbstractLogger abstractLogger) {
        this.log = new ExtendedLoggerWrapper((ExtendedLogger)abstractLogger, abstractLogger.getName(), abstractLogger.getMessageFactory());
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void error(String s2, Throwable e) {
        this.log.logIfEnabled(FQCN, Level.ERROR, MARKER, (Message)new SimpleMessage(s2), e);
    }

    @Override
    public void error(String s2) {
        this.log.logIfEnabled(FQCN, Level.ERROR, MARKER, (Message)new SimpleMessage(s2), null);
    }

    @Override
    public void debug(String s2) {
        this.log.logIfEnabled(FQCN, Level.DEBUG, MARKER, (Message)new SimpleMessage(s2), null);
    }

    @Override
    public void trace(String s2) {
        this.log.logIfEnabled(FQCN, Level.TRACE, MARKER, (Message)new SimpleMessage(s2), null);
    }

    @Override
    public void warn(String s2) {
        this.log.logIfEnabled(FQCN, Level.WARN, MARKER, (Message)new SimpleMessage(s2), null);
    }
}

