/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.activeconnection;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.activeconnection.ActiveConnectionService;
import org.apache.guacamole.auth.jdbc.activeconnection.TrackedActiveConnection;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.Directory;

public class ActiveConnectionDirectory
extends RestrictedObject
implements Directory<ActiveConnection> {
    @Inject
    private ActiveConnectionService activeConnectionService;

    public ActiveConnection get(String identifier) throws GuacamoleException {
        return this.activeConnectionService.retrieveObject(this.getCurrentUser(), identifier);
    }

    public Collection<ActiveConnection> getAll(Collection<String> identifiers) throws GuacamoleException {
        Collection<TrackedActiveConnection> objects = this.activeConnectionService.retrieveObjects(this.getCurrentUser(), identifiers);
        return Collections.unmodifiableCollection(objects);
    }

    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.activeConnectionService.getIdentifiers(this.getCurrentUser());
    }

    public void add(ActiveConnection object) throws GuacamoleException {
        this.activeConnectionService.createObject(this.getCurrentUser(), object);
    }

    public void update(ActiveConnection object) throws GuacamoleException {
        TrackedActiveConnection connection = (TrackedActiveConnection)object;
        this.activeConnectionService.updateObject(this.getCurrentUser(), connection);
    }

    public void remove(String identifier) throws GuacamoleException {
        this.activeConnectionService.deleteObject(this.getCurrentUser(), identifier);
    }
}

