/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Comparator;
import org.jboss.galleon.runtime.ResolvedFeature;

class CircularRefInfo {
    private static Comparator<CircularRefInfo> firstInConfigComparator;
    private static Comparator<CircularRefInfo> nextOnPathComparator;
    final ResolvedFeature loopedOn;
    ResolvedFeature firstInConfig;
    ResolvedFeature nextOnPath;

    static Comparator<CircularRefInfo> getFirstInConfigComparator() {
        if (firstInConfigComparator == null) {
            firstInConfigComparator = new Comparator<CircularRefInfo>(){

                @Override
                public int compare(CircularRefInfo o1, CircularRefInfo o2) {
                    return o1.firstInConfig.includeNo - o2.firstInConfig.includeNo;
                }
            };
        }
        return firstInConfigComparator;
    }

    static Comparator<CircularRefInfo> getNextOnPathComparator() {
        if (nextOnPathComparator == null) {
            nextOnPathComparator = new Comparator<CircularRefInfo>(){

                @Override
                public int compare(CircularRefInfo o1, CircularRefInfo o2) {
                    return o1.nextOnPath.includeNo - o2.nextOnPath.includeNo;
                }
            };
        }
        return nextOnPathComparator;
    }

    CircularRefInfo(ResolvedFeature start) {
        this.loopedOn = start;
        this.firstInConfig = start;
        this.nextOnPath = start;
    }

    void setNext(ResolvedFeature feature) {
        this.nextOnPath = feature;
        if (this.firstInConfig.includeNo > feature.includeNo) {
            this.firstInConfig = feature;
        }
    }
}

