/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ColourScheme;
import jalview.Conservation;
import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.SequenceGroup;
import java.awt.Color;

public class ConservationColourScheme
extends ResidueColourScheme {
    Conservation conserve;
    boolean byResidue = true;
    ColourScheme cs;
    int inc = 30;

    public ConservationColourScheme(SequenceGroup sequenceGroup, int n) {
        this(sequenceGroup);
        this.inc = n;
    }

    public ConservationColourScheme(SequenceGroup sequenceGroup) {
        this.conserve = sequenceGroup.conserve;
        this.colourThreshold = 7;
        this.cs = sequenceGroup.colourScheme;
    }

    public void setColours(DrawableSequence drawableSequence, int n) {
        Color color = Color.white;
        String string = drawableSequence.getSequence().substring(n, n + 1);
        try {
            if (this.colourThreshold > 0 && this.conserve.consSequence != null) {
                if (this.fullConservation(n)) {
                    color = this.byResidue ? this.findColour(drawableSequence, string, n) : Color.red;
                } else if (this.byResidue) {
                    int n2 = 10;
                    int n3 = Integer.parseInt(this.conserve.consSequence.sequence.substring(n, n + 1));
                    color = this.findColour(drawableSequence, string, n);
                    while (n2 >= n3) {
                        color = this.lighter(color, this.inc);
                        --n2;
                    }
                } else {
                    color = Color.yellow;
                }
            }
            drawableSequence.setResidueBoxColour(n, color);
            return;
        }
        catch (Exception exception) {
            drawableSequence.setResidueBoxColour(n, Color.white);
            return;
        }
    }

    public Color findColour(DrawableSequence drawableSequence, String string, int n) {
        return this.cs.findColour(drawableSequence, string, n);
    }

    public boolean fullConservation(int n) {
        String string = this.conserve.consSequence.sequence.substring(n, n + 1);
        return string.equals("*");
    }

    public boolean aboveThreshold(DrawableSequence drawableSequence, int n, int n2) {
        String string = this.conserve.consSequence.sequence.substring(n, n + 1);
        return Integer.parseInt(string) >= n2 || string.equals("*");
    }

    public Color lighter(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getBlue();
        int n4 = color.getGreen();
        n2 = n2 < 255 - n ? (n2 += n) : 255;
        n3 = n3 < 255 - n ? (n3 += n) : 255;
        n4 = n4 < 255 - n ? (n4 += n) : 255;
        return new Color(n2, n4, n3);
    }
}

