/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class AplicomProtocolDecoder
extends BaseProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AplicomProtocolDecoder.class);
    private static final long IMEI_BASE_TC65_V20 = 355631999483904L;
    private static final long IMEI_BASE_TC65_V28 = 358244010000000L;
    private static final long IMEI_BASE_TC65I_V11 = 353234015223808L;
    private static final int DEFAULT_SELECTOR_D = 764;
    private static final int DEFAULT_SELECTOR_E = 32764;
    private static final int DEFAULT_SELECTOR_F = 2045;
    private static final int EVENT_DATA = 119;

    public AplicomProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static boolean validateImei(long imei) {
        return Checksum.luhn(imei / 10L) == imei % 10L;
    }

    private static long imeiFromUnitId(long unitId) {
        if (unitId == 0L) {
            return 0L;
        }
        long imei = 353234015223808L + unitId;
        if (AplicomProtocolDecoder.validateImei(imei)) {
            return imei;
        }
        imei = 358244010000000L + (unitId + 688512L & 0xFFFFFFL);
        if (AplicomProtocolDecoder.validateImei(imei)) {
            return imei;
        }
        imei = 355631999483904L + unitId;
        if (AplicomProtocolDecoder.validateImei(imei)) {
            return imei;
        }
        return unitId;
    }

    private void decodeEventData(Position position, ByteBuf buf, int event) {
        switch (event) {
            case 2: 
            case 40: {
                buf.readUnsignedByte();
                break;
            }
            case 9: {
                buf.readUnsignedMedium();
                break;
            }
            case 31: 
            case 32: {
                buf.readUnsignedShort();
                break;
            }
            case 38: {
                buf.skipBytes(36);
                break;
            }
            case 113: {
                buf.readUnsignedInt();
                buf.readUnsignedByte();
                break;
            }
            case 119: {
                position.set("eventData", ByteBufUtil.hexDump((ByteBuf)buf, (int)buf.readerIndex(), (int)Math.min(buf.readableBytes(), 1024)));
                break;
            }
            case 121: 
            case 142: {
                buf.readLong();
                break;
            }
            case 130: {
                buf.readUnsignedInt();
                break;
            }
            case 188: {
                this.decodeEB(position, buf);
                break;
            }
        }
    }

    private void decodeCanData(ByteBuf buf, Position position) {
        int i;
        buf.readUnsignedMedium();
        position.set("versionFw", buf.readUnsignedByte());
        int count = buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedInt();
        buf.skipBytes(8);
        ArrayList<ByteBuf> values = new ArrayList<ByteBuf>(count);
        for (i = 0; i < count; ++i) {
            values.add(buf.readSlice(8));
        }
        block19: for (i = 0; i < count; ++i) {
            ByteBuf value = (ByteBuf)values.get(i);
            switch (buf.readInt()) {
                case 525: {
                    position.set("rpm", value.readShortLE());
                    position.set("dieselTemperature", (double)value.readShortLE() * 0.1);
                    position.set("batteryVoltage", (double)value.readShortLE() * 0.01);
                    position.set("supplyAirTempDep1", (double)value.readShortLE() * 0.1);
                    continue block19;
                }
                case 781: {
                    position.set("activeAlarm", ByteBufUtil.hexDump((ByteBuf)value));
                    continue block19;
                }
                case 1036: {
                    position.set("airTempDep1", (double)value.readShortLE() * 0.1);
                    position.set("airTempDep2", (double)value.readShortLE() * 0.1);
                    continue block19;
                }
                case 1037: {
                    position.set("coldUnitState", ByteBufUtil.hexDump((ByteBuf)value));
                    continue block19;
                }
                case 1292: {
                    position.set("defrostTempDep1", (double)value.readShortLE() * 0.1);
                    position.set("defrostTempDep2", (double)value.readShortLE() * 0.1);
                    continue block19;
                }
                case 1293: {
                    position.set("condenserPressure", (double)value.readShortLE() * 0.1);
                    position.set("suctionPressure", (double)value.readShortLE() * 0.1);
                    continue block19;
                }
                case 1420: {
                    value.readByte();
                    value.readShort();
                    switch (value.readByte()) {
                        case 1: {
                            position.set("setpointZone1", (double)value.readIntLE() * 0.1);
                            continue block19;
                        }
                        case 2: {
                            position.set("setpointZone2", (double)value.readIntLE() * 0.1);
                            continue block19;
                        }
                        case 5: {
                            position.set("unitType", value.readIntLE());
                            continue block19;
                        }
                        case 19: {
                            position.set("dieselHours", value.readIntLE() / 60 / 60);
                            continue block19;
                        }
                        case 20: {
                            position.set("electricHours", value.readIntLE() / 60 / 60);
                            continue block19;
                        }
                        case 23: {
                            position.set("serviceIndicator", value.readIntLE());
                            continue block19;
                        }
                        case 24: {
                            position.set("softwareVersion", (double)value.readIntLE() * 0.01);
                            continue block19;
                        }
                    }
                    continue block19;
                }
                default: {
                    LOGGER.warn("Aplicom CAN decoding error", (Throwable)new UnsupportedOperationException());
                }
            }
        }
    }

    private void decodeD(Position position, ByteBuf buf, int selector, int event) {
        if ((selector & 8) != 0) {
            position.setValid((buf.readUnsignedByte() & 0x40) != 0);
        } else {
            this.getLastLocation(position, null);
        }
        if ((selector & 4) != 0) {
            position.setDeviceTime(new Date(buf.readUnsignedInt() * 1000L));
        }
        if ((selector & 8) != 0) {
            position.setFixTime(new Date(buf.readUnsignedInt() * 1000L));
            if (position.getDeviceTime() == null) {
                position.setDeviceTime(position.getFixTime());
            }
            position.setLatitude((double)buf.readInt() / 1000000.0);
            position.setLongitude((double)buf.readInt() / 1000000.0);
            position.set("satVisible", buf.readUnsignedByte());
        }
        if ((selector & 0x10) != 0) {
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.set("maximumSpeed", buf.readUnsignedByte());
            position.setCourse((double)buf.readUnsignedByte() * 2.0);
        }
        if ((selector & 0x40) != 0) {
            position.set("input", buf.readUnsignedByte());
        }
        if ((selector & 0x20) != 0) {
            position.set("adc1", buf.readUnsignedShort());
            position.set("adc2", buf.readUnsignedShort());
            position.set("adc3", buf.readUnsignedShort());
            position.set("adc4", buf.readUnsignedShort());
        }
        if ((selector & 0x8000) != 0) {
            position.set("power", (double)buf.readUnsignedShort() * 0.001);
            position.set("battery", (double)buf.readUnsignedShort() * 0.001);
        }
        if ((selector & 0x10000) != 0) {
            buf.readUnsignedShort();
            buf.readUnsignedInt();
        }
        if ((selector & 0x20000) != 0) {
            buf.readUnsignedShort();
            buf.readUnsignedInt();
        }
        if ((selector & 0x80) != 0) {
            position.set("trip1", buf.readUnsignedInt());
        }
        if ((selector & 0x100) != 0) {
            position.set("trip2", buf.readUnsignedInt());
        }
        if ((selector & 0x40) != 0) {
            position.set("output", buf.readUnsignedByte());
        }
        if ((selector & 0x200) != 0) {
            position.set("driverUniqueId", String.valueOf((long)buf.readUnsignedShort() << 32) + buf.readUnsignedInt());
        }
        if ((selector & 0x400) != 0) {
            buf.readUnsignedByte();
        }
        if ((selector & 0x800) != 0) {
            position.setAltitude(buf.readShort());
        }
        if ((selector & 0x2000) != 0) {
            buf.readUnsignedShort();
        }
        if ((selector & 0x4000) != 0) {
            buf.skipBytes(8);
        }
        if ((selector & 0x80000) != 0) {
            buf.skipBytes(11);
        }
        if ((selector & 0x1000) != 0) {
            this.decodeEventData(position, buf, event);
        }
        if (this.getConfig().getBoolean(Keys.PROTOCOL_CAN.withPrefix(this.getProtocolName())) && buf.isReadable() && (selector & 0x1000) != 0 && event == 119) {
            this.decodeCanData(buf, position);
        }
    }

    private void decodeE(Position position, ByteBuf buf, int selector) {
        String card;
        if ((selector & 8) != 0) {
            position.set("tachographEvent", buf.readUnsignedShort());
        }
        if ((selector & 4) != 0) {
            this.getLastLocation(position, new Date(buf.readUnsignedInt() * 1000L));
        } else {
            this.getLastLocation(position, null);
        }
        if ((selector & 0x10) != 0) {
            String time = buf.readUnsignedByte() + "s " + buf.readUnsignedByte() + "m " + buf.readUnsignedByte() + "h " + buf.readUnsignedByte() + "M " + buf.readUnsignedByte() + "D " + buf.readUnsignedByte() + "Y " + buf.readByte() + "m " + buf.readByte() + "h";
            position.set("tachographTime", time);
        }
        position.set("workState", buf.readUnsignedByte());
        position.set("driver1State", buf.readUnsignedByte());
        position.set("driver2State", buf.readUnsignedByte());
        if ((selector & 0x20) != 0) {
            position.set("tachographStatus", buf.readUnsignedByte());
        }
        if ((selector & 0x40) != 0) {
            position.set("obdSpeed", (double)buf.readUnsignedShort() / 256.0);
        }
        if ((selector & 0x80) != 0) {
            position.set("obdOdometer", buf.readUnsignedInt() * 5L);
        }
        if ((selector & 0x100) != 0) {
            position.set("tripOdometer", buf.readUnsignedInt() * 5L);
        }
        if ((selector & 0x8000) != 0) {
            position.set("kFactor", (double)buf.readUnsignedShort() * 0.001 + " pulses/m");
        }
        if ((selector & 0x200) != 0) {
            position.set("rpm", (double)buf.readUnsignedShort() * 0.125);
        }
        if ((selector & 0x400) != 0) {
            position.set("extraInfo", buf.readUnsignedShort());
        }
        if ((selector & 0x800) != 0) {
            position.set("vin", buf.readSlice(18).toString(StandardCharsets.US_ASCII).trim());
        }
        if ((selector & 0x2000) != 0) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            card = buf.readSlice(20).toString(StandardCharsets.US_ASCII).trim();
            if (!card.isEmpty()) {
                position.set("card1", card);
            }
        }
        if ((selector & 0x4000) != 0) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            card = buf.readSlice(20).toString(StandardCharsets.US_ASCII).trim();
            if (!card.isEmpty()) {
                position.set("card2", card);
            }
        }
        if ((selector & 0x10000) != 0) {
            int count = buf.readUnsignedByte();
            for (int i = 1; i <= count; ++i) {
                position.set("driver" + i, buf.readSlice(22).toString(StandardCharsets.US_ASCII).trim());
                position.set("driverTime" + i, buf.readUnsignedInt());
            }
        }
    }

    private void decodeH(Position position, ByteBuf buf, int selector) {
        if ((selector & 4) != 0) {
            this.getLastLocation(position, new Date(buf.readUnsignedInt() * 1000L));
        } else {
            this.getLastLocation(position, null);
        }
        if ((selector & 0x40) != 0) {
            buf.readUnsignedInt();
        }
        if ((selector & 0x2000) != 0) {
            buf.readUnsignedShort();
        }
        int index = 1;
        while (buf.readableBytes() > 0) {
            position.set("h" + index + "Index", buf.readUnsignedByte());
            buf.readUnsignedShort();
            int n = buf.readUnsignedByte();
            short m = buf.readUnsignedByte();
            position.set("h" + index + "XLength", n);
            position.set("h" + index + "YLength", Integer.valueOf(m));
            if ((selector & 8) != 0) {
                position.set("h" + index + "XType", buf.readUnsignedByte());
                position.set("h" + index + "YType", buf.readUnsignedByte());
                position.set("h" + index + "Parameters", buf.readUnsignedByte());
            }
            boolean percentageFormat = (selector & 0x20) != 0;
            StringBuilder data = new StringBuilder();
            for (int i = 0; i < n * m; ++i) {
                if (percentageFormat) {
                    data.append((double)buf.readUnsignedByte() * 0.5).append("%").append(" ");
                    continue;
                }
                data.append(buf.readUnsignedShort()).append(" ");
            }
            position.set("h" + index + "Data", data.toString().trim());
            position.set("h" + index + "Total", buf.readUnsignedInt());
            if ((selector & 0x10) != 0) {
                int i;
                short k = buf.readUnsignedByte();
                data = new StringBuilder();
                for (i = 1; i < n; ++i) {
                    if (k == 1) {
                        data.append(buf.readByte()).append(" ");
                        continue;
                    }
                    if (k != 2) continue;
                    data.append(buf.readShort()).append(" ");
                }
                position.set("h" + index + "XLimits", data.toString().trim());
                data = new StringBuilder();
                for (i = 1; i < m; ++i) {
                    if (k == 1) {
                        data.append(buf.readByte()).append(" ");
                        continue;
                    }
                    if (k != 2) continue;
                    data.append(buf.readShort()).append(" ");
                }
                position.set("h" + index + "YLimits", data.toString().trim());
            }
            ++index;
        }
    }

    private void decodeEB(Position position, ByteBuf buf) {
        if (buf.readByte() != 69 || buf.readByte() != 66) {
            return;
        }
        position.set("versionFw", buf.readUnsignedByte());
        position.set("event", buf.readUnsignedShort());
        position.set("dataValidity", buf.readUnsignedByte());
        position.set("towed", buf.readUnsignedByte());
        buf.readUnsignedShort();
        while (buf.readableBytes() > 0) {
            buf.readUnsignedByte();
            short type = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            int end = buf.readerIndex() + length;
            switch (type) {
                case 1: {
                    position.set("brakeFlags", ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)length)));
                    break;
                }
                case 2: {
                    position.set("wheelSpeed", (double)buf.readUnsignedShort() / 256.0);
                    position.set("wheelSpeedDifference", (double)buf.readUnsignedShort() / 256.0 - 125.0);
                    position.set("lateralAcceleration", (double)buf.readUnsignedByte() / 10.0 - 12.5);
                    position.set("vehicleSpeed", (double)buf.readUnsignedShort() / 256.0);
                    break;
                }
                case 3: {
                    position.set("axleWeight", buf.readUnsignedShort() * 2);
                    break;
                }
                case 4: {
                    position.set("tirePressure", buf.readUnsignedByte() * 10);
                    position.set("pneumaticPressure", buf.readUnsignedByte() * 5);
                    break;
                }
                case 5: {
                    position.set("brakeLining", (double)buf.readUnsignedByte() * 0.4);
                    position.set("brakeTemperature", buf.readUnsignedByte() * 10);
                    break;
                }
                case 6: {
                    position.set("odometer", buf.readUnsignedInt() * 5L);
                    position.set("tripOdometer", buf.readUnsignedInt() * 5L);
                    position.set("serviceOdometer", (buf.readUnsignedInt() - 0x7D7FFFFFL) * 5L);
                    break;
                }
                case 10: {
                    position.set("absStatusCounter", buf.readUnsignedShort());
                    position.set("atvbStatusCounter", buf.readUnsignedShort());
                    position.set("vdcActiveCounter", buf.readUnsignedShort());
                    break;
                }
                case 11: {
                    position.set("brakeMinMaxData", ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)length)));
                    break;
                }
                case 12: {
                    position.set("missingPgn", ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)length)));
                    break;
                }
                case 13: {
                    buf.readUnsignedByte();
                    position.set("towedDetectionStatus", buf.readUnsignedInt());
                    buf.skipBytes(17);
                    break;
                }
            }
            buf.readerIndex(end);
        }
    }

    private void decodeF(Position position, ByteBuf buf, int selector) {
        Date deviceTime = null;
        if ((selector & 4) != 0) {
            deviceTime = new Date(buf.readUnsignedInt() * 1000L);
        }
        this.getLastLocation(position, deviceTime);
        buf.readUnsignedByte();
        if ((selector & 8) != 0) {
            position.set("rpm", buf.readUnsignedShort());
            position.set("rpmMax", buf.readUnsignedShort());
            position.set("rpmMin", buf.readUnsignedShort());
        }
        if ((selector & 0x10) != 0) {
            position.set("engineTemp", buf.readShort());
            position.set("engineTempMax", buf.readShort());
            position.set("engineTempMin", buf.readShort());
        }
        if ((selector & 0x20) != 0) {
            position.set("hours", UnitsConverter.msFromHours(buf.readUnsignedInt()));
            position.set("serviceDistance", buf.readInt());
            position.set("driverActivity", buf.readUnsignedByte());
            position.set("throttle", buf.readUnsignedByte());
            position.set("fuel", buf.readUnsignedByte());
        }
        if ((selector & 0x40) != 0) {
            position.set("fuelUsed", buf.readUnsignedInt());
        }
        if ((selector & 0x80) != 0) {
            position.set("odometer", buf.readUnsignedInt());
        }
        if ((selector & 0x100) != 0) {
            position.set("obdSpeed", buf.readUnsignedByte());
            position.set("speedMax", buf.readUnsignedByte());
            position.set("speedMin", buf.readUnsignedByte());
            position.set("hardBraking", buf.readUnsignedByte());
        }
        if ((selector & 0x200) != 0) {
            position.set("tachographSpeed", buf.readUnsignedByte());
            position.set("driver1State", buf.readUnsignedByte());
            position.set("driver2State", buf.readUnsignedByte());
            position.set("tachographStatus", buf.readUnsignedByte());
            position.set("overspeedCount", buf.readUnsignedByte());
        }
        if ((selector & 0x800) != 0) {
            position.set("hours", (double)buf.readUnsignedInt() * 0.05);
            position.set("rpm", (double)buf.readUnsignedShort() * 0.125);
            position.set("obdSpeed", (double)buf.readUnsignedShort() / 256.0);
            position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.5);
            position.set("fuel", (double)buf.readUnsignedByte() * 0.4);
        }
        if ((selector & 0x1000) != 0) {
            position.set("ambientTemperature", (double)buf.readUnsignedShort() * 0.03125 - 273.0);
            buf.readUnsignedShort();
            position.set("fuelEconomy", (double)buf.readUnsignedShort() / 512.0);
            position.set("fuelConsumption", (double)buf.readUnsignedInt() * 0.001);
            buf.readUnsignedByte();
        }
        if ((selector & 0x2000) != 0) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if ((selector & 0x4000) != 0) {
            position.set("torque", buf.readUnsignedByte());
            position.set("brakePressure1", buf.readUnsignedByte() * 8);
            position.set("brakePressure2", buf.readUnsignedByte() * 8);
            position.set("grossWeight", buf.readUnsignedShort() * 10);
            position.set("exhaustFluid", (double)buf.readUnsignedByte() * 0.4);
            buf.readUnsignedByte();
            position.set("retarderTorque", buf.readUnsignedByte());
            position.set("retarderSelection", (double)buf.readUnsignedByte() * 0.4);
            buf.skipBytes(8);
            buf.skipBytes(8);
            buf.skipBytes(8);
            buf.skipBytes(8);
        }
        if ((selector & 0x8000) != 0) {
            position.set("parkingBrakeStatus", buf.readUnsignedByte());
            position.set("doorStatus", buf.readUnsignedByte());
            buf.skipBytes(8);
            position.set("alternatorStatus", buf.readUnsignedByte());
            position.set("selectedGear", buf.readUnsignedByte());
            position.set("currentGear", buf.readUnsignedByte());
            buf.skipBytes(8);
        }
        if ((selector & 0x400) != 0) {
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                position.set("axle" + i, buf.readUnsignedShort());
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        char protocol = (char)buf.readByte();
        short version = buf.readUnsignedByte();
        String imei = (version & 0x80) != 0 ? String.valueOf(buf.readUnsignedInt() << 24 | (long)buf.readUnsignedMedium()) : String.valueOf(AplicomProtocolDecoder.imeiFromUnitId(buf.readUnsignedMedium()));
        buf.readUnsignedShort();
        int selector = 764;
        if (protocol == 'E') {
            selector = 32764;
        } else if (protocol == 'F') {
            selector = 2045;
        }
        if ((version & 0x40) != 0) {
            selector = buf.readUnsignedMedium();
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        short event = buf.readUnsignedByte();
        position.set("event", Integer.valueOf(event));
        position.set("eventInfo", buf.readUnsignedByte());
        if (protocol == 'D') {
            this.decodeD(position, buf, selector, event);
        } else if (protocol == 'E') {
            this.decodeE(position, buf, selector);
        } else if (protocol == 'H') {
            this.decodeH(position, buf, selector);
        } else if (protocol == 'F') {
            this.decodeF(position, buf, selector);
        } else {
            return null;
        }
        return position;
    }
}

