/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.traccar.BasePipelineFactory;
import org.traccar.EventLoopGroupFactory;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerConnector;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public abstract class TrackerClient
implements TrackerConnector {
    private final boolean secure;
    private final long interval;
    private final Bootstrap bootstrap;
    private final int port;
    private final String address;
    private final String[] devices;
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    @Override
    public boolean isDatagram() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public TrackerClient(final Config config, String protocol) {
        this.secure = config.getBoolean(Keys.PROTOCOL_SSL.withPrefix(protocol));
        this.interval = config.getLong(Keys.PROTOCOL_INTERVAL.withPrefix(protocol));
        this.address = config.getString(Keys.PROTOCOL_ADDRESS.withPrefix(protocol));
        this.port = config.getInteger(Keys.PROTOCOL_PORT.withPrefix(protocol), this.secure ? 443 : 80);
        this.devices = config.getString(Keys.PROTOCOL_DEVICES.withPrefix(protocol)).split("[, ]");
        BasePipelineFactory pipelineFactory = new BasePipelineFactory(this, config, protocol){

            @Override
            protected void addTransportHandlers(PipelineBuilder pipeline) {
                try {
                    if (TrackerClient.this.isSecure()) {
                        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
                        engine.setUseClientMode(true);
                        pipeline.addLast((ChannelHandler)new SslHandler(engine));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline) {
                try {
                    TrackerClient.this.addProtocolHandlers(pipeline, config);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(EventLoopGroupFactory.getWorkerGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)pipelineFactory);
    }

    protected abstract void addProtocolHandlers(PipelineBuilder var1, Config var2) throws Exception;

    public String[] getDevices() {
        return this.devices;
    }

    @Override
    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    @Override
    public void start() throws Exception {
        this.bootstrap.connect(this.address, this.port).syncUninterruptibly().channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) {
                if (TrackerClient.this.interval > 0L) {
                    GlobalEventExecutor.INSTANCE.schedule(() -> TrackerClient.this.bootstrap.connect(TrackerClient.this.address, TrackerClient.this.port).syncUninterruptibly().channel().closeFuture().addListener((GenericFutureListener)this), TrackerClient.this.interval, TimeUnit.SECONDS);
                }
            }
        });
    }

    @Override
    public void stop() {
        this.channelGroup.close().awaitUninterruptibly();
    }
}

