"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerScrollForCountRoute = void 0;

var _configSchema = require("@osd/config-schema");

var _lib = require("../lib");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const registerScrollForCountRoute = router => {
  router.post({
    path: '/api/opensearch-dashboards/management/saved_objects/scroll/counts',
    validate: {
      body: _configSchema.schema.object({
        typesToInclude: _configSchema.schema.arrayOf(_configSchema.schema.string()),
        searchString: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    const {
      client
    } = context.core.savedObjects;
    const findOptions = {
      type: req.body.typesToInclude,
      perPage: 1000
    };

    if (req.body.searchString) {
      findOptions.search = `${req.body.searchString}*`;
      findOptions.searchFields = ['title'];
    }

    const objects = await (0, _lib.findAll)(client, findOptions);
    const counts = objects.reduce((accum, result) => {
      const type = result.type;
      accum[type] = accum[type] || 0;
      accum[type]++;
      return accum;
    }, {});

    for (const type of req.body.typesToInclude) {
      if (!counts[type]) {
        counts[type] = 0;
      }
    }

    return res.ok({
      body: counts
    });
  }));
};

exports.registerScrollForCountRoute = registerScrollForCountRoute;