"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAuthenticationHandler = getAuthenticationHandler;

var _common = require("../../common");

var _types = require("./types");

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
function createAuthentication(ctor, config, sessionStorageFactory, router, esClient, coreSetup, logger) {
  return new ctor(config, sessionStorageFactory, router, esClient, coreSetup, logger);
}

function getAuthenticationHandler(authType, router, config, core, esClient, securitySessionStorageFactory, logger) {
  let authHandlerType;

  switch (authType) {
    case '':
    case 'basicauth':
      authHandlerType = _types.BasicAuthentication;
      break;

    case _common.AuthType.JWT:
      authHandlerType = _types.JwtAuthentication;
      break;

    case _common.AuthType.OPEN_ID:
      authHandlerType = _types.OpenIdAuthentication;
      break;

    case _common.AuthType.SAML:
      authHandlerType = _types.SamlAuthentication;
      break;

    case _common.AuthType.PROXY:
      authHandlerType = _types.ProxyAuthentication;
      break;

    default:
      throw new Error(`Unsupported authentication type: ${authType}`);
  }

  const auth = createAuthentication(authHandlerType, config, securitySessionStorageFactory, router, esClient, core, logger);
  return auth;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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