/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkIndirectCommandsTokenNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOKENTYPE;
    public static final int BUFFER;
    public static final int OFFSET;

    public VkIndirectCommandsTokenNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkIndirectCommandsTokenNVX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkIndirectCommandsTokenTypeNVX")
    public int tokenType() {
        return VkIndirectCommandsTokenNVX.ntokenType(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkIndirectCommandsTokenNVX.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkIndirectCommandsTokenNVX.noffset(this.address());
    }

    public VkIndirectCommandsTokenNVX tokenType(@NativeType(value="VkIndirectCommandsTokenTypeNVX") int value) {
        VkIndirectCommandsTokenNVX.ntokenType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsTokenNVX buffer(@NativeType(value="VkBuffer") long value) {
        VkIndirectCommandsTokenNVX.nbuffer(this.address(), value);
        return this;
    }

    public VkIndirectCommandsTokenNVX offset(@NativeType(value="VkDeviceSize") long value) {
        VkIndirectCommandsTokenNVX.noffset(this.address(), value);
        return this;
    }

    public VkIndirectCommandsTokenNVX set(int tokenType, long buffer, long offset) {
        this.tokenType(tokenType);
        this.buffer(buffer);
        this.offset(offset);
        return this;
    }

    public VkIndirectCommandsTokenNVX set(VkIndirectCommandsTokenNVX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkIndirectCommandsTokenNVX malloc() {
        return (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX calloc() {
        return (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkIndirectCommandsTokenNVX create(long address) {
        return (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)address);
    }

    @Nullable
    public static VkIndirectCommandsTokenNVX createSafe(long address) {
        return address == 0L ? null : (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkIndirectCommandsTokenNVX.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsTokenNVX.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkIndirectCommandsTokenNVX mallocStack() {
        return VkIndirectCommandsTokenNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsTokenNVX callocStack() {
        return VkIndirectCommandsTokenNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkIndirectCommandsTokenNVX mallocStack(MemoryStack stack) {
        return (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkIndirectCommandsTokenNVX callocStack(MemoryStack stack) {
        return (VkIndirectCommandsTokenNVX)VkIndirectCommandsTokenNVX.wrap(VkIndirectCommandsTokenNVX.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkIndirectCommandsTokenNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkIndirectCommandsTokenNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkIndirectCommandsTokenNVX.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntokenType(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOKENTYPE);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static void ntokenType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TOKENTYPE, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = VkIndirectCommandsTokenNVX.__struct((Struct.Member[])new Struct.Member[]{VkIndirectCommandsTokenNVX.__member((int)4), VkIndirectCommandsTokenNVX.__member((int)8), VkIndirectCommandsTokenNVX.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOKENTYPE = layout.offsetof(0);
        BUFFER = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsTokenNVX, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsTokenNVX ELEMENT_FACTORY = VkIndirectCommandsTokenNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkIndirectCommandsTokenNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkIndirectCommandsTokenTypeNVX")
        public int tokenType() {
            return VkIndirectCommandsTokenNVX.ntokenType(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkIndirectCommandsTokenNVX.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkIndirectCommandsTokenNVX.noffset(this.address());
        }

        public Buffer tokenType(@NativeType(value="VkIndirectCommandsTokenTypeNVX") int value) {
            VkIndirectCommandsTokenNVX.ntokenType(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkIndirectCommandsTokenNVX.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkIndirectCommandsTokenNVX.noffset(this.address(), value);
            return this;
        }
    }
}

