/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXTUResourceUsageEntry;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXTUResourceUsage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUMENTRIES;
    public static final int ENTRIES;

    public CXTUResourceUsage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXTUResourceUsage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long data() {
        return CXTUResourceUsage.ndata(this.address());
    }

    @NativeType(value="unsigned")
    public int numEntries() {
        return CXTUResourceUsage.nnumEntries(this.address());
    }

    @NativeType(value="CXTUResourceUsageEntry *")
    public CXTUResourceUsageEntry.Buffer entries() {
        return CXTUResourceUsage.nentries(this.address());
    }

    public static CXTUResourceUsage malloc() {
        return (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXTUResourceUsage calloc() {
        return (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXTUResourceUsage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXTUResourceUsage create(long address) {
        return (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)address);
    }

    @Nullable
    public static CXTUResourceUsage createSafe(long address) {
        return address == 0L ? null : (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXTUResourceUsage.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXTUResourceUsage.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXTUResourceUsage mallocStack() {
        return CXTUResourceUsage.mallocStack(MemoryStack.stackGet());
    }

    public static CXTUResourceUsage callocStack() {
        return CXTUResourceUsage.callocStack(MemoryStack.stackGet());
    }

    public static CXTUResourceUsage mallocStack(MemoryStack stack) {
        return (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXTUResourceUsage callocStack(MemoryStack stack) {
        return (CXTUResourceUsage)CXTUResourceUsage.wrap(CXTUResourceUsage.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXTUResourceUsage.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXTUResourceUsage.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXTUResourceUsage.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ndata(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA));
    }

    public static int nnumEntries(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMENTRIES);
    }

    public static CXTUResourceUsageEntry.Buffer nentries(long struct) {
        return CXTUResourceUsageEntry.create(MemoryUtil.memGetAddress((long)(struct + (long)ENTRIES)), CXTUResourceUsage.nnumEntries(struct));
    }

    static {
        Struct.Layout layout = CXTUResourceUsage.__struct((Struct.Member[])new Struct.Member[]{CXTUResourceUsage.__member((int)POINTER_SIZE), CXTUResourceUsage.__member((int)4), CXTUResourceUsage.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUMENTRIES = layout.offsetof(1);
        ENTRIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXTUResourceUsage, Buffer>
    implements NativeResource {
        private static final CXTUResourceUsage ELEMENT_FACTORY = CXTUResourceUsage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXTUResourceUsage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long data() {
            return CXTUResourceUsage.ndata(this.address());
        }

        @NativeType(value="unsigned")
        public int numEntries() {
            return CXTUResourceUsage.nnumEntries(this.address());
        }

        @NativeType(value="CXTUResourceUsageEntry *")
        public CXTUResourceUsageEntry.Buffer entries() {
            return CXTUResourceUsage.nentries(this.address());
        }
    }
}

