/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u0019\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"logger", "Lorg/jitsi/utils/logging2/LoggerImpl;", "parseJidFromClientProxyJid", "Lorg/jxmpp/jid/Jid;", "clientProxy", "Lorg/jxmpp/jid/DomainBareJid;", "jid", "getDouble", "", "Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;", "name", "", "(Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;Ljava/lang/String;)Ljava/lang/Double;", "sendIqAndGetResponse", "Lorg/jivesoftware/smack/packet/IQ;", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "iq", "tryToSendStanza", "", "Lorg/jivesoftware/smack/XMPPConnection;", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "jicofo"})
public final class UtilKt {
    @NotNull
    private static final LoggerImpl logger = new LoggerImpl("org.jitsi.jicofo.xmpp.Util");

    @NotNull
    public static final Jid parseJidFromClientProxyJid(@Nullable DomainBareJid clientProxy2, @NotNull Jid jid) {
        Resourcepart resourcepart;
        Intrinsics.checkNotNullParameter(jid, "jid");
        if (clientProxy2 == null) {
            return jid;
        }
        if (Intrinsics.areEqual(clientProxy2, jid.asDomainBareJid()) && (resourcepart = jid.getResourceOrNull()) != null) {
            Jid jid2;
            Resourcepart resource = resourcepart;
            boolean bl = false;
            try {
                Jid jid3 = JidCreate.from(resource.toString());
                Intrinsics.checkNotNullExpressionValue(jid3, "{\n                JidCre\u2026toString())\n            }");
                jid2 = jid3;
            }
            catch (XmppStringprepException e) {
                jid2 = jid;
            }
            return jid2;
        }
        return jid;
    }

    @Nullable
    public static final Double getDouble(@NotNull ColibriStatsExtension $this$getDouble, @NotNull String name) {
        Double d;
        Intrinsics.checkNotNullParameter($this$getDouble, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            String string = $this$getDouble.getValueAsString(name);
            d = string != null ? Double.valueOf(Double.parseDouble(string)) : null;
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static final void tryToSendStanza(@NotNull XMPPConnection $this$tryToSendStanza, @NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter($this$tryToSendStanza, "<this>");
        Intrinsics.checkNotNullParameter(stanza, "stanza");
        try {
            $this$tryToSendStanza.sendStanza(stanza);
        }
        catch (SmackException.NotConnectedException e) {
            logger.error("No connection - unable to send packet: " + stanza.toXML(), e);
        }
        catch (InterruptedException e) {
            logger.error("Failed to send packet: " + stanza.toXML(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IQ sendIqAndGetResponse(@NotNull AbstractXMPPConnection $this$sendIqAndGetResponse, @NotNull IQ iq) throws SmackException.NotConnectedException {
        IQ iQ;
        Intrinsics.checkNotNullParameter($this$sendIqAndGetResponse, "<this>");
        Intrinsics.checkNotNullParameter(iq, "iq");
        StanzaCollector it = $this$sendIqAndGetResponse.createStanzaCollectorAndSend(iq);
        boolean bl = false;
        try {
            iQ = (IQ)it.nextResult();
        }
        finally {
            it.cancel();
        }
        return iQ;
    }
}

