/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.BaseJibri;
import org.jitsi.jicofo.jibri.JibriConfig;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.util.ErrorResponse;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jibri.RecordingStatus;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0006\u0010\u001e\u001a\u00020\u0018R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/jicofo/jibri/JibriRecorder;", "Lorg/jitsi/jicofo/jibri/BaseJibri;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/jicofo/jibri/JibriDetector;Lorg/jitsi/utils/logging2/Logger;)V", "jibriSession", "Lorg/jitsi/jicofo/jibri/JibriSession;", "jibriSessions", "", "getJibriSessions", "()Ljava/util/List;", "acceptType", "", "packet", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "getJibriSessionForMeetIq", "iq", "handleStartRequest", "Lorg/jivesoftware/smack/packet/IQ;", "onSessionStateChanged", "", "newStatus", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq$Status;", "failureReason", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq$FailureReason;", "publishJibriRecordingStatus", "shutdown", "jicofo"})
public final class JibriRecorder
extends BaseJibri {
    @Nullable
    private JibriSession jibriSession;

    public JibriRecorder(@NotNull JitsiMeetConferenceImpl conference, @NotNull JibriDetector jibriDetector, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(jibriDetector, "jibriDetector");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(conference, parentLogger, jibriDetector);
    }

    public final void shutdown() {
        JibriSession jibriSession = this.jibriSession;
        if (jibriSession != null) {
            jibriSession.stop(null);
        }
        this.jibriSession = null;
    }

    @Override
    protected boolean acceptType(@NotNull JibriIq packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return StringUtils.isBlank(packet.getSipAddress());
    }

    @Override
    @Nullable
    protected JibriSession getJibriSessionForMeetIq(@NotNull JibriIq iq) {
        Intrinsics.checkNotNullParameter(iq, "iq");
        return this.jibriSession;
    }

    @Override
    @NotNull
    public List<JibriSession> getJibriSessions() {
        Object object;
        block3: {
            block2: {
                object = this.jibriSession;
                if (object == null) break block2;
                JibriSession it = object;
                boolean bl = false;
                List<JibriSession> list = CollectionsKt.listOf(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected IQ handleStartRequest(@NotNull JibriIq iq) {
        IQ iQ;
        Intrinsics.checkNotNullParameter(iq, "iq");
        boolean streamIdIsEmpty = StringUtils.isBlank(iq.getStreamId());
        if (streamIdIsEmpty && iq.getRecordingMode() != JibriIq.RecordingMode.FILE) {
            ErrorIQ errorIQ = ErrorResponse.create(iq, StanzaError.Condition.bad_request, "Stream ID is empty or undefined");
            Intrinsics.checkNotNullExpressionValue(errorIQ, "{\n            // Stream \u2026 or undefined\")\n        }");
            iQ = errorIQ;
        } else if (!streamIdIsEmpty && iq.getRecordingMode() == JibriIq.RecordingMode.FILE) {
            ErrorIQ errorIQ = ErrorResponse.create(iq, StanzaError.Condition.bad_request, "Stream ID is provided for a FILE recording.");
            Intrinsics.checkNotNullExpressionValue(errorIQ, "{\n            // Stream \u2026LE recording.\")\n        }");
            iQ = errorIQ;
        } else {
            Object object;
            String sessionId = this.generateSessionId();
            try {
                void $this$handleStartRequest_u24lambda_u2d1;
                Object object2 = object = new JibriSession(this, this.getConference().getRoomName(), iq.getFrom(), JibriConfig.config.getPendingTimeout().getSeconds(), JibriConfig.config.getNumRetries(), this.getJibriDetector(), false, null, iq.getDisplayName(), iq.getStreamId(), iq.getYoutubeBroadcastId(), sessionId, iq.getAppData(), this.getLogger());
                JibriRecorder jibriRecorder = this;
                boolean bl = false;
                $this$handleStartRequest_u24lambda_u2d1.start();
                this.getLogger().info("Started Jibri session");
                jibriRecorder.jibriSession = object;
                object = JibriIq.createResult(iq, sessionId);
            }
            catch (JibriSession.StartException exc) {
                ErrorIQ errorIQ;
                this.jibriSession = null;
                JibriSession.StartException startException = exc;
                if (startException instanceof JibriSession.StartException.AllBusy) {
                    this.getLogger().info("Failed to start a Jibri session, all Jibris were busy");
                    errorIQ = ErrorResponse.create(iq, StanzaError.Condition.resource_constraint, "all Jibris are busy");
                } else if (startException instanceof JibriSession.StartException.NotAvailable) {
                    this.getLogger().info("Failed to start a Jibri session, no Jibris available");
                    errorIQ = ErrorResponse.create(iq, StanzaError.Condition.service_unavailable, "no Jibris available");
                } else {
                    this.getLogger().warn("Failed to start a Jibri session: " + exc.getMessage(), exc);
                    errorIQ = ErrorResponse.create(iq, StanzaError.Condition.internal_server_error, exc.getMessage());
                }
                object = errorIQ;
            }
            IQ iQ2 = object;
            Intrinsics.checkNotNullExpressionValue(iQ2, "{\n            val sessio\u2026}\n            }\n        }");
            iQ = iQ2;
        }
        return iQ;
    }

    @Override
    public void onSessionStateChanged(@NotNull JibriSession jibriSession, @NotNull JibriIq.Status newStatus, @Nullable JibriIq.FailureReason failureReason) {
        Intrinsics.checkNotNullParameter(jibriSession, "jibriSession");
        Intrinsics.checkNotNullParameter((Object)newStatus, "newStatus");
        if (this.jibriSession != jibriSession) {
            this.getLogger().error("onSessionStateChanged for unknown session: " + jibriSession);
            return;
        }
        this.publishJibriRecordingStatus(newStatus, failureReason);
        if (newStatus == JibriIq.Status.OFF) {
            this.jibriSession = null;
        }
    }

    private final void publishJibriRecordingStatus(JibriIq.Status newStatus, JibriIq.FailureReason failureReason) {
        block6: {
            RecordingStatus recordingStatus;
            this.getLogger().info("Got jibri status " + newStatus + " and failure " + failureReason);
            JibriSession jibriSession = this.jibriSession;
            if (jibriSession == null) {
                this.getLogger().info("Jibri session was already cleaned up, not sending new status");
                return;
            }
            RecordingStatus $this$publishJibriRecordingStatus_u24lambda_u2d3 = recordingStatus = new RecordingStatus();
            boolean bl = false;
            $this$publishJibriRecordingStatus_u24lambda_u2d3.setStatus(newStatus);
            $this$publishJibriRecordingStatus_u24lambda_u2d3.setFailureReason(failureReason);
            $this$publishJibriRecordingStatus_u24lambda_u2d3.setSessionId(jibriSession.getSessionId());
            switch (WhenMappings.$EnumSwitchMapping$0[newStatus.ordinal()]) {
                case 1: {
                    $this$publishJibriRecordingStatus_u24lambda_u2d3.setInitiator(jibriSession.getInitiator());
                    break;
                }
                case 2: {
                    $this$publishJibriRecordingStatus_u24lambda_u2d3.setInitiator(jibriSession.getTerminator());
                    break;
                }
            }
            JibriIq.RecordingMode it = jibriSession.getRecordingMode();
            boolean bl2 = false;
            if (it != JibriIq.RecordingMode.UNDEFINED) {
                $this$publishJibriRecordingStatus_u24lambda_u2d3.setRecordingMode(it);
            }
            RecordingStatus recordingStatus2 = recordingStatus;
            this.getLogger().info("Publishing new jibri-recording-status: " + recordingStatus2.toXML() + " in: " + this.getConference().getRoomName());
            ChatRoom chatRoom = this.getConference().getChatRoom();
            if (chatRoom == null) break block6;
            chatRoom.setPresenceExtension(recordingStatus2, false);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JibriIq.Status.values().length];
            nArray[JibriIq.Status.ON.ordinal()] = 1;
            nArray[JibriIq.Status.OFF.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

