/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference.colibri.v2;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.ParticipantInviteRunnable;
import org.jitsi.jicofo.conference.colibri.v2.ParticipantInfo;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.Source;
import org.jitsi.jicofo.conference.source.SsrcGroup;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a*\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\b0\rH\u0000\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0001\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018\u00a8\u0006\u0019"}, d2={"parseSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifiedIQ;", "parseTransport", "Lorg/jitsi/xmpp/extensions/colibri2/Transport;", "endpointId", "", "sendIqAndHandleResponseAsync", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "iq", "Lorg/jivesoftware/smack/packet/IQ;", "block", "Lkotlin/Function1;", "toColibriMediaSources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "toEndpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint;", "Lorg/jitsi/jicofo/conference/colibri/v2/ParticipantInfo;", "create", "", "expire", "toMedia", "Lorg/jitsi/xmpp/extensions/colibri2/Media;", "Lorg/jitsi/xmpp/extensions/jingle/ContentPacketExtension;", "jicofo"})
public final class ExtensionsKt {
    @Nullable
    public static final Transport parseTransport(@NotNull ConferenceModifiedIQ $this$parseTransport, @NotNull String endpointId) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter($this$parseTransport, "<this>");
            Intrinsics.checkNotNullParameter(endpointId, "endpointId");
            List<Colibri2Endpoint> list = $this$parseTransport.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "endpoints");
            Iterable iterable = list;
            for (Object t : iterable) {
                Colibri2Endpoint it = (Colibri2Endpoint)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), endpointId)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        Colibri2Endpoint colibri2Endpoint = v1;
        return colibri2Endpoint != null ? colibri2Endpoint.getTransport() : null;
    }

    @NotNull
    public static final ConferenceSourceMap parseSources(@NotNull ConferenceModifiedIQ $this$parseSources) {
        ConferenceSourceMap parsedSources;
        block3: {
            Intrinsics.checkNotNullParameter($this$parseSources, "<this>");
            parsedSources = new ConferenceSourceMap(null, 1, null);
            Jid owner = ParticipantInviteRunnable.SSRC_OWNER_JVB;
            Object object = $this$parseSources.getSources();
            if (object == null || (object = ((Sources)object).getMediaSources()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSource mediaSource = (MediaSource)element$iv;
                boolean bl = false;
                List<SourcePacketExtension> list = mediaSource.getSources();
                Intrinsics.checkNotNullExpressionValue(list, "mediaSource.sources");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourcePacketExtension sourcePacketExtension = (SourcePacketExtension)element$iv2;
                    boolean bl2 = false;
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "mediaSource.type");
                    Intrinsics.checkNotNullExpressionValue(sourcePacketExtension, "sourcePacketExtension");
                    parsedSources.add(owner, new EndpointSourceSet(new Source(mediaType, sourcePacketExtension)));
                }
                List<SourceGroupPacketExtension> list2 = mediaSource.getSsrcGroups();
                Intrinsics.checkNotNullExpressionValue(list2, "mediaSource.ssrcGroups");
                $this$forEach$iv2 = list2;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourceGroupPacketExtension it = (SourceGroupPacketExtension)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "mediaSource.type");
                    parsedSources.add(owner, new EndpointSourceSet(SsrcGroup.Companion.fromPacketExtension(it, mediaType)));
                }
            }
        }
        return parsedSources;
    }

    @NotNull
    public static final Sources toColibriMediaSources(@NotNull ConferenceSourceMap $this$toColibriMediaSources) {
        Intrinsics.checkNotNullParameter($this$toColibriMediaSources, "<this>");
        Map mediaSources = new LinkedHashMap();
        Map $this$forEach$iv = $this$toColibriMediaSources;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            Jid owner = (Jid)entry.getKey();
            EndpointSourceSet endpointSourceSet = (EndpointSourceSet)entry.getValue();
            Iterable $this$forEach$iv2 = endpointSourceSet.getSources();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MediaSource.Builder mediaSource;
                Source source = (Source)element$iv2;
                boolean bl2 = false;
                String string = source.getName();
                if (string == null) {
                    Jid jid = owner;
                    Intrinsics.checkNotNull(jid);
                    String string2 = jid.getResourceOrEmpty().toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "owner!!.resourceOrEmpty.toString()");
                    string = Source.Companion.nameForIdAndMediaType(string2, source.getMediaType(), 0);
                }
                String sourceId = string;
                Intrinsics.checkNotNullExpressionValue(mediaSources.computeIfAbsent(sourceId, arg_0 -> ExtensionsKt.toColibriMediaSources$lambda-9$lambda-5$lambda-4(source, sourceId, arg_0)), "mediaSources.computeIfAb\u2026d(sourceId)\n            }");
                mediaSource.addSource(Source.toPacketExtension$default(source, null, false, 1, null));
            }
            $this$forEach$iv2 = endpointSourceSet.getSsrcGroups();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MediaSource.Builder mediaSource;
                Source firstSource;
                Object v3;
                SsrcGroup ssrcGroup;
                block8: {
                    ssrcGroup = (SsrcGroup)element$iv2;
                    boolean bl3 = false;
                    if (ssrcGroup.getSsrcs().isEmpty()) continue;
                    Iterable $this$firstOrNull$iv = endpointSourceSet.getSources();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        Source it = (Source)element$iv3;
                        boolean bl4 = false;
                        if (!ssrcGroup.getSsrcs().contains(it.getSsrc())) continue;
                        v3 = element$iv3;
                        break block8;
                    }
                    v3 = null;
                }
                if ((Source)v3 == null) {
                    throw new IllegalStateException("An SsrcGroup in an EndpointSourceSet has an SSRC without a Source");
                }
                String string = firstSource.getName();
                if (string == null) {
                    Jid jid = owner;
                    Intrinsics.checkNotNull(jid);
                    String string3 = jid.getResourceOrEmpty().toString();
                    Intrinsics.checkNotNullExpressionValue(string3, "owner!!.resourceOrEmpty.toString()");
                    string = Source.Companion.nameForIdAndMediaType(string3, ssrcGroup.getMediaType(), 0);
                }
                String sourceId = string;
                Intrinsics.checkNotNullExpressionValue(mediaSources.computeIfAbsent(sourceId, arg_0 -> ExtensionsKt.toColibriMediaSources$lambda-9$lambda-8$lambda-7(ssrcGroup, sourceId, arg_0)), "mediaSources.computeIfAb\u2026d(sourceId)\n            }");
                mediaSource.addSsrcGroup(ssrcGroup.toPacketExtension());
            }
        }
        Sources.Builder builder = Sources.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder, "getBuilder()");
        Sources.Builder sources = builder;
        Iterable $this$forEach$iv3 = mediaSources.values();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            MediaSource.Builder it = (MediaSource.Builder)element$iv;
            boolean bl = false;
            sources.addMediaSource(it.build());
        }
        Sources sources2 = sources.build();
        Intrinsics.checkNotNullExpressionValue(sources2, "sources.build()");
        return sources2;
    }

    @Nullable
    public static final Media toMedia(@NotNull ContentPacketExtension $this$toMedia) {
        Media.Builder media;
        block6: {
            Media.Builder builder;
            Intrinsics.checkNotNullParameter($this$toMedia, "<this>");
            String string = $this$toMedia.getName();
            Intrinsics.checkNotNullExpressionValue(string, "name");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string3 = string2;
            if (Intrinsics.areEqual(string3, "audio")) {
                builder = Media.getBuilder().setType(MediaType.AUDIO);
            } else if (Intrinsics.areEqual(string3, "video")) {
                builder = Media.getBuilder().setType(MediaType.VIDEO);
            } else {
                return null;
            }
            media = builder;
            RtpDescriptionPacketExtension rtpDescriptionPacketExtension = $this$toMedia.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            if (rtpDescriptionPacketExtension == null) break block6;
            RtpDescriptionPacketExtension it = rtpDescriptionPacketExtension;
            boolean bl = false;
            List<PayloadTypePacketExtension> list = it.getPayloadTypes();
            Intrinsics.checkNotNullExpressionValue(list, "it.payloadTypes");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadTypePacketExtension payloadTypePacketExtension = (PayloadTypePacketExtension)element$iv;
                boolean bl2 = false;
                media.addPayloadType(payloadTypePacketExtension);
            }
            List<RTPHdrExtPacketExtension> list2 = it.getExtmapList();
            Intrinsics.checkNotNullExpressionValue(list2, "it.extmapList");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RTPHdrExtPacketExtension rtpHdrExtPacketExtension = (RTPHdrExtPacketExtension)element$iv;
                boolean bl3 = false;
                media.addRtpHdrExt(rtpHdrExtPacketExtension);
            }
        }
        return media.build();
    }

    @NotNull
    public static final Colibri2Endpoint toEndpoint(@NotNull ParticipantInfo $this$toEndpoint, boolean create, boolean expire2) {
        Colibri2Endpoint.Builder builder;
        Intrinsics.checkNotNullParameter($this$toEndpoint, "<this>");
        Colibri2Endpoint.Builder $this$toEndpoint_u24lambda_u2d14 = builder = Colibri2Endpoint.getBuilder();
        boolean bl = false;
        $this$toEndpoint_u24lambda_u2d14.setId($this$toEndpoint.getId());
        if (create) {
            $this$toEndpoint_u24lambda_u2d14.setCreate(true);
            $this$toEndpoint_u24lambda_u2d14.setStatsId($this$toEndpoint.getStatsId());
            if ($this$toEndpoint.getSupportsSourceNames()) {
                $this$toEndpoint_u24lambda_u2d14.addCapability("source-names");
            }
        }
        if (!expire2) {
            $this$toEndpoint_u24lambda_u2d14.setSources(ExtensionsKt.toColibriMediaSources($this$toEndpoint.getSources()));
        }
        if (expire2) {
            $this$toEndpoint_u24lambda_u2d14.setExpire(true);
        }
        Colibri2Endpoint colibri2Endpoint = builder.build();
        Intrinsics.checkNotNullExpressionValue(colibri2Endpoint, "getBuilder().apply {\n   \u2026ire(true)\n    }\n}.build()");
        return colibri2Endpoint;
    }

    public static final void sendIqAndHandleResponseAsync(@NotNull AbstractXMPPConnection $this$sendIqAndHandleResponseAsync, @NotNull IQ iq, @NotNull Function1<? super IQ, Unit> block) {
        Intrinsics.checkNotNullParameter($this$sendIqAndHandleResponseAsync, "<this>");
        Intrinsics.checkNotNullParameter(iq, "iq");
        Intrinsics.checkNotNullParameter(block, "block");
        StanzaCollector stanzaCollector = $this$sendIqAndHandleResponseAsync.createStanzaCollectorAndSend(iq);
        TaskPools.Companion.getIoPool().submit(() -> ExtensionsKt.sendIqAndHandleResponseAsync$lambda-15(block, stanzaCollector));
    }

    private static final MediaSource.Builder toColibriMediaSources$lambda-9$lambda-5$lambda-4(Source $source, String $sourceId, String it) {
        Intrinsics.checkNotNullParameter($source, "$source");
        Intrinsics.checkNotNullParameter($sourceId, "$sourceId");
        Intrinsics.checkNotNullParameter(it, "it");
        return MediaSource.getBuilder().setType($source.getMediaType()).setId($sourceId);
    }

    private static final MediaSource.Builder toColibriMediaSources$lambda-9$lambda-8$lambda-7(SsrcGroup $ssrcGroup, String $sourceId, String it) {
        Intrinsics.checkNotNullParameter($ssrcGroup, "$ssrcGroup");
        Intrinsics.checkNotNullParameter($sourceId, "$sourceId");
        Intrinsics.checkNotNullParameter(it, "it");
        return MediaSource.getBuilder().setType($ssrcGroup.getMediaType()).setId($sourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendIqAndHandleResponseAsync$lambda-15(Function1 $block, StanzaCollector $stanzaCollector) {
        Intrinsics.checkNotNullParameter($block, "$block");
        try {
            $block.invoke($stanzaCollector.nextResult());
        }
        finally {
            $stanzaCollector.cancel();
        }
    }
}

