/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.impl.protocol.xmpp.ChatRoomMember;
import org.jitsi.impl.protocol.xmpp.RegistrationListener;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.JitsiMeetConfig;
import org.jitsi.jicofo.ReinviteMethod;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.MuteResult;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.ParticipantInviteRunnable;
import org.jitsi.jicofo.conference.colibri.ColibriSessionManager;
import org.jitsi.jicofo.conference.colibri.v2.ColibriV2SessionManager;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.UnmodifiableConferenceSourceMap;
import org.jitsi.jicofo.conference.source.ValidatingConferenceSourceMap;
import org.jitsi.jicofo.conference.source.ValidationFailedException;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriRecorder;
import org.jitsi.jicofo.jibri.JibriSipGateway;
import org.jitsi.jicofo.jigasi.JigasiConfig;
import org.jitsi.jicofo.jigasi.TranscriberManager;
import org.jitsi.jicofo.lipsynchack.LipSyncHack;
import org.jitsi.jicofo.stats.Statistics;
import org.jitsi.jicofo.version.CurrentVersionImpl;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.muc.AuthenticationRoleManager;
import org.jitsi.jicofo.xmpp.muc.AutoOwnerRoleManager;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoomRoleManager;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.protocol.xmpp.JingleRequestHandler;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeNotAvailablePacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeSessionPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.ComponentVersionsExtension;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceProperties;
import org.jitsi.xmpp.extensions.jitsimeet.EtherpadPacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.IceStatePacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.MuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteVideoIq;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class JitsiMeetConferenceImpl
implements JitsiMeetConference,
RegistrationListener,
JingleRequestHandler {
    @NotNull
    private final EntityBareJid roomName;
    private final ConferenceListener listener;
    @NotNull
    private final Logger logger;
    @NotNull
    private final JitsiMeetConfig config;
    private final ChatRoomListener chatRoomListener = new ChatRoomListenerImpl();
    private volatile ChatRoom chatRoom;
    private OperationSetJingle jingle;
    private final Map<Jid, Participant> participants = new ConcurrentHashMap<Jid, Participant>();
    private final Object participantLock = new Object();
    private JibriRecorder jibriRecorder;
    private JibriSipGateway jibriSipGateway;
    private TranscriberManager transcriberManager;
    private ChatRoomRoleManager chatRoomRoleManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Instant creationTime = Instant.now();
    private boolean hasHadAtLeastOneParticipant = false;
    private Future<?> singleParticipantTout;
    private boolean startAudioMuted = false;
    private boolean startVideoMuted = false;
    private final String etherpadName;
    private final ColibriSessionManager colibriSessionManager;
    private final ColibriSessionManagerListener colibriSessionManagerListener = new ColibriSessionManagerListener();
    private final ConferenceProperties conferenceProperties = new ConferenceProperties();
    private final boolean includeInStatistics;
    private final BridgeSelectorEventHandler bridgeSelectorEventHandler = new BridgeSelectorEventHandler();
    @NotNull
    private final JicofoServices jicofoServices;
    private final ValidatingConferenceSourceMap conferenceSources = new ValidatingConferenceSourceMap();
    private boolean audioLimitReached = false;
    private boolean videoLimitReached = false;
    private final String jvbVersion;

    public JitsiMeetConferenceImpl(@NotNull EntityBareJid roomName, ConferenceListener listener, @NotNull JitsiMeetConfig config, Level logLevel, String jvbVersion, boolean includeInStatistics) {
        this.logger = new LoggerImpl(JitsiMeetConferenceImpl.class.getName(), logLevel);
        this.logger.addContext("room", roomName.toString());
        this.config = config;
        this.roomName = roomName;
        this.listener = listener;
        this.etherpadName = this.createSharedDocumentName();
        this.includeInStatistics = includeInStatistics;
        this.jicofoServices = Objects.requireNonNull(JicofoServices.jicofoServicesSingleton);
        this.jvbVersion = jvbVersion;
        this.colibriSessionManager = new ColibriV2SessionManager(this.jicofoServices.getXmppServices().getServiceConnection().getXmppConnection(), this.jicofoServices.getBridgeSelector(), this, this.logger);
        this.colibriSessionManager.addListener(this.colibriSessionManagerListener);
        this.logger.info("Created new conference.");
    }

    public JitsiMeetConferenceImpl(@NotNull EntityBareJid roomName, ConferenceListener listener, @NotNull JitsiMeetConfig config, Level logLevel, String jvbVersion) {
        this(roomName, listener, config, logLevel, jvbVersion, false);
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            JibriDetector sipJibriDetector;
            XmppProvider clientXmppProvider = this.getClientXmppProvider();
            this.jingle = clientXmppProvider.getJingleApi();
            if (ConferenceConfig.config.enableLipSync()) {
                this.jingle = new LipSyncHack(this, this.jingle, this.logger);
            }
            BridgeSelector bridgeSelector = this.jicofoServices.getBridgeSelector();
            bridgeSelector.addHandler(this.bridgeSelectorEventHandler);
            if (clientXmppProvider.isRegistered()) {
                this.joinTheRoom();
            }
            clientXmppProvider.addRegistrationListener(this);
            JibriDetector jibriDetector = this.jicofoServices.getJibriDetector();
            if (jibriDetector != null) {
                this.jibriRecorder = new JibriRecorder(this, jibriDetector, this.logger);
            }
            if ((sipJibriDetector = this.jicofoServices.getSipJibriDetector()) != null) {
                this.jibriSipGateway = new JibriSipGateway(this, sipJibriDetector, this.logger);
            }
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception x) {
                this.logger.warn("An exception was caught while invoking stop()", x);
            }
            throw e;
        }
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        if (this.jibriSipGateway != null) {
            try {
                this.jibriSipGateway.shutdown();
            }
            catch (Exception e) {
                this.logger.error("jibriSipGateway.shutdown error", e);
            }
            this.jibriSipGateway = null;
        }
        if (this.jibriRecorder != null) {
            try {
                this.jibriRecorder.shutdown();
            }
            catch (Exception e) {
                this.logger.error("jibriRecorder.shutdown error", e);
            }
            this.jibriRecorder = null;
        }
        this.getClientXmppProvider().removeRegistrationListener(this);
        BridgeSelector bridgeSelector = this.jicofoServices.getBridgeSelector();
        bridgeSelector.removeHandler(this.bridgeSelectorEventHandler);
        this.colibriSessionManager.removeListener(this.colibriSessionManagerListener);
        try {
            this.expireBridgeSessions();
        }
        catch (Exception e) {
            this.logger.error("disposeConference error", e);
        }
        try {
            this.leaveTheRoom();
        }
        catch (Exception e) {
            this.logger.error("leaveTheRoom error", e);
        }
        if (this.jingle != null) {
            try {
                this.jingle.terminateHandlersSessions(this);
            }
            catch (Exception e) {
                this.logger.error("terminateHandlersSessions error", e);
            }
        }
        this.logger.info("Stopped.");
        if (this.listener != null) {
            this.listener.conferenceEnded(this);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private void joinTheRoom() throws Exception {
        ChatRoom chatRoom;
        this.logger.info("Joining " + this.roomName);
        this.chatRoom = chatRoom = this.getClientXmppProvider().findOrCreateRoom(this.roomName);
        chatRoom.addListener(this.chatRoomListener);
        AbstractAuthAuthority authenticationAuthority = this.jicofoServices.getAuthenticationAuthority();
        if (authenticationAuthority != null) {
            this.chatRoomRoleManager = new AuthenticationRoleManager(chatRoom, authenticationAuthority);
            chatRoom.addListener(this.chatRoomRoleManager);
        } else if (ConferenceConfig.config.enableAutoOwner()) {
            this.chatRoomRoleManager = new AutoOwnerRoleManager(chatRoom);
            chatRoom.addListener(this.chatRoomRoleManager);
        }
        this.transcriberManager = new TranscriberManager(this.jicofoServices.getXmppServices().getXmppConnectionByName(JigasiConfig.config.xmppConnectionName()), this, chatRoom, this.jicofoServices.getXmppServices().getJigasiDetector(), this.logger);
        chatRoom.join();
        if (chatRoom.getMeetingId() != null) {
            this.logger.addContext("meeting_id", chatRoom.getMeetingId());
        }
        ArrayList<ExtensionElement> presenceExtensions = new ArrayList<ExtensionElement>();
        presenceExtensions.add(EtherpadPacketExt.forDocumentName(this.etherpadName));
        ComponentVersionsExtension versionsExtension = new ComponentVersionsExtension();
        versionsExtension.addComponentVersion("focus", CurrentVersionImpl.VERSION.toString());
        presenceExtensions.add(versionsExtension);
        this.setConferenceProperty("support-terminate-restart", Boolean.TRUE.toString(), false);
        presenceExtensions.add(ConferenceProperties.clone(this.conferenceProperties));
        chatRoom.modifyPresence(null, presenceExtensions);
    }

    private void setConferenceProperty(String key, String value2) {
        this.setConferenceProperty(key, value2, true);
    }

    private void setConferenceProperty(String key, String value2, boolean updatePresence) {
        this.conferenceProperties.put(key, value2);
        if (updatePresence && this.chatRoom != null) {
            this.chatRoom.setPresenceExtension(ConferenceProperties.clone(this.conferenceProperties), false);
        }
    }

    private void onNumAudioSendersChanged(int numAudioSenders) {
        boolean newValue;
        boolean bl = newValue = numAudioSenders >= ConferenceConfig.config.getMaxAudioSenders();
        if (this.audioLimitReached != newValue) {
            this.audioLimitReached = newValue;
            this.setConferenceProperty("audio-limit-reached", String.valueOf(this.audioLimitReached));
        }
    }

    private void onNumVideoSendersChanged(int numVideoSenders) {
        boolean newValue;
        boolean bl = newValue = numVideoSenders >= ConferenceConfig.config.getMaxVideoSenders();
        if (this.videoLimitReached != newValue) {
            this.videoLimitReached = newValue;
            this.setConferenceProperty("video-limit-reached", String.valueOf(this.videoLimitReached));
        }
    }

    private void leaveTheRoom() {
        if (this.chatRoom == null) {
            this.logger.error("Chat room already left!");
            return;
        }
        if (this.chatRoomRoleManager != null) {
            this.chatRoom.removeListener(this.chatRoomRoleManager);
            this.chatRoomRoleManager.stop();
        }
        if (this.transcriberManager != null) {
            this.transcriberManager.dispose();
            this.transcriberManager = null;
        }
        this.chatRoom.leave();
        this.chatRoom.removeListener(this.chatRoomListener);
        this.chatRoom = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberJoined(@NotNull ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info("Member joined:" + chatRoomMember.getName() + " stats-id=" + chatRoomMember.getStatsId() + " region=" + chatRoomMember.getRegion() + " audioMuted=" + chatRoomMember.isAudioMuted() + " videoMuted=" + chatRoomMember.isVideoMuted() + " isJibri=" + chatRoomMember.isJibri() + " isJigasi=" + chatRoomMember.isJigasi());
            this.hasHadAtLeastOneParticipant = true;
            if (!this.checkMinParticipants()) {
                return;
            }
            this.cancelSingleParticipantTimeout();
            if (this.participants.size() == 0) {
                for (ChatRoomMember member : this.chatRoom.getMembers()) {
                    this.inviteChatMember(member, member == chatRoomMember);
                }
            } else {
                this.inviteChatMember(chatRoomMember, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteChatMember(ChatRoomMember chatRoomMember, boolean justJoined) {
        Object object = this.participantLock;
        synchronized (object) {
            if (this.participants.get(chatRoomMember.getOccupantJid()) != null) {
                return;
            }
            List<String> features = this.getClientXmppProvider().discoverFeatures(chatRoomMember.getOccupantJid());
            Participant participant = new Participant(chatRoomMember, features, this.logger, this);
            Statistics statistics = this.getFocusManager().getStatistics();
            statistics.totalParticipants.incrementAndGet();
            if (!participant.supportsReceivingMultipleVideoStreams()) {
                statistics.totalParticipantsNoMultiStream.incrementAndGet();
            }
            if (!participant.hasSourceNameSupport()) {
                statistics.totalParticipantsNoSourceName.incrementAndGet();
            }
            this.participants.put(chatRoomMember.getOccupantJid(), participant);
            this.inviteParticipant(participant, false, justJoined);
        }
    }

    private void inviteParticipant(@NotNull Participant participant, boolean reInvite, boolean justJoined) {
        ParticipantInviteRunnable channelAllocator = new ParticipantInviteRunnable(this, this.colibriSessionManager, participant, this.hasToStartAudioMuted(participant, justJoined), this.hasToStartVideoMuted(participant, justJoined), reInvite, this.logger);
        participant.setInviteRunnable(channelAllocator);
        TaskPools.getIoPool().execute(channelAllocator);
    }

    @NotNull
    ConferenceSourceMap getSourcesForParticipant(@NotNull Participant participant) {
        EndpointSourceSet participantSourcesSet = this.conferenceSources.get(participant.getMucJid());
        ConferenceSourceMap participantSourceMap = participantSourcesSet == null ? new ConferenceSourceMap() : new ConferenceSourceMap((Jid)participant.getMucJid(), participantSourcesSet);
        return participantSourceMap.unmodifiable();
    }

    private boolean hasToStartAudioMuted(@NotNull Participant participant, boolean justJoined) {
        if (this.startAudioMuted && justJoined) {
            return true;
        }
        int limit = ConferenceConfig.config.getMaxAudioSenders();
        Integer startAudioMutedInt = this.config.getStartAudioMuted();
        if (startAudioMutedInt != null) {
            limit = Math.min(limit, startAudioMutedInt);
        }
        return participant.getChatMember().getJoinOrderNumber() > limit;
    }

    private boolean hasToStartVideoMuted(@NotNull Participant participant, boolean justJoined) {
        if (this.startVideoMuted && justJoined) {
            return true;
        }
        int limit = ConferenceConfig.config.getMaxVideoSenders();
        Integer startVideoMutedInt = this.config.getStartVideoMuted();
        if (startVideoMutedInt != null) {
            limit = Math.min(limit, startVideoMutedInt);
        }
        return participant.getChatMember().getJoinOrderNumber() > limit;
    }

    private boolean checkMinParticipants() {
        int minParticipants = ConferenceConfig.config.getMinParticipants();
        ChatRoom chatRoom = this.getChatRoom();
        return chatRoom != null && chatRoom.getMembersCount() >= minParticipants;
    }

    public void destroy(String reason) {
        if (this.chatRoom == null) {
            this.logger.error("Unable to destroy conference MUC room, not joined");
            return;
        }
        this.chatRoom.destroy(reason, null);
    }

    private void expireBridgeSessions() {
        this.cancelSingleParticipantTimeout();
        this.colibriSessionManager.expire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberKicked(ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info("Member kicked: " + chatRoomMember.getName());
            this.onMemberLeft(chatRoomMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberLeft(ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info("Member left:" + chatRoomMember.getName());
            Participant leftParticipant = this.participants.get(chatRoomMember.getOccupantJid());
            if (leftParticipant != null) {
                this.terminateParticipant(leftParticipant, Reason.GONE, null, false, false);
            } else {
                this.logger.warn("Participant not found for " + chatRoomMember.getName() + ". Terminated already or never started?");
            }
            if (this.participants.size() == 1) {
                this.rescheduleSingleParticipantTimeout();
            } else if (this.participants.size() == 0) {
                this.expireBridgeSessions();
            }
        }
        if (this.chatRoom == null || this.chatRoom.getMembersCount() == 0) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateParticipant(Participant participant, Reason reason, String message, boolean sendSessionTerminate, boolean sendSourceRemove) {
        this.logger.info(String.format("Terminating %s, reason: %s, send session-terminate: %s", new Object[]{participant.getChatMember().getName(), reason, sendSessionTerminate}));
        Object object = this.participantLock;
        synchronized (object) {
            EndpointSourceSet participantSources;
            JingleSession jingleSession = participant.getJingleSession();
            if (jingleSession != null) {
                this.jingle.terminateSession(jingleSession, reason, message, sendSessionTerminate);
            }
            if ((participantSources = participant.getSources().get(participant.getMucJid())) != null) {
                this.removeSources(participant, participantSources, false, sendSourceRemove);
            }
            participant.setJingleSession(null);
            Participant removed = this.participants.remove(participant.getChatMember().getOccupantJid());
            this.logger.info("Removed participant " + participant.getChatMember().getName() + " removed=" + (removed != null));
        }
        this.colibriSessionManager.removeParticipant(participant);
    }

    @Override
    public void registrationChanged(boolean registered) {
        if (registered) {
            this.logger.info("XMPP reconnected");
            if (this.chatRoom == null) {
                try {
                    this.joinTheRoom();
                }
                catch (Exception e) {
                    this.logger.error("Failed to join the room: " + this.roomName, e);
                    this.stop();
                }
            }
        } else {
            this.logger.info("XMPP disconnected.");
            this.stop();
        }
    }

    @Nullable
    private Participant getParticipant(@NotNull JingleSession jingleSession) {
        return this.participants.get(jingleSession.getAddress());
    }

    @Override
    @Nullable
    public Participant getParticipant(@NotNull Jid occupantJid) {
        return this.participants.get(occupantJid);
    }

    @Override
    public MemberRole getRoleForMucJid(Jid mucJid) {
        if (this.chatRoom == null) {
            return null;
        }
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            if (!member.getOccupantJid().equals(mucJid)) continue;
            return member.getRole();
        }
        return null;
    }

    @Override
    public StanzaError onSessionAccept(@NotNull JingleSession jingleSession, List<ContentPacketExtension> answer) {
        this.logger.info("Receive session-accept from " + jingleSession.getAddress());
        return this.onSessionAcceptInternal(jingleSession, answer);
    }

    @Override
    public StanzaError onSessionInfo(@NotNull JingleSession session, JingleIQ iq) {
        String existingBridgeSessionId;
        String iceState;
        Jid address = session.getAddress();
        Participant participant = this.getParticipant(session);
        if (participant == null) {
            String errorMsg = "No session for " + address;
            this.logger.warn(errorMsg);
            return StanzaError.from(StanzaError.Condition.item_not_found, errorMsg).build();
        }
        IceStatePacketExtension iceStatePE = iq.getExtension(IceStatePacketExtension.class);
        String string = iceState = iceStatePE != null ? iceStatePE.getText() : null;
        if (!"failed".equalsIgnoreCase(iceState)) {
            this.logger.info(String.format("Ignored ice-state %s from %s", iceState, address));
            return null;
        }
        BridgeSessionPacketExtension bsPE = this.getBridgeSessionPacketExtension(iq);
        String bridgeSessionId = bsPE != null ? bsPE.getId() : null;
        if (Objects.equals(bridgeSessionId, existingBridgeSessionId = this.colibriSessionManager.getBridgeSessionId(participant))) {
            this.logger.info(String.format("Received ICE failed notification from %s, bridge-session ID: %s", address, bridgeSessionId));
            this.reInviteParticipant(participant);
        } else {
            this.logger.info(String.format("Ignored ICE failed notification for invalid session, participant: %s, bridge session ID: %s", address, bridgeSessionId));
        }
        this.listener.participantIceFailed();
        return null;
    }

    private BridgeSessionPacketExtension getBridgeSessionPacketExtension(@NotNull IQ iq) {
        return iq.getExtension(BridgeSessionPacketExtension.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StanzaError onSessionTerminate(@NotNull JingleSession session, JingleIQ iq) {
        boolean restartRequested;
        Participant participant = this.getParticipant(session);
        if (participant == null) {
            String errorMsg = "No participant for " + session.getAddress();
            this.logger.warn(errorMsg);
            return StanzaError.from(StanzaError.Condition.item_not_found, errorMsg).build();
        }
        BridgeSessionPacketExtension bsPE = this.getBridgeSessionPacketExtension(iq);
        String bridgeSessionId = bsPE != null ? bsPE.getId() : null;
        String existingBridgeSessionId = this.colibriSessionManager.getBridgeSessionId(participant);
        boolean bl = restartRequested = bsPE != null && bsPE.isRestart() != false;
        if (restartRequested) {
            this.listener.participantRequestedRestart();
        }
        if (!Objects.equals(bridgeSessionId, existingBridgeSessionId)) {
            this.logger.info(String.format("Ignored session-terminate for invalid session: %s, bridge session ID: %s restart: %s", participant, bridgeSessionId, restartRequested));
            return StanzaError.from(StanzaError.Condition.item_not_found, "invalid bridge session ID").build();
        }
        this.logger.info(String.format("Received session-terminate from %s, bridge-session ID: %s, restart: %s", participant, bridgeSessionId, restartRequested));
        Object object = this.participantLock;
        synchronized (object) {
            this.terminateParticipant(participant, null, null, false, true);
            if (restartRequested) {
                if (participant.incrementAndCheckRestartRequests()) {
                    this.participants.put(participant.getChatMember().getOccupantJid(), participant);
                    this.inviteParticipant(participant, false, false);
                } else {
                    this.logger.warn(String.format("Rate limiting %s for restart requests", participant));
                    return StanzaError.from(StanzaError.Condition.resource_constraint, "rate-limited").build();
                }
            }
        }
        return null;
    }

    private void propagateNewSources(Participant sourceOwner, ConferenceSourceMap sources) {
        if (sources.isEmpty()) {
            this.logger.debug("No new sources to propagate.");
            return;
        }
        this.participants.values().stream().filter(otherParticipant -> otherParticipant != sourceOwner).forEach(participant -> participant.addRemoteSources(sources));
    }

    @Override
    public void onTransportInfo(@NotNull JingleSession session, List<ContentPacketExtension> contentList) {
        Participant participant = this.getParticipant(session);
        if (participant == null) {
            this.logger.warn("Failed to process transport-info, no session for: " + session.getAddress());
            return;
        }
        this.colibriSessionManager.updateParticipant(participant, this.getTransport(contentList), null);
    }

    @Override
    public StanzaError onTransportAccept(@NotNull JingleSession jingleSession, List<ContentPacketExtension> contents) {
        this.logger.info("Received transport-accept from " + jingleSession.getAddress());
        return this.onSessionAcceptInternal(jingleSession, contents);
    }

    @Override
    public void onTransportReject(@NotNull JingleSession jingleSession, JingleIQ reply) {
        Participant p = this.getParticipant(jingleSession);
        if (p == null) {
            this.logger.warn("No participant for " + jingleSession);
            return;
        }
        this.logger.error("Participant has rejected our transport offer: " + p.getChatMember().getName() + ", response: " + reply.toXML());
    }

    @Override
    public StanzaError onAddSource(@NotNull JingleSession jingleSession, List<ContentPacketExtension> contents) {
        ConferenceSourceMap sourcesAccepted;
        boolean rejectedAudioSource;
        Jid address = jingleSession.getAddress();
        Participant participant = this.getParticipant(jingleSession);
        if (participant == null) {
            String errorMsg = "no session for " + address;
            this.logger.warn(errorMsg);
            return StanzaError.from(StanzaError.Condition.item_not_found, errorMsg).build();
        }
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesAdvertised = EndpointSourceSet.fromJingle(contents);
        this.logger.debug(() -> "Received source-add from " + participantId + ": " + sourcesAdvertised);
        boolean bl = rejectedAudioSource = sourcesAdvertised.getHasAudio() && this.chatRoom.getAudioSendersCount() >= ConferenceConfig.config.getMaxAudioSenders();
        if (rejectedAudioSource || sourcesAdvertised.getHasVideo() && this.chatRoom.getVideoSendersCount() >= ConferenceConfig.config.getMaxVideoSenders()) {
            String errorMsg = "Source add rejected. Maximum number of " + (rejectedAudioSource ? "audio" : "video") + " senders reached.";
            this.logger.warn(() -> participantId + ": " + errorMsg);
            return StanzaError.from(StanzaError.Condition.resource_constraint, errorMsg).build();
        }
        try {
            sourcesAccepted = this.conferenceSources.tryToAdd(participant.getMucJid(), sourcesAdvertised);
        }
        catch (ValidationFailedException e) {
            this.logger.error("Error adding SSRCs from: " + address + ": " + e.getMessage());
            return StanzaError.from(StanzaError.Condition.bad_request, e.getMessage()).build();
        }
        this.logger.debug(() -> "Accepted sources from " + participantId + ": " + sourcesAccepted);
        if (sourcesAccepted.isEmpty()) {
            this.logger.warn("Stop processing source-add, no new sources added: " + participantId);
            return null;
        }
        this.colibriSessionManager.updateParticipant(participant, null, participant.getSources());
        this.propagateNewSources(participant, sourcesAccepted);
        return null;
    }

    @Override
    public StanzaError onRemoveSource(@NotNull JingleSession sourceJingleSession, List<ContentPacketExtension> contents) {
        EndpointSourceSet sourcesRequestedToBeRemoved = EndpointSourceSet.fromJingle(contents);
        Participant participant = this.getParticipant(sourceJingleSession);
        if (participant == null) {
            this.logger.warn("No participant for jingle-session: " + sourceJingleSession);
            return StanzaError.from(StanzaError.Condition.bad_request, "No associated participant").build();
        }
        return this.removeSources(participant, sourcesRequestedToBeRemoved, true, true);
    }

    private StanzaError onSessionAcceptInternal(@NotNull JingleSession jingleSession, List<ContentPacketExtension> contents) {
        UnmodifiableConferenceSourceMap sourcesAccepted;
        Participant participant = this.getParticipant(jingleSession);
        Jid participantJid = jingleSession.getAddress();
        if (participant == null) {
            String errorMsg = "No participant found for: " + participantJid;
            this.logger.warn(errorMsg);
            return StanzaError.from(StanzaError.Condition.item_not_found, errorMsg).build();
        }
        if (participant.getJingleSession() != null && participant.getJingleSession() != jingleSession) {
            this.logger.error("Reassigning jingle session for participant: " + participantJid);
        }
        participant.setJingleSession(jingleSession);
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesAdvertised = EndpointSourceSet.fromJingle(contents);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received initial sources from " + participantId + ": " + sourcesAdvertised);
        }
        try {
            sourcesAccepted = this.conferenceSources.tryToAdd(participantJid, sourcesAdvertised).unmodifiable();
        }
        catch (ValidationFailedException e) {
            this.logger.error("Error processing session-accept from: " + participantJid + ": " + e.getMessage());
            return StanzaError.from(StanzaError.Condition.bad_request, e.getMessage()).build();
        }
        this.logger.info("Accepted initial sources from " + participantId + ": " + sourcesAccepted);
        this.colibriSessionManager.updateParticipant(participant, this.getTransport(contents), this.getSourcesForParticipant(participant));
        this.propagateNewSources(participant, sourcesAccepted);
        participant.sendQueuedRemoteSources();
        return null;
    }

    private IceUdpTransportPacketExtension getTransport(@NotNull List<ContentPacketExtension> contents) {
        ContentPacketExtension content;
        IceUdpTransportPacketExtension transport = null;
        Iterator<ContentPacketExtension> iterator2 = contents.iterator();
        while (iterator2.hasNext() && (transport = (content = iterator2.next()).getFirstChildOfType(IceUdpTransportPacketExtension.class)) == null) {
        }
        if (transport == null) {
            this.logger.error("No valid transport supplied in transport-update from $participant");
            return null;
        }
        if (!transport.isRtcpMux()) {
            transport.addChildExtension(new IceRtcpmuxPacketExtension());
        }
        return transport;
    }

    private StanzaError removeSources(@NotNull Participant participant, EndpointSourceSet sourcesRequestedToBeRemoved, boolean removeColibriSourcesFromLocalBridge, boolean sendSourceRemove) {
        ConferenceSourceMap sourcesAcceptedToBeRemoved;
        EntityFullJid participantJid = participant.getMucJid();
        try {
            sourcesAcceptedToBeRemoved = this.conferenceSources.tryToRemove(participantJid, sourcesRequestedToBeRemoved);
        }
        catch (ValidationFailedException e) {
            this.logger.error("Error removing SSRCs from: " + participantJid + ": " + e.getMessage());
            return StanzaError.from(StanzaError.Condition.bad_request, e.getMessage()).build();
        }
        String participantId = participant.getEndpointId();
        this.logger.debug(() -> "Received source removal request from " + participantId + ": " + sourcesRequestedToBeRemoved);
        this.logger.debug(() -> "Accepted sources to remove from " + participantId + ": " + sourcesAcceptedToBeRemoved);
        if (sourcesAcceptedToBeRemoved.isEmpty()) {
            this.logger.warn("No sources or groups to be removed from " + participantId + ". The requested sources to remove: " + sourcesRequestedToBeRemoved);
            return null;
        }
        this.colibriSessionManager.updateParticipant(participant, null, participant.getSources(), !removeColibriSourcesFromLocalBridge);
        if (sendSourceRemove) {
            this.sendSourceRemove(sourcesAcceptedToBeRemoved, participant);
        }
        return null;
    }

    private void sendSourceRemove(ConferenceSourceMap sources, Participant except) {
        if (sources.isEmpty()) {
            this.logger.debug("No sources to remove.");
            return;
        }
        this.participants.values().stream().filter(participant -> participant != except).forEach(participant -> participant.removeRemoteSources(sources));
    }

    @NotNull
    public ConferenceSourceMap getSources() {
        return this.conferenceSources.unmodifiable();
    }

    @Override
    @NotNull
    public EntityBareJid getRoomName() {
        return this.roomName;
    }

    @NotNull
    public XmppProvider getClientXmppProvider() {
        return this.jicofoServices.getXmppServices().getClientConnection();
    }

    public boolean hasMember(Jid jid) {
        ChatRoom chatRoom = this.chatRoom;
        return chatRoom != null && jid instanceof EntityFullJid && chatRoom.getChatMember((EntityFullJid)jid) != null;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public boolean hasHadAtLeastOneParticipant() {
        return this.hasHadAtLeastOneParticipant;
    }

    public OperationSetJingle getJingle() {
        return this.jingle;
    }

    @Override
    @NotNull
    public MuteResult handleMuteRequest(@NotNull Jid muterJid, @NotNull Jid toBeMutedJid, boolean doMute, @NotNull MediaType mediaType) {
        Participant muter = this.getParticipant(muterJid);
        if (muter == null) {
            this.logger.warn("Muter participant not found, jid=" + muterJid);
            return MuteResult.ERROR;
        }
        if (!muterJid.equals(toBeMutedJid) && !MemberRoleKt.hasModeratorRights(muter.getChatMember().getRole())) {
            this.logger.warn("Mute not allowed for non-moderator " + muterJid);
            return MuteResult.NOT_ALLOWED;
        }
        Participant participant = this.getParticipant(toBeMutedJid);
        if (participant == null) {
            this.logger.warn("Participant to be muted not found, jid=" + toBeMutedJid);
            return MuteResult.ERROR;
        }
        if (!doMute) {
            if (!muterJid.equals(toBeMutedJid)) {
                this.logger.warn("Unmute not allowed, muterJid=" + muterJid + ", toBeMutedJid=" + toBeMutedJid);
                return MuteResult.NOT_ALLOWED;
            }
            if (!participant.hasModeratorRights() && !this.chatRoom.isMemberAllowedToUnmute(toBeMutedJid, mediaType)) {
                this.logger.warn("Unmute not allowed due to av moderation for jid=" + toBeMutedJid);
                return MuteResult.NOT_ALLOWED;
            }
        }
        if (participant.shouldSuppressForceMute()) {
            this.logger.warn("Force mute suppressed, returning NOT_ALLOWED:" + participant);
            return MuteResult.NOT_ALLOWED;
        }
        this.logger.info("Will " + (doMute ? "mute" : "unmute") + " " + toBeMutedJid + " on behalf of " + muterJid + " for " + mediaType);
        this.colibriSessionManager.mute(participant.getEndpointId(), doMute, mediaType);
        return MuteResult.SUCCESS;
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put("name", this.roomName.toString());
        o.put("config", this.config.getDebugState());
        ChatRoom chatRoom = this.chatRoom;
        o.put("chat_room", chatRoom == null ? "null" : chatRoom.getDebugState());
        OrderedJsonObject participantsJson = new OrderedJsonObject();
        for (Participant participant : this.participants.values()) {
            participantsJson.put(participant.getEndpointId(), participant.getDebugState());
        }
        o.put("participants", participantsJson);
        ChatRoomRoleManager chatRoomRoleManager = this.chatRoomRoleManager;
        o.put("chat_room_role_manager", chatRoomRoleManager == null ? "null" : chatRoomRoleManager.getDebugState());
        o.put("started", (Object)this.started.get());
        o.put("creation_time", this.creationTime.toString());
        o.put("has_had_at_least_one_participant", (Object)this.hasHadAtLeastOneParticipant);
        o.put("start_audio_muted", (Object)this.startAudioMuted);
        o.put("start_video_muted", (Object)this.startVideoMuted);
        o.put("colibri_session_manager", this.colibriSessionManager.getDebugState());
        OrderedJsonObject conferencePropertiesJson = new OrderedJsonObject();
        for (ConferenceProperties.ConferenceProperty conferenceProperty : this.conferenceProperties.getProperties()) {
            conferencePropertiesJson.put(conferenceProperty.getKey(), conferenceProperty.getValue());
        }
        o.put("conference_properties", conferencePropertiesJson);
        o.put("include_in_statistics", (Object)this.includeInStatistics);
        o.put("conference_sources", this.conferenceSources.toJson());
        o.put("audio_limit_reached", (Object)this.audioLimitReached);
        o.put("video_limit_reached", (Object)this.videoLimitReached);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void muteAllParticipants(MediaType mediaType) {
        HashSet<Participant> participantsToMute = new HashSet<Participant>();
        Iterator iterator2 = this.participantLock;
        synchronized (iterator2) {
            for (Participant participant : this.participants.values()) {
                if (participant.shouldSuppressForceMute()) {
                    this.logger.info("Will not mute a trusted participant without unmute support (jibri, jigasi): " + participant);
                    continue;
                }
                participantsToMute.add(participant);
            }
        }
        this.colibriSessionManager.mute(participantsToMute.stream().map(p -> p.getEndpointId()).collect(Collectors.toSet()), true, mediaType);
        for (Participant participant : participantsToMute) {
            IQ muteStatusUpdate;
            IQ muteIq = null;
            if (mediaType == MediaType.AUDIO) {
                muteStatusUpdate = new MuteIq();
                muteStatusUpdate.setType(IQ.Type.set);
                muteStatusUpdate.setTo(participant.getMucJid());
                ((MuteIq)muteStatusUpdate).setMute(true);
                muteIq = muteStatusUpdate;
            } else if (mediaType == MediaType.VIDEO) {
                muteStatusUpdate = new MuteVideoIq();
                muteStatusUpdate.setType(IQ.Type.set);
                muteStatusUpdate.setTo(participant.getMucJid());
                ((MuteVideoIq)muteStatusUpdate).setMute(true);
                muteIq = muteStatusUpdate;
            }
            if (muteIq == null) continue;
            UtilKt.tryToSendStanza(this.getClientXmppProvider().getXmppConnection(), muteIq);
        }
    }

    @Override
    public int getParticipantCount() {
        return this.participants.size();
    }

    public String getBridgeVersion() {
        return this.jvbVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBridgeUp(Jid bridgeJid) {
        if (!this.started.get()) {
            return;
        }
        if (this.chatRoom != null && this.checkMinParticipants() && this.colibriSessionManager.getBridgeCount() == 0) {
            this.logger.info("New bridge available, will try to restart: " + bridgeJid);
            Object object = this.participantLock;
            synchronized (object) {
                this.reInviteParticipants(this.participants.values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInviteParticipantsById(@NotNull List<String> participantIdsToReinvite) {
        if (!participantIdsToReinvite.isEmpty()) {
            this.listener.participantsMoved(participantIdsToReinvite.size());
            Object object = this.participantLock;
            synchronized (object) {
                ArrayList<Participant> participantsToReinvite = new ArrayList<Participant>();
                for (Participant participant : this.participants.values()) {
                    if (!participantIdsToReinvite.contains(participant.getEndpointId())) continue;
                    participantsToReinvite.add(participant);
                }
                if (participantsToReinvite.size() != participantIdsToReinvite.size()) {
                    this.logger.error("Can not re-invite all participants, no Participant object for some of them.");
                }
                this.reInviteParticipants(participantsToReinvite);
            }
        }
    }

    public void onInviteFailed(ParticipantInviteRunnable channelAllocator) {
        this.terminateParticipant(channelAllocator.getParticipant(), Reason.GENERAL_ERROR, "jingle session failed", true, true);
    }

    @Override
    @Nullable
    public ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    @NotNull
    public JitsiMeetConfig getConfig() {
        return this.config;
    }

    private String createSharedDocumentName() {
        if (ConferenceConfig.config.useRandomSharedDocumentName()) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        return this.roomName.getLocalpart().toString();
    }

    private void reInviteParticipant(Participant participant) {
        ArrayList<Participant> l = new ArrayList<Participant>(1);
        l.add(participant);
        this.reInviteParticipants(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInviteParticipants(Collection<Participant> participants) {
        Object object = this.participantLock;
        synchronized (object) {
            for (Participant participant : participants) {
                boolean restartJingle;
                participant.setInviteRunnable(null);
                boolean bl = restartJingle = ConferenceConfig.config.getReinviteMethod() == ReinviteMethod.RestartJingle;
                if (restartJingle) {
                    JingleSession jingleSession;
                    EndpointSourceSet participantSources = participant.getSources().get(participant.getMucJid());
                    if (participantSources != null && !participantSources.isEmpty()) {
                        this.removeSources(participant, participantSources, false, true);
                    }
                    if ((jingleSession = participant.getJingleSession()) != null) {
                        this.jingle.terminateSession(jingleSession, Reason.SUCCESS, "moving", true);
                    }
                    participant.setJingleSession(null);
                }
                this.inviteParticipant(participant, !restartJingle, false);
            }
        }
    }

    private void rescheduleSingleParticipantTimeout() {
        this.cancelSingleParticipantTimeout();
        long timeout = ConferenceConfig.config.getSingleParticipantTimeout().toMillis();
        this.singleParticipantTout = TaskPools.getScheduledPool().schedule(new SinglePersonTimeout(), timeout, TimeUnit.MILLISECONDS);
        this.logger.info("Scheduled single person timeout.");
    }

    private void cancelSingleParticipantTimeout() {
        if (this.singleParticipantTout != null) {
            this.logger.debug("Cancelling single person timeout.");
            this.singleParticipantTout.cancel(false);
            this.singleParticipantTout = null;
        }
    }

    @Override
    @NotNull
    public Set<String> getBridgeRegions() {
        return this.colibriSessionManager.getBridgeRegions();
    }

    @Override
    public boolean includeInStatistics() {
        return this.includeInStatistics;
    }

    @Override
    @NotNull
    public IqProcessingResult handleJibriRequest(@NotNull IqRequest<JibriIq> request) {
        IqProcessingResult result2 = new IqProcessingResult.NotProcessed();
        if (this.started.get()) {
            if (this.jibriRecorder != null) {
                result2 = this.jibriRecorder.handleJibriRequest(request);
            }
            if (result2 instanceof IqProcessingResult.NotProcessed && this.jibriSipGateway != null) {
                result2 = this.jibriSipGateway.handleJibriRequest(request);
            }
        }
        return result2;
    }

    @Override
    public boolean acceptJigasiRequest(@NotNull Jid from) {
        return MemberRoleKt.hasModeratorRights(this.getRoleForMucJid(from));
    }

    private FocusManager getFocusManager() {
        return this.jicofoServices.getFocusManager();
    }

    @Override
    public JibriRecorder getJibriRecorder() {
        return this.jibriRecorder;
    }

    @Override
    public JibriSipGateway getJibriSipGateway() {
        return this.jibriSipGateway;
    }

    void desktopSourceIsMutedChanged(Participant participant, boolean desktopSourceIsMuted) {
        if (!ConferenceConfig.config.getMultiStreamBackwardCompat()) {
            return;
        }
        this.participants.values().stream().filter(p -> p != participant).filter(p -> !p.supportsReceivingMultipleVideoStreams()).forEach(p -> p.remoteDesktopSourceIsMutedChanged(participant.getMucJid(), desktopSourceIsMuted));
    }

    public String toString() {
        return String.format("JitsiMeetConferenceImpl[name=%s]", this.getRoomName());
    }

    private class ColibriSessionManagerListener
    implements ColibriSessionManager.Listener {
        private ColibriSessionManagerListener() {
        }

        @Override
        public void bridgeCountChanged(int bridgeCount) {
            JitsiMeetConferenceImpl.this.setConferenceProperty("bridge-count", Integer.toString(bridgeCount));
        }

        @Override
        public void bridgeSelectionFailed() {
            ChatRoom chatRoom = JitsiMeetConferenceImpl.this.getChatRoom();
            if (chatRoom != null && !chatRoom.containsPresenceExtension("bridgeNotAvailable", "http://jitsi.org/protocol/focus")) {
                chatRoom.setPresenceExtension(new BridgeNotAvailablePacketExt(), false);
            }
        }

        @Override
        public void bridgeSelectionSucceeded() {
            ChatRoom chatRoom = JitsiMeetConferenceImpl.this.chatRoom;
            if (chatRoom != null) {
                chatRoom.setPresenceExtension(new BridgeNotAvailablePacketExt(), true);
            }
        }

        @Override
        public void bridgeRemoved(@NotNull Bridge bridge2, @NotNull List<String> participantIds) {
            JitsiMeetConferenceImpl.this.logger.info("Bridge " + bridge2 + " was removed from the conference. Re-inviting its participants: " + participantIds);
            JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIds);
        }
    }

    private class ChatRoomListenerImpl
    implements ChatRoomListener {
        private ChatRoomListenerImpl() {
        }

        @Override
        public void roomDestroyed(String reason) {
            JitsiMeetConferenceImpl.this.logger.info("Room destroyed with reason=" + reason);
            JitsiMeetConferenceImpl.this.stop();
        }

        @Override
        public void startMutedChanged(boolean startAudioMuted, boolean startVideoMuted) {
            JitsiMeetConferenceImpl.this.startAudioMuted = startAudioMuted;
            JitsiMeetConferenceImpl.this.startVideoMuted = startVideoMuted;
        }

        @Override
        public void memberJoined(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberJoined(member);
        }

        @Override
        public void memberKicked(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberKicked(member);
        }

        @Override
        public void memberLeft(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberLeft(member);
        }

        @Override
        public void localRoleChanged(@NotNull MemberRole newRole, @Nullable MemberRole oldRole) {
            if (newRole != MemberRole.OWNER) {
                JitsiMeetConferenceImpl.this.logger.warn("Stopping, because the local role changed to " + newRole + " (owner privileges are required).");
                JitsiMeetConferenceImpl.this.stop();
            }
        }

        @Override
        public void memberPresenceChanged(@NotNull ChatRoomMember member) {
            Participant participant = JitsiMeetConferenceImpl.this.getParticipant(member.getOccupantJid());
            if (participant != null) {
                participant.presenceChanged();
            }
        }

        @Override
        public void numAudioSendersChanged(int numAudioSenders) {
            JitsiMeetConferenceImpl.this.onNumAudioSendersChanged(numAudioSenders);
        }

        @Override
        public void numVideoSendersChanged(int numVideoSenders) {
            JitsiMeetConferenceImpl.this.onNumVideoSendersChanged(numVideoSenders);
        }
    }

    private class BridgeSelectorEventHandler
    implements BridgeSelector.EventHandler {
        private BridgeSelectorEventHandler() {
        }

        @Override
        public void bridgeIsShuttingDown(@NotNull Bridge bridge2) {
            List<String> participantIdsToReinvite = JitsiMeetConferenceImpl.this.colibriSessionManager.removeBridge(bridge2);
            if (!participantIdsToReinvite.isEmpty()) {
                JitsiMeetConferenceImpl.this.logger.info("Bridge " + bridge2.getJid() + " is shutting down, re-inviting " + participantIdsToReinvite);
                JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIdsToReinvite);
            }
        }

        @Override
        public void bridgeRemoved(@NotNull Bridge bridge2) {
            List<String> participantIdsToReinvite = JitsiMeetConferenceImpl.this.colibriSessionManager.removeBridge(bridge2);
            if (!participantIdsToReinvite.isEmpty()) {
                JitsiMeetConferenceImpl.this.logger.info("Removed " + bridge2.getJid() + ", re-inviting " + participantIdsToReinvite);
                JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIdsToReinvite);
            }
        }

        @Override
        public void bridgeAdded(Bridge bridge2) {
            JitsiMeetConferenceImpl.this.onBridgeUp(bridge2.getJid());
        }
    }

    private class SinglePersonTimeout
    implements Runnable {
        private SinglePersonTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = JitsiMeetConferenceImpl.this.participantLock;
            synchronized (object) {
                if (JitsiMeetConferenceImpl.this.participants.size() == 1) {
                    Participant p = JitsiMeetConferenceImpl.this.participants.values().stream().findFirst().orElse(null);
                    JitsiMeetConferenceImpl.this.logger.info("Timing out single participant: " + p.getChatMember().getName());
                    JitsiMeetConferenceImpl.this.terminateParticipant(p, Reason.EXPIRED, "Idle session timeout", true, false);
                    JitsiMeetConferenceImpl.this.expireBridgeSessions();
                } else {
                    JitsiMeetConferenceImpl.this.logger.error("Should never execute if more than 1 participant?");
                }
                JitsiMeetConferenceImpl.this.singleParticipantTout = null;
            }
        }
    }

    public static interface ConferenceListener {
        public void conferenceEnded(JitsiMeetConferenceImpl var1);

        public void participantsMoved(int var1);

        public void participantIceFailed();

        public void participantRequestedRestart();
    }
}

