/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import kotlin.jvm.functions.Function0;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jitsi.cmd.CmdLine;
import org.jitsi.cmd.ParseException;
import org.jitsi.config.JitsiConfig;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.metaconfig.MetaconfigLogger;
import org.jitsi.metaconfig.MetaconfigSettings;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class Main {
    private static final Logger logger = new LoggerImpl(Main.class.getName());

    public static void main(String[] args2) throws ParseException {
        JicofoServices jicofoServices;
        logger.info("Starting Jicofo.");
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error("An uncaught exception occurred in thread=" + t, e));
        Main.setupMetaconfigLogger();
        Main.setSystemProperties(args2);
        JitsiConfig.Companion.reloadNewConfig();
        ConfigUtils.PASSWORD_SYS_PROPS = "pass";
        ConfigUtils.PASSWORD_CMD_LINE_ARGS = "user_password";
        ShutdownServiceImpl shutdownService = new ShutdownServiceImpl();
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownService::beginShutdown));
        JicofoServices.jicofoServicesSingleton = jicofoServices = new JicofoServices();
        try {
            shutdownService.waitForShutdown();
        }
        catch (Exception e2) {
            logger.error(e2, e2);
        }
        logger.info("Stopping services.");
        jicofoServices.shutdown();
        TaskPools.shutdown();
        JicofoServices.jicofoServicesSingleton = null;
    }

    private static void setSystemProperties(String[] args2) throws ParseException {
        CmdLine cmdLine = new CmdLine();
        cmdLine.parse(args2);
        String componentDomain = cmdLine.getOptionValue("domain");
        String host = cmdLine.getOptionValue("--host", componentDomain == null ? "localhost" : componentDomain);
        if (StringUtils.isBlank(componentDomain)) {
            componentDomain = host;
        }
        if (componentDomain != null) {
            System.setProperty("org.jitsi.jicofo.XMPP_DOMAIN", componentDomain);
        }
        if (host != null) {
            System.setProperty("org.jitsi.jicofo.HOSTNAME", host);
        }
        String focusDomain = cmdLine.getOptionValue("--user_domain");
        String focusUserName = cmdLine.getOptionValue("--user_name");
        String focusPassword = cmdLine.getOptionValue("--user_password");
        if (StringUtils.isBlank(focusPassword)) {
            focusPassword = System.getenv("JICOFO_AUTH_PASSWORD");
        }
        if (focusDomain != null) {
            System.setProperty("org.jitsi.jicofo.FOCUS_USER_DOMAIN", focusDomain);
        }
        if (focusUserName != null) {
            System.setProperty("org.jitsi.jicofo.FOCUS_USER_NAME", focusUserName);
        }
        if (StringUtils.isNotBlank(focusPassword)) {
            System.setProperty("org.jitsi.jicofo.FOCUS_USER_PASSWORD", focusPassword);
        }
    }

    private static void setupMetaconfigLogger() {
        final LoggerImpl configLogger = new LoggerImpl("org.jitsi.config");
        MetaconfigSettings.Companion.setLogger(new MetaconfigLogger(){

            @Override
            public void warn(@NotNull Function0<String> function0) {
                configLogger.warn(function0::invoke);
            }

            @Override
            public void error(@NotNull Function0<String> function0) {
                configLogger.error(function0::invoke);
            }

            @Override
            public void debug(@NotNull Function0<String> function0) {
                configLogger.debug(function0::invoke);
            }
        });
    }
}

