/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class LabelTableColumn
extends ProgramLocationTableColumnExtensionPoint<ProgramLocation, String> {
    @Override
    public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Symbol symbol = this.getSymbol(rowObject, program);
        if (symbol != null) {
            return symbol.getProgramLocation();
        }
        return rowObject;
    }

    public String getColumnName() {
        return "Label";
    }

    public String getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        if (rowObject instanceof LabelFieldLocation) {
            LabelFieldLocation labelFieldLocation = (LabelFieldLocation)rowObject;
            return labelFieldLocation.getSymbolPath().getName();
        }
        Symbol symbol = this.getSymbol(rowObject, program);
        if (symbol != null) {
            return symbol.getName();
        }
        return null;
    }

    private Symbol getSymbol(ProgramLocation rowObject, Program program) throws IllegalArgumentException {
        Variable var;
        ProgramLocation location = rowObject;
        if (rowObject instanceof VariableLocation && (var = ((VariableLocation)rowObject).getVariable()) != null) {
            return var.getSymbol();
        }
        Address address = location.getAddress();
        SymbolTable symbolTable = program.getSymbolTable();
        return symbolTable.getPrimarySymbol(address);
    }

    public int getColumnPreferredWidth() {
        return 200;
    }
}

