/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class FSBRootNode
extends GTreeSlowLoadingNode
implements GTreeRootNode,
FSBNode {
    private FileSystemRef fsRef;
    private GTree tree;
    private FSBFileNode prevNode;
    private List<FSBRootNode> subRootNodes = new ArrayList<FSBRootNode>();

    FSBRootNode(FileSystemRef fsRef) {
        this.fsRef = fsRef;
    }

    FSBRootNode(FileSystemRef fsRef, GTree gTree, FSBFileNode prevNode) {
        this.fsRef = fsRef;
        this.tree = gTree;
        this.prevNode = prevNode;
    }

    public FileSystemRef getFSRef() {
        return this.fsRef;
    }

    public void releaseFSRefs() {
        for (FSBRootNode subFSBRootNode : this.subRootNodes) {
            subFSBRootNode.releaseFSRefs();
        }
        this.subRootNodes.clear();
        if (this.fsRef != null) {
            this.fsRef.close();
            this.fsRef = null;
        }
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getName() {
        return this.fsRef != null && !this.fsRef.isClosed() ? this.fsRef.getFilesystem().getName() : " Missing ";
    }

    public String getToolTip() {
        return this.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    public void dispose() {
        this.releaseFSRefs();
        super.dispose();
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (this.fsRef != null) {
            try {
                return FSBNode.getNodesFromFileList(this.fsRef.getFilesystem().getListing(null));
            }
            catch (IOException e) {
                FSUtilities.displayException(this, null, "Error Opening File System", "Problem generating children at root of file system", e);
            }
        }
        return Collections.emptyList();
    }

    public void setGTree(GTree tree) {
        this.tree = tree;
    }

    public GTree getGTree() {
        return this.tree;
    }

    @Override
    public FSRL getFSRL() {
        return this.fsRef.getFilesystem().getFSRL();
    }

    public FSBFileNode getPrevNode() {
        return this.prevNode;
    }

    public List<FSBRootNode> getSubRootNodes() {
        return this.subRootNodes;
    }
}

