/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;

class OpenDomainFileTask
extends Task {
    private DomainFile domainFile;
    private int version;
    private DataTypeManagerPlugin dtmPlugin;
    private DataTypeManagerHandler dtmHandler;
    private PluginTool tool;
    private DataTypeArchive dtArchive = null;

    OpenDomainFileTask(DomainFile domainFile, int version, PluginTool tool, DataTypeManagerPlugin dtmPlugin) {
        super("Open Project Data Type Archive", true, true, true);
        this.domainFile = domainFile;
        this.dtmPlugin = dtmPlugin;
        this.dtmHandler = dtmPlugin.getDataTypeManagerHandler();
        this.tool = tool;
        this.version = version;
    }

    DataTypeArchive getArchive() {
        return this.dtArchive;
    }

    public void run(TaskMonitor monitor) {
        if (this.isFileOpen()) {
            return;
        }
        boolean associateWithOriginalDomainFile = true;
        if (this.version != -1) {
            this.openReadOnlyFile(monitor);
            associateWithOriginalDomainFile = false;
        } else if (this.domainFile.isReadOnly()) {
            this.openReadOnlyFile(monitor);
        } else if (this.domainFile.isVersioned() && !this.domainFile.isCheckedOut()) {
            this.openReadOnlyFile(monitor);
        } else {
            this.openUnversionedFile(monitor);
        }
        if (this.dtArchive != null) {
            this.openFileInTree(associateWithOriginalDomainFile);
            this.dtArchive.release((Object)this);
        }
    }

    private boolean isFileOpen() {
        List<Archive> dtArchiveList = this.dtmHandler.getAllArchives();
        for (int i = 0; i < dtArchiveList.size(); ++i) {
            ProjectArchive projectArchive;
            DomainFile archiveDomainFile;
            Archive archive = dtArchiveList.get(i);
            if (!(archive instanceof ProjectArchive) || !this.filesMatch(this.domainFile, archiveDomainFile = (projectArchive = (ProjectArchive)archive).getDomainFile())) continue;
            return true;
        }
        return false;
    }

    private boolean filesMatch(DomainFile file1, DomainFile file2) {
        if (!file1.getPathname().equals(file2.getPathname())) {
            return false;
        }
        if (file1.isCheckedOut() != file2.isCheckedOut()) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)file1.getProjectLocator(), (Object)file2.getProjectLocator())) {
            return false;
        }
        int otherVersion = file2.isReadOnly() ? file2.getVersion() : -1;
        return this.version == otherVersion;
    }

    private void openReadOnlyFile(TaskMonitor monitor) {
        String fileDescr = (String)(this.version != -1 ? "version " + this.version + " of " : "") + this.domainFile.getName();
        String contentType = null;
        try {
            monitor.setMessage("Opening " + fileDescr);
            contentType = this.domainFile.getContentType();
            this.dtArchive = (DataTypeArchive)this.domainFile.getReadOnlyDomainObject((Object)this, this.version, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            if (this.domainFile.isVersioned() && this.domainFile.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)"Get Versioned Object", null);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Project Archive Open Error", (Object)("Error occurred while opening " + fileDescr), (Throwable)e);
            }
        }
        catch (VersionException e) {
            VersionExceptionHandler.showVersionError((Component)this.tool.getToolFrame(), (String)this.domainFile.getName(), (String)contentType, (String)"Open", (VersionException)e);
        }
    }

    private void openUnversionedFile(TaskMonitor monitor) {
        monitor.setMessage("Opening " + this.domainFile.getName());
        String contentType = null;
        try {
            boolean recoverFile = this.isRecoveryOK(this.domainFile);
            contentType = this.domainFile.getContentType();
            try {
                this.dtArchive = (DataTypeArchive)this.domainFile.getDomainObject((Object)this, false, recoverFile, monitor);
            }
            catch (VersionException e) {
                if (VersionExceptionHandler.isUpgradeOK(null, (DomainFile)this.domainFile, (String)"Open", (VersionException)e)) {
                    this.dtArchive = (DataTypeArchive)this.domainFile.getDomainObject((Object)this, true, recoverFile, monitor);
                }
            }
        }
        catch (VersionException e) {
            VersionExceptionHandler.showVersionError(null, (String)this.domainFile.getName(), (String)contentType, (String)"Open", (VersionException)e);
        }
        catch (CancelledException e) {
        }
        catch (Exception e) {
            if (this.domainFile.isInWritableProject() && e instanceof IOException) {
                RepositoryAdapter repo = this.domainFile.getParent().getProjectData().getRepository();
                ClientUtil.handleException((RepositoryAdapter)repo, (Exception)e, (String)"Open File", null);
            }
            Msg.showError((Object)((Object)this), null, (String)("Error Opening " + this.domainFile.getName()), (Object)("Opening data type archive failed.\n" + e.getMessage()));
        }
    }

    private boolean isRecoveryOK(DomainFile dfile) throws InterruptedException, InvocationTargetException {
        boolean[] recoverFile = new boolean[]{false};
        if (dfile.isInWritableProject() && dfile.canRecover()) {
            Runnable r = () -> {
                int option = OptionDialog.showYesNoDialog(null, (String)"Crash Recovery Data Found", (String)("<html>" + HTMLUtilities.escapeHTML((String)dfile.getName()) + " has crash data.<br>Would you like to recover unsaved changes?"));
                recoverFile[0] = option == 1;
            };
            SwingUtilities.invokeAndWait(r);
        }
        return recoverFile[0];
    }

    private void openFileInTree(boolean associatedWithOriginalDomainFile) {
        DomainFile df;
        DataTypeManagerHandler manager;
        Archive archive;
        DataTypesProvider provider = this.dtmPlugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GTreeNode node = this.getNodeForArchive(tree, archive = (manager = this.dtmPlugin.getDataTypeManagerHandler()).openArchive(this.dtArchive, df = associatedWithOriginalDomainFile ? this.domainFile : this.dtArchive.getDomainFile()));
        if (node != null) {
            tree.setSelectedNode(node);
        }
    }

    private GTreeNode getNodeForArchive(GTree tree, Archive archive) {
        GTreeRootNode rootNode = tree.getRootNode();
        for (GTreeNode node : rootNode) {
            ArchiveNode archiveNode;
            if (!(node instanceof ArchiveNode) || (archiveNode = (ArchiveNode)node).getArchive() != archive) continue;
            return archiveNode;
        }
        return null;
    }
}

