/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;

public class AddLabelCmd
implements Command {
    private Address addr;
    private String name;
    private Namespace namespace;
    private boolean useLocalNamespace;
    private SourceType source;
    private String errorMsg = "";
    private Symbol symbol;

    public AddLabelCmd(Address addr, String name, Namespace namespace, SourceType source) {
        this.addr = addr;
        this.name = name;
        this.namespace = namespace;
        this.source = source;
        this.useLocalNamespace = false;
    }

    public AddLabelCmd(Address addr, String name, boolean useLocalNamespace, SourceType source) {
        this.addr = addr;
        this.name = name;
        this.useLocalNamespace = useLocalNamespace;
        this.source = source;
    }

    public AddLabelCmd(Address addr, String name, SourceType source) {
        this(addr, name, null, source);
    }

    public boolean applyTo(DomainObject obj) {
        SymbolTable st = ((Program)obj).getSymbolTable();
        if (this.namespace == null && this.useLocalNamespace) {
            this.namespace = st.getNamespace(this.addr);
        }
        try {
            this.symbol = st.createLabel(this.addr, this.name, this.namespace, this.source);
            return true;
        }
        catch (InvalidInputException e) {
            this.errorMsg = this.name == null || this.name.length() == 0 ? "You must enter a valid label name" : "Invalid name: " + e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "Add Label";
    }

    public String getLabelName() {
        return this.name;
    }

    public Address getLabelAddr() {
        return this.addr;
    }

    public void setLabelAddr(Address addr) {
        this.addr = addr;
    }

    public void setLabelName(String name) {
        this.name = name;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }
}

