/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfs;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

public class BootBlkHdr {
    public static final int STRUCTSIZE = 148;
    private final byte[] bbID = new byte[2];
    private final byte[] bbEntry = new byte[4];
    private final byte[] bbVersion = new byte[2];
    private final byte[] bbPageFlags = new byte[2];
    private final byte[] bbSysName = new byte[16];
    private final byte[] bbShellName = new byte[16];
    private final byte[] bbDbg1Name = new byte[16];
    private final byte[] bbDbg2Name = new byte[16];
    private final byte[] bbScreenName = new byte[16];
    private final byte[] bbHelloName = new byte[16];
    private final byte[] bbScrapName = new byte[16];
    private final byte[] bbCntFCBs = new byte[2];
    private final byte[] bbCntEvts = new byte[2];
    private final byte[] bb128KSHeap = new byte[4];
    private final byte[] bb256KSHeap = new byte[4];
    private final byte[] bbSysHeapSize = new byte[4];
    private final byte[] filler = new byte[2];
    private final byte[] bbSysHeapExtra = new byte[4];
    private final byte[] bbSysHeapFract = new byte[4];

    public BootBlkHdr(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.bbID, 0, 2);
        System.arraycopy(data, offset + 2, this.bbEntry, 0, 4);
        System.arraycopy(data, offset + 6, this.bbVersion, 0, 2);
        System.arraycopy(data, offset + 8, this.bbPageFlags, 0, 2);
        System.arraycopy(data, offset + 10, this.bbSysName, 0, 16);
        System.arraycopy(data, offset + 26, this.bbShellName, 0, 16);
        System.arraycopy(data, offset + 42, this.bbDbg1Name, 0, 16);
        System.arraycopy(data, offset + 58, this.bbDbg2Name, 0, 16);
        System.arraycopy(data, offset + 74, this.bbScreenName, 0, 16);
        System.arraycopy(data, offset + 90, this.bbHelloName, 0, 16);
        System.arraycopy(data, offset + 106, this.bbScrapName, 0, 16);
        System.arraycopy(data, offset + 122, this.bbCntFCBs, 0, 2);
        System.arraycopy(data, offset + 124, this.bbCntEvts, 0, 2);
        System.arraycopy(data, offset + 126, this.bb128KSHeap, 0, 4);
        System.arraycopy(data, offset + 130, this.bb256KSHeap, 0, 4);
        System.arraycopy(data, offset + 134, this.bbSysHeapSize, 0, 4);
        System.arraycopy(data, offset + 138, this.filler, 0, 2);
        System.arraycopy(data, offset + 140, this.bbSysHeapExtra, 0, 4);
        System.arraycopy(data, offset + 144, this.bbSysHeapFract, 0, 4);
    }

    public static int length() {
        return 148;
    }

    public short getBbID() {
        return Util.readShortBE((byte[])this.bbID);
    }

    public int getBbEntry() {
        return Util.readIntBE((byte[])this.bbEntry);
    }

    public short getBbVersion() {
        return Util.readShortBE((byte[])this.bbVersion);
    }

    public short getBbPageFlags() {
        return Util.readShortBE((byte[])this.bbPageFlags);
    }

    public byte[] getBbSysName() {
        return Util.readByteArrayBE((byte[])this.bbSysName);
    }

    public byte[] getBbShellName() {
        return Util.readByteArrayBE((byte[])this.bbShellName);
    }

    public byte[] getBbDbg1Name() {
        return Util.readByteArrayBE((byte[])this.bbDbg1Name);
    }

    public byte[] getBbDbg2Name() {
        return Util.readByteArrayBE((byte[])this.bbDbg2Name);
    }

    public byte[] getBbScreenName() {
        return Util.readByteArrayBE((byte[])this.bbScreenName);
    }

    public byte[] getBbHelloName() {
        return Util.readByteArrayBE((byte[])this.bbHelloName);
    }

    public byte[] getBbScrapName() {
        return Util.readByteArrayBE((byte[])this.bbScrapName);
    }

    public short getBbCntFCBs() {
        return Util.readShortBE((byte[])this.bbCntFCBs);
    }

    public short getBbCntEvts() {
        return Util.readShortBE((byte[])this.bbCntEvts);
    }

    public int getBb128KSHeap() {
        return Util.readIntBE((byte[])this.bb128KSHeap);
    }

    public int getBb256KSHeap() {
        return Util.readIntBE((byte[])this.bb256KSHeap);
    }

    public int getBbSysHeapSize() {
        return Util.readIntBE((byte[])this.bbSysHeapSize);
    }

    public short getFiller() {
        return Util.readShortBE((byte[])this.filler);
    }

    public int getBbSysHeapExtra() {
        return Util.readIntBE((byte[])this.bbSysHeapExtra);
    }

    public int getBbSysHeapFract() {
        return Util.readIntBE((byte[])this.bbSysHeapFract);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " bbID: " + this.getBbID());
        ps.println(prefix + " bbEntry: " + this.getBbEntry());
        ps.println(prefix + " bbVersion: " + this.getBbVersion());
        ps.println(prefix + " bbPageFlags: " + this.getBbPageFlags());
        ps.println(prefix + " bbSysName: " + this.getBbSysName());
        ps.println(prefix + " bbShellName: " + this.getBbShellName());
        ps.println(prefix + " bbDbg1Name: " + this.getBbDbg1Name());
        ps.println(prefix + " bbDbg2Name: " + this.getBbDbg2Name());
        ps.println(prefix + " bbScreenName: " + this.getBbScreenName());
        ps.println(prefix + " bbHelloName: " + this.getBbHelloName());
        ps.println(prefix + " bbScrapName: " + this.getBbScrapName());
        ps.println(prefix + " bbCntFCBs: " + this.getBbCntFCBs());
        ps.println(prefix + " bbCntEvts: " + this.getBbCntEvts());
        ps.println(prefix + " bb128KSHeap: " + this.getBb128KSHeap());
        ps.println(prefix + " bb256KSHeap: " + this.getBb256KSHeap());
        ps.println(prefix + " bbSysHeapSize: " + this.getBbSysHeapSize());
        ps.println(prefix + " filler: " + this.getFiller());
        ps.println(prefix + " bbSysHeapExtra: " + this.getBbSysHeapExtra());
        ps.println(prefix + " bbSysHeapFract: " + this.getBbSysHeapFract());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BootBlkHdr:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[148];
        int offset = 0;
        System.arraycopy(this.bbID, 0, result, offset, this.bbID.length);
        System.arraycopy(this.bbEntry, 0, result, offset += this.bbID.length, this.bbEntry.length);
        System.arraycopy(this.bbVersion, 0, result, offset += this.bbEntry.length, this.bbVersion.length);
        System.arraycopy(this.bbPageFlags, 0, result, offset += this.bbVersion.length, this.bbPageFlags.length);
        System.arraycopy(this.bbSysName, 0, result, offset += this.bbPageFlags.length, this.bbSysName.length);
        System.arraycopy(this.bbShellName, 0, result, offset += this.bbSysName.length, this.bbShellName.length);
        System.arraycopy(this.bbDbg1Name, 0, result, offset += this.bbShellName.length, this.bbDbg1Name.length);
        System.arraycopy(this.bbDbg2Name, 0, result, offset += this.bbDbg1Name.length, this.bbDbg2Name.length);
        System.arraycopy(this.bbScreenName, 0, result, offset += this.bbDbg2Name.length, this.bbScreenName.length);
        System.arraycopy(this.bbHelloName, 0, result, offset += this.bbScreenName.length, this.bbHelloName.length);
        System.arraycopy(this.bbScrapName, 0, result, offset += this.bbHelloName.length, this.bbScrapName.length);
        System.arraycopy(this.bbCntFCBs, 0, result, offset += this.bbScrapName.length, this.bbCntFCBs.length);
        System.arraycopy(this.bbCntEvts, 0, result, offset += this.bbCntFCBs.length, this.bbCntEvts.length);
        System.arraycopy(this.bb128KSHeap, 0, result, offset += this.bbCntEvts.length, this.bb128KSHeap.length);
        System.arraycopy(this.bb256KSHeap, 0, result, offset += this.bb128KSHeap.length, this.bb256KSHeap.length);
        System.arraycopy(this.bbSysHeapSize, 0, result, offset += this.bb256KSHeap.length, this.bbSysHeapSize.length);
        System.arraycopy(this.filler, 0, result, offset += this.bbSysHeapSize.length, this.filler.length);
        System.arraycopy(this.bbSysHeapExtra, 0, result, offset += this.filler.length, this.bbSysHeapExtra.length);
        System.arraycopy(this.bbSysHeapFract, 0, result, offset += this.bbSysHeapExtra.length, this.bbSysHeapFract.length);
        offset += this.bbSysHeapFract.length;
        return result;
    }
}

