/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.catacombae.dmgextractor.encodings.encrypted.ReadableCEncryptedEncodingStream;
import org.catacombae.hfsexplorer.IOUtil;
import org.catacombae.hfsexplorer.UDIFRecognizer;
import org.catacombae.hfsexplorer.fs.AppleSingleBuilder;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ReadableStreamDataLocator;
import org.catacombae.jparted.lib.SubDataLocator;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.FSFork;
import org.catacombae.jparted.lib.fs.FSForkType;
import org.catacombae.jparted.lib.fs.FSLink;
import org.catacombae.jparted.lib.fs.FileSystemDetector;
import org.catacombae.jparted.lib.fs.FileSystemHandler;
import org.catacombae.jparted.lib.fs.FileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.FileSystemMajorType;
import org.catacombae.jparted.lib.ps.Partition;
import org.catacombae.jparted.lib.ps.PartitionSystemDetector;
import org.catacombae.jparted.lib.ps.PartitionSystemHandler;
import org.catacombae.jparted.lib.ps.PartitionSystemHandlerFactory;
import org.catacombae.jparted.lib.ps.PartitionSystemType;
import org.catacombae.jparted.lib.ps.PartitionType;
import org.catacombae.udif.UDIFRandomAccessStream;

public class UnHFS {
    private static boolean debug = false;
    private static final int RETVAL_NEED_PASSWORD = 10;
    private static final int RETVAL_INCORRECT_PASSWORD = 11;

    private static void printUsage(PrintStream ps) {
        ps.println("usage: unhfs [options...] <input file>");
        ps.println("  Input file can be in raw, UDIF (.dmg) and/or encrypted format.");
        ps.println("  Options:");
        ps.println("    -o <output dir>");
        ps.println("      The target directory in the local file system where all extracted files");
        ps.println("      should go.");
        ps.println("      When this option is omitted, all files go to the currect working");
        ps.println("      directory.");
        ps.println("    -fsroot <path to extract>");
        ps.println("      A POSIX path in the HFS file system that should be extracted.");
        ps.println("      Example which extracts all the contents of joe's user dir from a backup");
        ps.println("      disk image to the current directory:");
        ps.println("        unhfs -o . -fsroot /Users/joe FullBackup.dmg");
        ps.println("      When this option is omitted, all the contents of the file system is");
        ps.println("      extracted.");
        ps.println("    -create");
        ps.println("      If the -fsroot path refers to a folder, create that folder inside");
        ps.println("      the output directory, rather than extracting into the output directory");
        ps.println("      itself.");
        ps.println("    -resforks NONE|APPLEDOUBLE");
        ps.println("      Determines whether resource forks should be extracted, and in what");
        ps.println("      format. Currently only the APPLEDOUBLE format, which puts each resource");
        ps.println("      fork in its own file with the '._' prefix, is supported.");
        ps.println("      When this option is omitted, no resource forks are extracted.");
        ps.println("    -partition <partition number>");
        ps.println("      If the input file is partitioned, extracts files from the specified HFS");
        ps.println("      partition. Partitions are numbered from 0 and up.");
        ps.println("      When this options is omitted, the application chooses the first");
        ps.println("      available HFS partition.");
        ps.println("    -password <password>");
        ps.println("      Specifies the password for an encrypted image.");
        ps.println("    -v");
        ps.println("      Verbose mode. Prints the POSIX path of every extracted file to stdout.");
        ps.println("    --");
        ps.println("      Signals that there are no more option arguments. Useful for accessing");
        ps.println("      input files with names identical to an option signature.");
    }

    public static void main(String[] args) {
        File outputDir;
        String inputFilename;
        File inputFile;
        int i;
        String outputDirname = ".";
        String fsRoot = "/";
        boolean extractFolderDirectly = true;
        boolean extractResourceForks = false;
        boolean verbose = false;
        int partitionNumber = -1;
        char[] password = null;
        for (i = 0; i < args.length; ++i) {
            String curArg = args[i];
            if (curArg.equals("-o")) {
                if (i + 1 < args.length) {
                    outputDirname = args[++i];
                    continue;
                }
                UnHFS.printUsage(System.err);
                System.exit(1);
                continue;
            }
            if (curArg.equals("-fsroot")) {
                if (i + 1 < args.length) {
                    fsRoot = args[++i];
                    continue;
                }
                UnHFS.printUsage(System.err);
                System.exit(1);
                continue;
            }
            if (curArg.equals("-create")) {
                extractFolderDirectly = false;
                continue;
            }
            if (curArg.equals("-resforks")) {
                if (i + 1 < args.length) {
                    String value;
                    if ((value = args[++i]).equalsIgnoreCase("NONE")) {
                        extractResourceForks = false;
                        continue;
                    }
                    if (value.equalsIgnoreCase("APPLEDOUBLE")) {
                        extractResourceForks = true;
                        continue;
                    }
                    System.err.println("Error: Invalid value \"" + value + "\" for -resforks!");
                    UnHFS.printUsage(System.err);
                    System.exit(1);
                    continue;
                }
                UnHFS.printUsage(System.err);
                System.exit(1);
                continue;
            }
            if (curArg.equals("-partition")) {
                if (i + 1 < args.length) {
                    try {
                        partitionNumber = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Error: Invalid partition number \"" + args[i] + "\"!");
                        UnHFS.printUsage(System.err);
                        System.exit(1);
                    }
                    continue;
                }
                UnHFS.printUsage(System.err);
                System.exit(1);
                continue;
            }
            if (curArg.equals("-password")) {
                if (i + 1 < args.length) {
                    password = args[++i].toCharArray();
                    continue;
                }
                UnHFS.printUsage(System.err);
                System.exit(1);
                continue;
            }
            if (curArg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (!curArg.equals("--")) break;
            ++i;
            break;
        }
        if (i != args.length - 1) {
            UnHFS.printUsage(System.err);
            System.exit(1);
        }
        if (!((inputFile = new File(inputFilename = args[i])).exists() && inputFile.isFile() && inputFile.canRead())) {
            System.err.println("Error: Input file \"" + inputFilename + "\" can not be read!");
            UnHFS.printUsage(System.err);
            System.exit(1);
        }
        if (!(outputDir = new File(outputDirname)).exists() || !outputDir.isDirectory()) {
            System.err.println("Error: Invalid output directory \"" + outputDirname + "\"!");
            UnHFS.printUsage(System.err);
            System.exit(1);
        }
        WindowsLowLevelIO inputStream = WindowsLowLevelIO.isSystemSupported() ? new WindowsLowLevelIO(inputFilename) : new ReadableFileStream(inputFilename);
        try {
            UnHFS.unhfs(System.out, inputStream, outputDir, fsRoot, password, extractFolderDirectly, extractResourceForks, partitionNumber, verbose);
            System.exit(0);
        }
        catch (RuntimeIOException e) {
            System.err.println("Exception while executing main routine:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void unhfs(PrintStream outputStream, ReadableRandomAccessStream inFileStream, File outputDir, String fsRoot, char[] password, boolean extractFolderDirectly, boolean extractResourceForks, int partitionNumber, boolean verbose) throws RuntimeIOException {
        DataLocator inputDataLocator;
        PartitionSystemType[] psTypes;
        ReadableCEncryptedEncodingStream stream;
        UnHFS.logDebug("Trying to detect encrypted structure...");
        if (ReadableCEncryptedEncodingStream.isCEncryptedEncoding((ReadableRandomAccessStream)inFileStream)) {
            if (password != null) {
                try {
                    stream = new ReadableCEncryptedEncodingStream(inFileStream, password);
                    inFileStream = stream;
                }
                catch (Exception e) {
                    System.err.println("Incorrect password for encrypted image.");
                    System.exit(11);
                }
            } else {
                System.err.println("Image is encrypted, and no password was specified.");
                System.exit(10);
            }
        }
        UnHFS.logDebug("Trying to detect UDIF structure...");
        if (UDIFRecognizer.isUDIF(inFileStream)) {
            stream = null;
            try {
                stream = new UDIFRandomAccessStream(inFileStream);
                inFileStream = stream;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Unhandled exception while trying to load UDIF wrapper.");
                System.exit(1);
            }
        }
        if ((psTypes = PartitionSystemDetector.detectPartitionSystem(inputDataLocator = new ReadableStreamDataLocator(inFileStream))).length >= 1) {
            block7: for (PartitionSystemType chosenType : psTypes) {
                Partition[] partitionsToProbe;
                PartitionSystemHandlerFactory fact = chosenType.createDefaultHandlerFactory();
                PartitionSystemHandler psHandler = fact.createHandler(inputDataLocator);
                if (psHandler.getPartitionCount() <= 0L) continue;
                if (partitionNumber >= 0) {
                    if ((long)partitionNumber >= psHandler.getPartitionCount()) break;
                    partitionsToProbe = new Partition[]{psHandler.getPartition(partitionNumber)};
                } else if (partitionNumber == -1) {
                    partitionsToProbe = psHandler.getPartitions();
                } else {
                    System.err.println("Invalid partition number: " + partitionNumber);
                    System.exit(1);
                    return;
                }
                for (Partition p : partitionsToProbe) {
                    if (p.getType() == PartitionType.APPLE_HFS_CONTAINER) {
                        inputDataLocator = new SubDataLocator(inputDataLocator, p.getStartOffset(), p.getLength());
                        break block7;
                    }
                    if (p.getType() != PartitionType.APPLE_HFSX) continue;
                    inputDataLocator = new SubDataLocator(inputDataLocator, p.getStartOffset(), p.getLength());
                    break block7;
                }
            }
        }
        FileSystemMajorType[] fsTypes = FileSystemDetector.detectFileSystem(inputDataLocator);
        FileSystemHandlerFactory fact = null;
        block9: for (FileSystemMajorType type : fsTypes) {
            switch (type) {
                case APPLE_HFS: 
                case APPLE_HFS_PLUS: 
                case APPLE_HFSX: {
                    fact = type.createDefaultHandlerFactory();
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (fact == null) {
            System.err.println("No HFS file system found.");
            System.exit(1);
        }
        FileSystemHandler fsHandler = fact.createHandler(inputDataLocator);
        UnHFS.logDebug("Getting entry by posix path: \"" + fsRoot + "\"");
        FSEntry entry = fsHandler.getEntryByPosixPath(fsRoot, new String[0]);
        if (entry instanceof FSFolder) {
            FSFolder folder = (FSFolder)entry;
            String folderName = folder.getName();
            File dirForFolder = extractFolderDirectly || folderName.equals("/") || folderName.length() == 0 ? outputDir : UnHFS.getFileForFolder(outputDir, folder, verbose);
            if (dirForFolder != null) {
                UnHFS.extractFolder(folder, dirForFolder, extractResourceForks, verbose);
            }
        } else if (entry instanceof FSFile) {
            FSFile file = (FSFile)entry;
            UnHFS.extractFile(file, outputDir, extractResourceForks, verbose);
        } else {
            System.err.println("Requested path is not a folder or a file!");
            System.exit(1);
        }
    }

    private static void extractFolder(FSFolder folder, File targetDir, boolean extractResourceForks, boolean verbose) {
        boolean wasEmpty = targetDir.list().length == 0;
        for (FSEntry e : folder.listEntries()) {
            if (e instanceof FSFile) {
                FSFile file = (FSFile)e;
                UnHFS.extractFile(file, targetDir, extractResourceForks, verbose);
                continue;
            }
            if (e instanceof FSFolder) {
                FSFolder subFolder = (FSFolder)e;
                File subFolderFile = UnHFS.getFileForFolder(targetDir, subFolder, verbose);
                if (subFolderFile == null) continue;
                UnHFS.extractFolder(subFolder, subFolderFile, extractResourceForks, verbose);
                continue;
            }
            if (!(e instanceof FSLink)) continue;
        }
        if (wasEmpty) {
            long lastModified = folder.getAttributes().getModifyDate().getTime();
            targetDir.setLastModified(lastModified);
        }
    }

    private static void extractFile(FSFile file, File targetDir, boolean extractResourceForks, boolean verbose) throws RuntimeIOException {
        FSFork resourceFork;
        long lastModified = file.getAttributes().getModifyDate().getTime();
        File dataFile = new File(targetDir, UnHFS.scrub(file.getName()));
        if (!UnHFS.extractRawForkToFile(file.getMainFork(), dataFile)) {
            System.err.println("Failed to extract data fork to " + dataFile.getPath());
        } else if (verbose) {
            System.out.println(dataFile.getPath());
        }
        dataFile.setLastModified(lastModified);
        if (extractResourceForks && (resourceFork = file.getForkByType(FSForkType.MACOS_RESOURCE)).getLength() > 0L) {
            File resFile = new File(targetDir, "._" + UnHFS.scrub(file.getName()));
            if (!UnHFS.extractResourceForkToAppleDoubleFile(resourceFork, resFile)) {
                System.err.println("Failed to extract resource fork to " + resFile.getPath());
            } else if (verbose) {
                System.out.println(resFile.getPath());
            }
            resFile.setLastModified(lastModified);
        }
    }

    private static File getFileForFolder(File targetDir, FSFolder folder, boolean verbose) {
        File folderFile = new File(targetDir, UnHFS.scrub(folder.getName()));
        if (folderFile.isDirectory() || folderFile.mkdir()) {
            if (verbose) {
                System.out.println(folderFile.getPath());
            }
        } else {
            System.err.println("Failed to create directory " + folderFile.getPath());
            folderFile = null;
        }
        return folderFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractRawForkToFile(FSFork fork, File targetFile) throws RuntimeIOException {
        FileOutputStream os = null;
        ReadableRandomAccessStream in = null;
        try {
            os = new FileOutputStream(targetFile);
            in = fork.getReadableRandomAccessStream();
            long extractedBytes = IOUtil.streamCopy((Readable)in, (OutputStream)os, 131072);
            if (extractedBytes != fork.getLength()) {
                System.err.println("WARNING: Did not extract intended number of bytes to \"" + targetFile.getPath() + "\"! Intended: " + fork.getLength() + " Extracted: " + extractedBytes);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl = false;
            return bl;
        }
        catch (Exception ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractResourceForkToAppleDoubleFile(FSFork resourceFork, File targetFile) {
        FileOutputStream os = null;
        ReadableRandomAccessStream in = null;
        try {
            AppleSingleBuilder builder = new AppleSingleBuilder(AppleSingleBuilder.FileType.APPLEDOUBLE, AppleSingleBuilder.AppleSingleVersion.VERSION_2_0, AppleSingleBuilder.FileSystem.MACOS_X);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            in = resourceFork.getReadableRandomAccessStream();
            long extractedBytes = IOUtil.streamCopy((Readable)in, (OutputStream)baos, 131072);
            if (extractedBytes != resourceFork.getLength()) {
                System.err.println("WARNING: Did not extract intended number of bytes to \"" + targetFile.getPath() + "\"! Intended: " + resourceFork.getLength() + " Extracted: " + extractedBytes);
            }
            builder.addResourceFork(baos.toByteArray());
            os = new FileOutputStream(targetFile);
            os.write(builder.getResult());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl = false;
            return bl;
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static String scrub(String s) {
        char[] cdata = s.toCharArray();
        for (int i = 0; i < cdata.length; ++i) {
            if ((cdata[i] < '\u0000' || cdata[i] > '\u001f') && cdata[i] != '\u007f') continue;
            cdata[i] = 95;
        }
        return new String(cdata);
    }

    private static void logDebug(String s) {
        if (debug) {
            System.err.println("DEBUG: " + s);
        }
    }
}

