/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.program.model.listing.Program;

public class NameVersions {
    public String rawName;
    public String similarName;
    public String demangledBaseName;

    public NameVersions(String raw) {
        this.rawName = raw;
        this.similarName = null;
        this.demangledBaseName = null;
    }

    public static DemangledObject demangle(Program program, String mangledName) {
        DemangledObject demangledObj = null;
        try {
            demangledObj = DemanglerUtil.demangle((Program)program, (String)mangledName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (demangledObj != null) {
            return demangledObj;
        }
        return null;
    }

    public static NameVersions generate(String rawName, Program program) {
        NameVersions result = new NameVersions(rawName);
        if (rawName != null) {
            DemangledObject demangledObj = NameVersions.demangle(program, rawName);
            if (demangledObj != null) {
                result.demangledBaseName = demangledObj.getName().replaceFirst("_*", "");
            }
            result.similarName = rawName.replaceFirst("_*", "");
        }
        return result;
    }
}

