/*
 * Decompiled with CFR 0.152.
 */
package generic.algorithms;

public class CRC64 {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    public void update(byte[] buf, int off, int len) {
        int end = off + len;
        while (off < end) {
            this.crc = crcTable[(buf[off++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    public long finish() {
        long value = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        return value;
    }

    static {
        for (int b = 0; b < crcTable.length; ++b) {
            long r = b;
            for (int i = 0; i < 8; ++i) {
                if ((r & 1L) == 1L) {
                    r = r >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                r >>>= 1;
            }
            CRC64.crcTable[b] = r;
        }
    }
}

