/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.file.formats.yaffs2.YAFFS2Entry;
import ghidra.file.formats.yaffs2.YAFFS2InputStream;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="yaffs2", description="YAFFS2", factory=GFileSystemBaseFactory.class)
public class YAFFS2FileSystem
extends GFileSystemBase {
    private Map<Long, GFileImpl> map = new HashMap<Long, GFileImpl>();
    private Map<GFile, YAFFS2Entry> map2 = new HashMap<GFile, YAFFS2Entry>();

    public YAFFS2FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, 11L);
        return bytes[0] == 3 && bytes[10] == 0;
    }

    public void open(TaskMonitor monitor) throws IOException, CancelledException {
        YAFFS2Entry headerEntry;
        YAFFS2InputStream yaffs2Input = new YAFFS2InputStream((InputStream)new ByteProviderInputStream(this.provider, 0L, this.provider.length()));
        while (!monitor.isCancelled() && (headerEntry = yaffs2Input.getNextHeaderEntry()) != null) {
            this.storeEntry(headerEntry, monitor);
        }
    }

    public void close() throws IOException {
        this.map.clear();
        this.map2.clear();
        super.close();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (Long objId : this.map.keySet()) {
                GFile parentFile = this.map.get(objId).getParentFile();
                if (parentFile == null || parentFile != this.root && !parentFile.equals(this.root)) continue;
                GFile file = (GFile)this.map.get(objId);
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> fileList = new ArrayList<GFile>();
        for (Long objId : this.map.keySet()) {
            GFile parentFile = this.map.get(objId).getParentFile();
            if (parentFile == null || !parentFile.equals(directory)) continue;
            GFile file = (GFile)this.map.get(objId);
            fileList.add(file);
        }
        return fileList;
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        return "YAFFS2, Yet Another Flash File System V2, commonly used for Android System and UserData images.";
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        YAFFS2Entry entry = this.map2.get(file);
        if (entry.isDirectory()) {
            throw new IOException(file.getName() + " is a directory");
        }
        long fileOffset = entry.getFileOffset();
        long size = entry.getSize();
        YAFFS2InputStream YAFFS2Input = new YAFFS2InputStream((InputStream)new ByteProviderInputStream(this.provider, 0L, this.provider.length()));
        InputStream inputStream = YAFFS2Input.getEntryData(fileOffset, size);
        YAFFS2Input.close();
        return inputStream;
    }

    private void storeEntry(YAFFS2Entry entry, TaskMonitor monitor) {
        if (entry == null) {
            return;
        }
        monitor.setMessage(entry.getName());
        long parentObjectId = entry.getParentObjectId();
        long objectId = entry.getObjectId();
        GFileImpl parentFile = parentObjectId == 1L ? this.root : (GFile)this.map.get(parentObjectId);
        if (objectId == 1L & parentObjectId == 1L) {
            return;
        }
        GFileImpl file = GFileImpl.fromFilename((GFileSystem)this, (GFile)parentFile, (String)entry.getName(), (boolean)entry.isDirectory(), (long)entry.getSize(), null);
        this.map.put(entry.getObjectId(), file);
        this.map2.put((GFile)file, entry);
    }
}

