/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class BlockCopy
extends PcodeBlock {
    private Object ref;
    private Address address;
    private int altindex;

    public BlockCopy() {
        this.blocktype = 3;
        this.address = Address.NO_ADDRESS;
        this.ref = null;
    }

    public BlockCopy(Object r, Address addr) {
        this.ref = r;
        this.blocktype = 3;
        this.address = addr;
    }

    @Override
    public Address getStart() {
        return this.address;
    }

    @Override
    public Address getStop() {
        return this.address;
    }

    public Object getRef() {
        return this.ref;
    }

    protected void set(Object r, Address addr) {
        this.ref = r;
        this.address = addr;
    }

    public int getAltIndex() {
        return this.altindex;
    }

    @Override
    public void saveXmlHeader(StringBuilder buf) {
        super.saveXmlHeader(buf);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"altindex", (long)this.altindex);
    }

    @Override
    public void restoreXmlHeader(XmlElement el) throws PcodeXMLException {
        super.restoreXmlHeader(el);
        this.altindex = SpecXmlUtils.decodeInt((String)el.getAttribute("altindex"));
    }
}

