/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.featurette;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingTool;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.framework.options.SaveState;
import ghidra.graph.VisualGraph;
import ghidra.graph.VisualGraphComponentProvider;
import ghidra.graph.featurette.VisualGraphFeaturette;
import ghidra.graph.viewer.GraphSatelliteListener;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.actions.VgSatelliteContext;
import ghidra.graph.viewer.actions.VisualGraphActionContext;
import ghidra.util.HelpLocation;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.ResourceManager;

public class VgSatelliteFeaturette<V extends VisualVertex, E extends VisualEdge<V>, G extends VisualGraph<V, E>>
implements VisualGraphFeaturette<V, E, G> {
    private static final Icon ICON = ResourceManager.loadImage((String)"images/network-wireless-16.png");
    private static final String DISPLAY_SATELLITE = "DISPLAY_SATELLITE";
    private static final String DOCK_SATELLITE = "DOCK_SATELLITE";
    private ToggleDockingAction toggleSatelliteAction;
    private ToggleDockingAction dockSatelliteAction;
    private DockingTool tool;
    private VisualGraphView<?, ?, ?> view;
    private String owner;
    private String providerName;
    private String windowGroup;
    private boolean closedByPrimaryProvider;
    private VgUndockedSatelliteProvider satelliteProvider;

    @Override
    public void writeConfigState(SaveState saveState) {
        saveState.putBoolean(DOCK_SATELLITE, this.dockSatelliteAction.isSelected());
        saveState.putBoolean(DISPLAY_SATELLITE, this.toggleSatelliteAction.isSelected());
    }

    @Override
    public void readConfigState(SaveState saveState) {
        boolean dockSatellite = saveState.getBoolean(DOCK_SATELLITE, true);
        this.dockSatelliteAction.setSelected(dockSatellite);
        this.view.setSatelliteDocked(dockSatellite);
        boolean showSatellite = saveState.getBoolean(DISPLAY_SATELLITE, true);
        this.toggleSatelliteAction.setSelected(showSatellite);
        this.view.setSatelliteVisible(showSatellite);
    }

    @Override
    public void init(VisualGraphComponentProvider<V, E, G> provider) {
        this.tool = provider.getTool();
        this.view = provider.getView();
        this.owner = provider.getOwner();
        this.providerName = provider.getName();
        this.windowGroup = provider.getWindowGroup();
        this.view.setSatelliteListener(new SatelliteListener());
        this.addActions(provider);
    }

    @Override
    public void providerOpened(VisualGraphComponentProvider<V, E, G> provider) {
        if (this.satelliteProvider != null) {
            this.satelliteProvider.setVisible(true);
            this.view.setSatelliteVisible(true);
        }
    }

    @Override
    public void providerClosed(VisualGraphComponentProvider<V, E, G> provider) {
        if (this.satelliteProvider != null) {
            this.closedByPrimaryProvider = true;
            this.satelliteProvider.closeComponent();
            this.closedByPrimaryProvider = false;
        }
    }

    public ComponentProvider getSatelliteProvider() {
        return this.satelliteProvider;
    }

    private void addActions(final ComponentProvider provider) {
        this.toggleSatelliteAction = new ToggleDockingAction("Display Satellite View", this.owner){

            public void actionPerformed(ActionContext context) {
                VgSatelliteFeaturette.this.view.setSatelliteVisible(this.isSelected());
            }

            public boolean isAddToPopup(ActionContext context) {
                ComponentProvider componentProvider = context.getComponentProvider();
                if (componentProvider != provider && componentProvider != VgSatelliteFeaturette.this.satelliteProvider) {
                    return false;
                }
                if (!(context instanceof VisualGraphActionContext)) {
                    return false;
                }
                VisualGraphActionContext vgContext = (VisualGraphActionContext)context;
                return vgContext.shouldShowSatelliteActions();
            }
        };
        this.toggleSatelliteAction.setSelected(true);
        this.toggleSatelliteAction.setPopupMenuData(new MenuData(new String[]{"Display Satellite View"}));
        this.toggleSatelliteAction.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Satellite_View"));
        this.dockSatelliteAction = new ToggleDockingAction("Dock Satellite View", this.owner){

            public void actionPerformed(ActionContext context) {
                VgSatelliteFeaturette.this.view.setSatelliteDocked(this.isSelected());
            }

            public boolean isAddToPopup(ActionContext context) {
                ComponentProvider componentProvider = context.getComponentProvider();
                if (componentProvider != provider && componentProvider != VgSatelliteFeaturette.this.satelliteProvider) {
                    return false;
                }
                if (!(context instanceof VisualGraphActionContext)) {
                    return false;
                }
                VisualGraphActionContext vgContext = (VisualGraphActionContext)context;
                return vgContext.shouldShowSatelliteActions();
            }
        };
        this.dockSatelliteAction.setSelected(true);
        this.dockSatelliteAction.setPopupMenuData(new MenuData(new String[]{"Dock Satellite View"}));
        this.dockSatelliteAction.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Satellite_View"));
        this.tool.addAction((DockingActionIf)this.toggleSatelliteAction);
        this.tool.addAction((DockingActionIf)this.dockSatelliteAction);
    }

    @Override
    public void remove() {
        if (this.satelliteProvider != null) {
            this.satelliteProvider.removeFromTool();
        }
    }

    private void closeSatelliteProvider(boolean remove) {
        if (this.satelliteProvider == null) {
            return;
        }
        if (remove) {
            this.satelliteProvider.removeFromTool();
            this.satelliteProvider = null;
        } else {
            this.satelliteProvider.closeComponent();
        }
    }

    private void showSatelliteProvider() {
        if (this.satelliteProvider == null) {
            JComponent component = this.view.getUndockedSatelliteComponent();
            this.satelliteProvider = new VgUndockedSatelliteProvider(this.tool, component, this.providerName + " Satellite", this.owner, this.windowGroup);
            this.satelliteProvider.setVisible(true);
        } else {
            this.satelliteProvider.toFront();
        }
    }

    private class SatelliteListener
    implements GraphSatelliteListener {
        private SatelliteListener() {
        }

        @Override
        public void satelliteVisibilityChanged(boolean docked, boolean visible) {
            VgSatelliteFeaturette.this.toggleSatelliteAction.setSelected(visible);
            VgSatelliteFeaturette.this.dockSatelliteAction.setSelected(docked);
            if (docked) {
                VgSatelliteFeaturette.this.closeSatelliteProvider(true);
                return;
            }
            if (!visible) {
                VgSatelliteFeaturette.this.closeSatelliteProvider(false);
            } else {
                VgSatelliteFeaturette.this.showSatelliteProvider();
            }
        }
    }

    private class VgUndockedSatelliteProvider
    extends ComponentProvider {
        private JComponent satelliteComponent;

        public VgUndockedSatelliteProvider(DockingTool tool, JComponent component, String name, String owner, String windowGroup) {
            super(tool, name, owner);
            this.satelliteComponent = component;
            this.satelliteComponent.setMinimumSize(new Dimension(400, 400));
            this.setWindowMenuGroup(windowGroup);
            this.setIcon(ICON);
            this.setDefaultWindowPosition(WindowPosition.WINDOW);
            this.addToTool();
        }

        public JComponent getComponent() {
            return this.satelliteComponent;
        }

        public ActionContext getActionContext(MouseEvent event) {
            return new VgSatelliteContext(this);
        }

        public void componentHidden() {
            if (!VgSatelliteFeaturette.this.dockSatelliteAction.isSelected()) {
                VgSatelliteFeaturette.this.view.setSatelliteVisible(false);
            }
            if (!VgSatelliteFeaturette.this.closedByPrimaryProvider) {
                VgSatelliteFeaturette.this.satelliteProvider.removeFromTool();
                VgSatelliteFeaturette.this.satelliteProvider = null;
            }
        }
    }
}

