/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.HashMap;

public enum AccessFlags {
    PUBLIC(1, "public", true, true, true),
    PRIVATE(2, "private", true, true, true),
    PROTECTED(4, "protected", true, true, true),
    STATIC(8, "static", true, true, true),
    FINAL(16, "final", true, true, true),
    SYNCHRONIZED(32, "synchronized", false, true, false),
    VOLATILE(64, "volatile", false, false, true),
    BRIDGE(64, "bridge", false, true, false),
    TRANSIENT(128, "transient", false, false, true),
    VARARGS(128, "varargs", false, true, false),
    NATIVE(256, "native", false, true, false),
    INTERFACE(512, "interface", true, false, false),
    ABSTRACT(1024, "abstract", true, true, false),
    STRICTFP(2048, "strictfp", false, true, false),
    SYNTHETIC(4096, "synthetic", true, true, true),
    ANNOTATION(8192, "annotation", true, false, false),
    ENUM(16384, "enum", true, false, true),
    CONSTRUCTOR(65536, "constructor", false, true, false),
    DECLARED_SYNCHRONIZED(131072, "declared-synchronized", false, true, false);

    private int value;
    private String accessFlagName;
    private boolean validForClass;
    private boolean validForMethod;
    private boolean validForField;
    private static final AccessFlags[] allFlags;
    private static HashMap<String, AccessFlags> accessFlagsByName;

    private AccessFlags(int value, String accessFlagName, boolean validForClass, boolean validForMethod, boolean validForField) {
        this.value = value;
        this.accessFlagName = accessFlagName;
        this.validForClass = validForClass;
        this.validForMethod = validForMethod;
        this.validForField = validForField;
    }

    public static AccessFlags[] getAccessFlagsForClass(int accessFlagValue) {
        int size = 0;
        for (AccessFlags accessFlag : allFlags) {
            if (!accessFlag.validForClass || (accessFlagValue & accessFlag.value) == 0) continue;
            ++size;
        }
        AccessFlags[] accessFlags = new AccessFlags[size];
        int accessFlagsPosition = 0;
        for (AccessFlags accessFlag : allFlags) {
            if (!accessFlag.validForClass || (accessFlagValue & accessFlag.value) == 0) continue;
            accessFlags[accessFlagsPosition++] = accessFlag;
        }
        return accessFlags;
    }

    private static String formatAccessFlags(AccessFlags[] accessFlags) {
        int size = 0;
        for (AccessFlags accessFlag : accessFlags) {
            size += accessFlag.toString().length() + 1;
        }
        StringBuilder sb = new StringBuilder(size);
        for (AccessFlags accessFlag : accessFlags) {
            sb.append(accessFlag.toString());
            sb.append(" ");
        }
        if (accessFlags.length > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static String formatAccessFlagsForClass(int accessFlagValue) {
        return AccessFlags.formatAccessFlags(AccessFlags.getAccessFlagsForClass(accessFlagValue));
    }

    public static AccessFlags[] getAccessFlagsForMethod(int accessFlagValue) {
        int size = 0;
        for (AccessFlags accessFlag : allFlags) {
            if (!accessFlag.validForMethod || (accessFlagValue & accessFlag.value) == 0) continue;
            ++size;
        }
        AccessFlags[] accessFlags = new AccessFlags[size];
        int accessFlagsPosition = 0;
        for (AccessFlags accessFlag : allFlags) {
            if (!accessFlag.validForMethod || (accessFlagValue & accessFlag.value) == 0) continue;
            accessFlags[accessFlagsPosition++] = accessFlag;
        }
        return accessFlags;
    }

    public static String formatAccessFlagsForMethod(int accessFlagValue) {
        return AccessFlags.formatAccessFlags(AccessFlags.getAccessFlagsForMethod(accessFlagValue));
    }

    public static AccessFlags[] getAccessFlagsForField(int accessFlagValue) {
        int size = 0;
        for (AccessFlags accessFlag : allFlags) {
            if (!accessFlag.validForField || (accessFlagValue & accessFlag.value) == 0) continue;
            ++size;
        }
        AccessFlags[] accessFlags = new AccessFlags[size];
        int accessFlagsPosition = 0;
        for (AccessFlags accessFlag : allFlags) {
            if (!accessFlag.validForField || (accessFlagValue & accessFlag.value) == 0) continue;
            accessFlags[accessFlagsPosition++] = accessFlag;
        }
        return accessFlags;
    }

    public static String formatAccessFlagsForField(int accessFlagValue) {
        return AccessFlags.formatAccessFlags(AccessFlags.getAccessFlagsForField(accessFlagValue));
    }

    public static AccessFlags getAccessFlag(String accessFlag) {
        return accessFlagsByName.get(accessFlag);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.accessFlagName;
    }

    static {
        allFlags = AccessFlags.values();
        accessFlagsByName = new HashMap();
        for (AccessFlags accessFlag : allFlags) {
            accessFlagsByName.put(accessFlag.accessFlagName, accessFlag);
        }
    }
}

