/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class PrefixFeatureGenerator
implements AdaptiveFeatureGenerator {
    static final int DEFAULT_MAX_LENGTH = 4;
    private final int prefixLength;

    public PrefixFeatureGenerator() {
        this.prefixLength = 4;
    }

    public PrefixFeatureGenerator(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String[] prefs;
        for (String pref : prefs = this.getPrefixes(tokens[index])) {
            features.add("pre=" + pref);
        }
    }

    private String[] getPrefixes(String lex) {
        int prefixes = Math.min(this.prefixLength, lex.length());
        String[] prefs = new String[prefixes];
        for (int li = 0; li < prefixes; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }
}

