/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.rrd;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.metrics.rrd.SolrRrdBackend;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRrdBackendFactory
extends RrdBackendFactory
implements SolrCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_SYNC_PERIOD = 60;
    public static final int DEFAULT_MAX_DBS = 500;
    public static final String NAME = "SOLR";
    public static final String URI_PREFIX = "solr:";
    public static final String ID_SEP = "|";
    public static final String ID_PREFIX = "rrd";
    public static final String DOC_TYPE = "metrics_rrd";
    public static final String DATA_FIELD = "data_bin";
    private final SolrClient solrClient;
    private final TimeSource timeSource;
    private final String collection;
    private final int syncPeriod;
    private final int idPrefixLength;
    private ScheduledThreadPoolExecutor syncService;
    private volatile boolean closed = false;
    private volatile boolean persistent = true;
    private final Map<String, SolrRrdBackend> backends = new ConcurrentHashMap<String, SolrRrdBackend>();

    public SolrRrdBackendFactory(SolrClient solrClient, String collection, int syncPeriod, TimeSource timeSource) {
        this.solrClient = solrClient;
        this.timeSource = timeSource;
        this.collection = collection;
        this.syncPeriod = syncPeriod;
        if (log.isDebugEnabled()) {
            log.debug("Created {}", (Object)((Object)((Object)this)).hashCode());
        }
        this.idPrefixLength = ID_PREFIX.length() + ID_SEP.length();
        this.syncService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(2, (ThreadFactory)new SolrNamedThreadFactory("SolrRrdBackendFactory"));
        this.syncService.setRemoveOnCancelPolicy(true);
        this.syncService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.syncService.scheduleWithFixedDelay(() -> this.maybeSyncBackends(), timeSource.convertDelay(TimeUnit.SECONDS, (long)syncPeriod, TimeUnit.MILLISECONDS), timeSource.convertDelay(TimeUnit.SECONDS, (long)syncPeriod, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Factory already closed");
        }
    }

    public boolean canStore(URI uri) {
        if (uri == null) {
            return false;
        }
        return uri.getScheme().toUpperCase(Locale.ROOT).equals(this.getName());
    }

    public String getPath(URI uri) {
        return uri.getSchemeSpecificPart();
    }

    public URI getUri(String path) {
        if (!path.startsWith(URI_PREFIX)) {
            path = URI_PREFIX + path;
        }
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
    }

    public URI getCanonicalUri(URI uri) {
        return uri;
    }

    protected synchronized RrdBackend open(String path, boolean readOnly) throws IOException {
        this.ensureOpen();
        SolrRrdBackend backend = this.backends.computeIfAbsent(path, p -> new SolrRrdBackend((String)p, readOnly, this));
        if (backend.isReadOnly()) {
            if (readOnly) {
                return backend;
            }
            backend = new SolrRrdBackend(path, readOnly, this);
            this.backends.put(path, backend);
            return backend;
        }
        if (readOnly) {
            return new SolrRrdBackend(backend);
        }
        return backend;
    }

    SolrRrdBackend.SyncData getData(String path) throws IOException {
        if (!this.persistent) {
            return null;
        }
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("q", new String[]{"{!term f=id}rrd|" + path});
            params.add("fq", new String[]{"type:metrics_rrd"});
            QueryResponse rsp = this.solrClient.query(this.collection, (SolrParams)params);
            SolrDocumentList docs = rsp.getResults();
            if (docs == null || docs.isEmpty()) {
                return null;
            }
            if (docs.size() > 1) {
                throw new SolrServerException("Expected at most 1 doc with id '" + path + "' but got " + docs);
            }
            SolrDocument doc = (SolrDocument)docs.get(0);
            Object o = doc.getFieldValue(DATA_FIELD);
            if (o == null) {
                return null;
            }
            if (o instanceof byte[]) {
                Object timeObj = doc.getFieldValue("timestamp_l");
                Long time = timeObj instanceof Number ? ((Number)timeObj).longValue() : Long.parseLong(String.valueOf(timeObj));
                return new SolrRrdBackend.SyncData((byte[])o, time);
            }
            throw new SolrServerException("Unexpected value of 'data_bin' field: " + o.getClass().getName() + ": " + o);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    void unregisterBackend(String path) {
        this.backends.remove(path);
    }

    public List<Pair<String, Long>> list(int maxLength) throws IOException {
        HashMap byName = new HashMap();
        if (this.persistent) {
            try {
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.add("q", new String[]{"*:*"});
                params.add("fq", new String[]{"type:metrics_rrd"});
                params.add("fl", new String[]{"id,timestamp_l"});
                params.add("rows", new String[]{String.valueOf(maxLength)});
                QueryResponse rsp = this.solrClient.query(this.collection, (SolrParams)params);
                SolrDocumentList docs = rsp.getResults();
                if (docs != null) {
                    docs.forEach(d -> {
                        Object o = d.getFieldValue("timestamp_l");
                        if (o == null) {
                            return;
                        }
                        Long time = o instanceof Number ? ((Number)o).longValue() : Long.parseLong(String.valueOf(o));
                        Pair p = new Pair((Object)((String)d.getFieldValue("id")).substring(this.idPrefixLength), (Object)time);
                        byName.put(p.first(), p);
                    });
                }
            }
            catch (SolrServerException e) {
                log.warn("Error retrieving RRD list", (Throwable)e);
            }
        }
        this.backends.forEach((name, db) -> {
            long lastModifiedTime = db.getLastModifiedTime();
            Pair stored = (Pair)byName.get(name);
            Pair inMemory = new Pair(name, (Object)lastModifiedTime);
            if (stored != null) {
                if ((Long)stored.second() < lastModifiedTime) {
                    byName.put(name, inMemory);
                }
            } else {
                byName.put(name, inMemory);
            }
        });
        ArrayList<Pair<String, Long>> list = new ArrayList<Pair<String, Long>>(byName.values());
        Collections.sort(list, DbComparator.INSTANCE);
        return list;
    }

    public void removeAll() throws IOException {
        Iterator<SolrRrdBackend> it = this.backends.values().iterator();
        while (it.hasNext()) {
            SolrRrdBackend backend = it.next();
            it.remove();
            IOUtils.closeQuietly((Closeable)backend);
        }
        if (!this.persistent) {
            return;
        }
        try {
            this.solrClient.deleteByQuery(this.collection, "{!term f=type}:metrics_rrd", this.syncPeriod * 1000);
        }
        catch (SolrServerException e) {
            log.warn("Error deleting RRDs", (Throwable)e);
        }
    }

    public void remove(String path) throws IOException {
        SolrRrdBackend backend = this.backends.remove(path);
        if (backend != null) {
            IOUtils.closeQuietly((Closeable)backend);
        }
        if (!this.persistent) {
            return;
        }
        try {
            this.solrClient.deleteByQuery(this.collection, "{!term f=id}rrd|" + path);
        }
        catch (SolrServerException | SolrException e) {
            log.warn("Error deleting RRD for path {}", (Object)path, (Object)e);
        }
    }

    synchronized void maybeSyncBackends() {
        if (this.closed) {
            return;
        }
        if (!this.persistent) {
            return;
        }
        if (Thread.interrupted()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("-- maybe sync backends: {}", this.backends.keySet());
        }
        HashMap<String, SolrRrdBackend.SyncData> syncDatas = new HashMap<String, SolrRrdBackend.SyncData>();
        this.backends.forEach((path, backend) -> {
            SolrRrdBackend.SyncData syncData = backend.getSyncDataAndMarkClean();
            if (syncData != null) {
                syncDatas.put(backend.getPath(), syncData);
            }
        });
        if (syncDatas.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("-- syncing {}", syncDatas.keySet());
        }
        try {
            syncDatas.forEach((path, syncData) -> {
                SolrInputDocument doc = new SolrInputDocument(new String[0]);
                doc.setField("id", (Object)("rrd|" + path));
                doc.addField("type", (Object)DOC_TYPE);
                doc.addField(DATA_FIELD, (Object)syncData.data);
                doc.setField("timestamp_l", (Object)syncData.timestamp);
                try {
                    this.solrClient.add(this.collection, doc);
                }
                catch (IOException | SolrServerException e) {
                    log.warn("Error updating RRD data for {}", path, (Object)e);
                }
            });
            if (Thread.interrupted()) {
                return;
            }
            try {
                this.solrClient.commit(this.collection);
            }
            catch (SolrServerException e) {
                log.warn("Error committing RRD data updates", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.warn("Error sending RRD data updates", (Throwable)e);
        }
    }

    public boolean exists(String path) throws IOException {
        if (this.backends.containsKey(path)) {
            return true;
        }
        if (!this.persistent) {
            return false;
        }
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("q", new String[]{"{!term f=id}rrd|" + path});
            params.add("fq", new String[]{"type:metrics_rrd"});
            params.add("fl", new String[]{"id"});
            QueryResponse rsp = this.solrClient.query(this.collection, (SolrParams)params);
            SolrDocumentList docs = rsp.getResults();
            if (docs == null || docs.isEmpty()) {
                return false;
            }
            if (docs.size() > 1) {
                throw new SolrServerException("Expected at most 1 doc with id '" + path + "' but got " + docs);
            }
            return true;
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    protected boolean shouldValidateHeader(String path) throws IOException {
        return false;
    }

    public String getName() {
        return NAME;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Closing {}", (Object)((Object)((Object)this)).hashCode());
        }
        this.closed = true;
        this.backends.values().forEach(IOUtils::closeQuietly);
        this.backends.clear();
        ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.syncService);
        this.syncService = null;
    }

    private static final class DbComparator
    implements Comparator<Pair<String, Long>> {
        static final DbComparator INSTANCE = new DbComparator();

        private DbComparator() {
        }

        @Override
        public int compare(Pair<String, Long> o1, Pair<String, Long> o2) {
            return ((String)o1.first()).compareTo((String)o2.first());
        }
    }
}

