/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.FieldReaderDataSource;
import org.apache.solr.handler.dataimport.Transformer;

public class ClobTransformer
extends Transformer {
    public static final String CLOB = "clob";

    @Override
    public Object transformRow(Map<String, Object> aRow, Context context) {
        for (Map<String, String> map : context.getAllEntityFields()) {
            Object o;
            if (!"true".equals(map.get(CLOB))) continue;
            String column = map.get("column");
            String srcCol = map.get("sourceColName");
            if (srcCol == null) {
                srcCol = column;
            }
            if ((o = aRow.get(srcCol)) instanceof List) {
                List inputs = (List)o;
                ArrayList<String> results = new ArrayList<String>();
                for (Object input : inputs) {
                    if (!(input instanceof Clob)) continue;
                    Clob clob = (Clob)input;
                    results.add(this.readFromClob(clob));
                }
                aRow.put(column, results);
                continue;
            }
            if (!(o instanceof Clob)) continue;
            Clob clob = (Clob)o;
            aRow.put(column, this.readFromClob(clob));
        }
        return aRow;
    }

    private String readFromClob(Clob clob) {
        Reader reader = FieldReaderDataSource.readCharStream(clob);
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        try {
            int len;
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        catch (IOException e) {
            DataImportHandlerException.wrapAndThrow(500, e);
        }
        return sb.toString();
    }
}

