/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class DefaultToolingModelBuilderRegistry
implements ToolingModelBuilderRegistry,
ToolingModelBuilderLookup {
    private final ToolingModelBuilderLookup parent;
    private final List<ToolingModelBuilder> builders = new ArrayList<ToolingModelBuilder>();
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry) {
        this(buildOperationExecutor, projectStateRegistry, null);
        this.register(new VoidToolingModelBuilder());
    }

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry, ToolingModelBuilderLookup parent) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectStateRegistry = projectStateRegistry;
        this.parent = parent;
    }

    public void register(ToolingModelBuilder builder) {
        this.builders.add(builder);
    }

    public ToolingModelBuilder getBuilder(String modelName) throws UnsupportedOperationException {
        ToolingModelBuilder builder = this.get(modelName);
        return new LenientToolingModelBuilder(builder);
    }

    @Override
    public ToolingModelBuilder locateForClientOperation(String modelName) throws UnknownModelException {
        ToolingModelBuilder builder = this.get(modelName);
        if (builder instanceof ParameterizedToolingModelBuilder) {
            return new ParameterizedBuildOperationWrappingToolingModelBuilder((ParameterizedToolingModelBuilder)Cast.uncheckedNonnullCast((Object)builder));
        }
        return new BuildOperationWrappingToolingModelBuilder(builder);
    }

    @Override
    @Nullable
    public ToolingModelBuilder find(String modelName) {
        ToolingModelBuilder match = null;
        for (ToolingModelBuilder builder : this.builders) {
            if (!builder.canBuild(modelName)) continue;
            if (match != null) {
                throw new UnsupportedOperationException(String.format("Multiple builders are available to build a model of type '%s'.", modelName));
            }
            match = builder;
        }
        if (match != null) {
            return match;
        }
        if (this.parent != null) {
            return this.parent.find(modelName);
        }
        return null;
    }

    private ToolingModelBuilder get(String modelName) {
        ToolingModelBuilder builder = this.find(modelName);
        if (builder != null) {
            return builder;
        }
        throw new UnknownModelException(String.format("No builders are available to build a model of type '%s'.", modelName));
    }

    private static class VoidToolingModelBuilder
    implements ToolingModelBuilder {
        private VoidToolingModelBuilder() {
        }

        public boolean canBuild(String modelName) {
            return modelName.equals(Void.class.getName());
        }

        public Object buildAll(String modelName, Project project) {
            return null;
        }
    }

    private class ParameterizedBuildOperationWrappingToolingModelBuilder<T>
    extends BuildOperationWrappingToolingModelBuilder
    implements ParameterizedToolingModelBuilder<T> {
        private final ParameterizedToolingModelBuilder<T> delegate;

        private ParameterizedBuildOperationWrappingToolingModelBuilder(ParameterizedToolingModelBuilder<T> delegate) {
            super((ToolingModelBuilder)delegate);
            this.delegate = delegate;
        }

        @Override
        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        public Object buildAll(final String modelName, final T parameter, final Project project) {
            return DefaultToolingModelBuilderRegistry.this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Object>(){

                public Object call(BuildOperationContext context) {
                    return DefaultToolingModelBuilderRegistry.this.projectStateRegistry.withMutableStateOfAllProjects(new Factory<Object>(){

                        @Nullable
                        public Object create() {
                            return ParameterizedBuildOperationWrappingToolingModelBuilder.this.delegate.buildAll(modelName, parameter, project);
                        }
                    });
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Build parameterized model '" + modelName + "' for " + project.getDisplayName())).progressDisplayName("Building parameterized model '" + modelName + "'");
                }
            });
        }

        public Class<T> getParameterType() {
            return this.delegate.getParameterType();
        }
    }

    private class BuildOperationWrappingToolingModelBuilder
    implements ToolingModelBuilder {
        private final ToolingModelBuilder delegate;

        private BuildOperationWrappingToolingModelBuilder(ToolingModelBuilder delegate) {
            this.delegate = delegate;
        }

        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        public Object buildAll(final String modelName, final Project project) {
            return DefaultToolingModelBuilderRegistry.this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Object>(){

                public Object call(BuildOperationContext context) {
                    return DefaultToolingModelBuilderRegistry.this.projectStateRegistry.withMutableStateOfAllProjects(new Factory<Object>(){

                        @Nullable
                        public Object create() {
                            return BuildOperationWrappingToolingModelBuilder.this.delegate.buildAll(modelName, project);
                        }
                    });
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Build model '" + modelName + "' for " + project.getDisplayName())).progressDisplayName("Building model '" + modelName + "'");
                }
            });
        }
    }

    private class LenientToolingModelBuilder
    implements ToolingModelBuilder {
        private final ToolingModelBuilder delegate;

        public LenientToolingModelBuilder(ToolingModelBuilder delegate) {
            this.delegate = delegate;
        }

        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        public Object buildAll(final String modelName, final Project project) {
            return DefaultToolingModelBuilderRegistry.this.projectStateRegistry.allowUncontrolledAccessToAnyProject(new Factory<Object>(){

                public Object create() {
                    return LenientToolingModelBuilder.this.delegate.buildAll(modelName, project);
                }
            });
        }
    }
}

