/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.jdk7.WatchPointsRegistry;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatchServiceRegistrar
implements FileWatcherListener {
    private static final Logger LOG = LoggerFactory.getLogger(WatchServiceRegistrar.class);
    private static final boolean FILE_TREE_WATCHING_SUPPORTED = OperatingSystem.current().isWindows() && !JavaVersion.current().isJava9Compatible();
    private static final WatchEvent.Modifier[] WATCH_MODIFIERS = WatchServiceRegistrar.instantiateWatchModifiers();
    private static final WatchEvent.Kind[] WATCH_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final WatchService watchService;
    private final FileWatcherListener delegate;
    private final Lock lock = new ReentrantLock(true);
    private final WatchPointsRegistry watchPointsRegistry;
    private final HashMap<Path, WatchKey> watchKeys = new HashMap();

    WatchServiceRegistrar(WatchService watchService, FileWatcherListener delegate) {
        this.watchService = watchService;
        this.delegate = delegate;
        this.watchPointsRegistry = new WatchPointsRegistry(!FILE_TREE_WATCHING_SUPPORTED);
    }

    private static WatchEvent.Modifier[] instantiateWatchModifiers() {
        if (JavaVersion.current().isJava9Compatible()) {
            return new WatchEvent.Modifier[0];
        }
        WatchEvent.Modifier highSensitive = WatchServiceRegistrar.instantiateEnum("com.sun.nio.file.SensitivityWatchEventModifier", "HIGH");
        if (FILE_TREE_WATCHING_SUPPORTED) {
            WatchEvent.Modifier fileTree = WatchServiceRegistrar.instantiateEnum("com.sun.nio.file.ExtendedWatchEventModifier", "FILE_TREE");
            return new WatchEvent.Modifier[]{fileTree, highSensitive};
        }
        return new WatchEvent.Modifier[]{highSensitive};
    }

    private static WatchEvent.Modifier instantiateEnum(String className, String enumName) {
        try {
            return (WatchEvent.Modifier)Enum.valueOf((Class)Cast.uncheckedNonnullCast(Class.forName(className)), enumName);
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void watch(FileSystemSubset fileSystemSubset) throws IOException {
        this.lock.lock();
        try {
            LOG.debug("Begin - adding watches for {}", (Object)fileSystemSubset);
            final WatchPointsRegistry.Delta delta = this.watchPointsRegistry.appendFileSystemSubset(fileSystemSubset, this.getCurrentWatchPoints());
            Iterable<? extends File> startingWatchPoints = delta.getStartingWatchPoints();
            for (File file : startingWatchPoints) {
                LOG.debug("Begin - handling starting point {}", (Object)file);
                final Path dirPath = file.toPath();
                this.watchDir(dirPath);
                if (!FILE_TREE_WATCHING_SUPPORTED) {
                    Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                            if (!path.equals(dirPath)) {
                                if (delta.shouldWatch(path.toFile())) {
                                    WatchServiceRegistrar.this.watchDir(path);
                                    return FileVisitResult.CONTINUE;
                                }
                                LOG.debug("Skipping watching for {}, filtered by WatchPointsRegistry", (Object)path);
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LOG.debug("End - handling starting point {}", (Object)file);
            }
            LOG.debug("End - adding watches for {}", (Object)fileSystemSubset);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Iterable<File> getCurrentWatchPoints() {
        LinkedList<File> currentWatchPoints = new LinkedList<File>();
        for (Map.Entry<Path, WatchKey> entry : this.watchKeys.entrySet()) {
            if (!entry.getValue().isValid()) continue;
            currentWatchPoints.add(entry.getKey().toFile());
        }
        return currentWatchPoints;
    }

    protected void watchDir(Path dir) throws IOException {
        LOG.debug("Registering watch for {}", (Object)dir);
        if (Thread.currentThread().isInterrupted()) {
            LOG.debug("Skipping adding watch since current thread is interrupted.");
        }
        Path path = dir;
        while (path != null) {
            WatchKey previousWatchKey = this.watchKeys.get(path);
            if (previousWatchKey != null && previousWatchKey.isValid()) {
                LOG.debug("Directory {} is already watched and the watch is valid, not adding another one.", (Object)path);
                return;
            }
            path = FILE_TREE_WATCHING_SUPPORTED ? path.getParent() : null;
        }
        int retryCount = 0;
        IOException lastException = null;
        while (retryCount++ < 2) {
            try {
                WatchKey watchKey = dir.register(this.watchService, WATCH_KINDS, WATCH_MODIFIERS);
                this.watchKeys.put(dir, watchKey);
                return;
            }
            catch (IOException e) {
                LOG.debug("Exception in registering for watching of " + dir, (Throwable)e);
                lastException = e;
                if (e instanceof NoSuchFileException) {
                    LOG.debug("Return silently since directory doesn't exist.");
                    return;
                }
                if (e instanceof FileSystemException && e.getMessage() != null && e.getMessage().contains("Bad file descriptor")) {
                    LOG.debug("Retrying after 'Bad file descriptor'");
                    continue;
                }
                if (!Files.exists(dir, new LinkOption[0])) {
                    LOG.debug("Return silently since directory doesn't exist.");
                    return;
                }
                throw e;
            }
        }
        LOG.debug("Retry count exceeded, throwing last exception");
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange(FileWatcher watcher, FileWatcherEvent event) {
        block7: {
            this.lock.lock();
            try {
                if (event.getType().equals((Object)FileWatcherEvent.Type.UNDEFINED) || event.getFile() == null) {
                    LOG.debug("Calling onChange with event {}", (Object)event);
                    this.deliverEventToDelegate(watcher, event);
                    return;
                }
                File file = event.getFile();
                this.maybeFire(watcher, event);
                if (!event.getType().equals((Object)FileWatcherEvent.Type.CREATE) || !file.isDirectory()) break block7;
                try {
                    this.maybeWatchNewDirectory(watcher, file);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void deliverEventToDelegate(FileWatcher watcher, FileWatcherEvent event) {
        if (!Thread.currentThread().isInterrupted()) {
            try {
                this.delegate.onChange(watcher, event);
            }
            catch (RuntimeException e) {
                if (Throwables.getRootCause((Throwable)e) instanceof InterruptedException) {
                    return;
                }
                throw e;
            }
        } else {
            LOG.debug("Skipping event delivery since current thread is interrupted.");
        }
    }

    private void maybeFire(FileWatcher watcher, FileWatcherEvent event) {
        if (this.watchPointsRegistry.shouldFire(event.getFile())) {
            LOG.debug("Calling onChange with event {}", (Object)event);
            this.deliverEventToDelegate(watcher, event);
        } else {
            LOG.debug("Ignoring event {}", (Object)event);
        }
    }

    private void maybeWatchNewDirectory(FileWatcher watcher, File dir) throws IOException {
        LOG.debug("Begin - maybeWatchNewDirectory {}", (Object)dir);
        if (this.isStopRequested(watcher)) {
            LOG.debug("Stop requested, returning.");
            return;
        }
        if (!this.watchPointsRegistry.shouldWatch(dir)) {
            LOG.debug("Ignoring watching {}", (Object)dir);
            return;
        }
        if (dir.exists()) {
            File[] contents;
            if (!FILE_TREE_WATCHING_SUPPORTED) {
                this.watchDir(dir.toPath());
            }
            if ((contents = dir.listFiles()) != null) {
                for (File file : contents) {
                    if (this.isStopRequested(watcher)) {
                        LOG.debug("Stop requested, returning.");
                        return;
                    }
                    this.maybeFire(watcher, FileWatcherEvent.create(file));
                    if (!file.isDirectory()) continue;
                    this.maybeWatchNewDirectory(watcher, file);
                }
            }
        }
        LOG.debug("End - maybeWatchNewDirectory {}", (Object)dir);
    }

    private boolean isStopRequested(FileWatcher watcher) {
        return Thread.currentThread().isInterrupted() || !watcher.isRunning();
    }
}

