/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.jakartaee.bcel.Const;
import org.apache.tomcat.jakartaee.bcel.classfile.AnnotationDefault;
import org.apache.tomcat.jakartaee.bcel.classfile.AttributeReader;
import org.apache.tomcat.jakartaee.bcel.classfile.BootstrapMethods;
import org.apache.tomcat.jakartaee.bcel.classfile.Code;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantValue;
import org.apache.tomcat.jakartaee.bcel.classfile.Deprecated;
import org.apache.tomcat.jakartaee.bcel.classfile.EnclosingMethod;
import org.apache.tomcat.jakartaee.bcel.classfile.ExceptionTable;
import org.apache.tomcat.jakartaee.bcel.classfile.InnerClasses;
import org.apache.tomcat.jakartaee.bcel.classfile.LineNumberTable;
import org.apache.tomcat.jakartaee.bcel.classfile.LocalVariableTable;
import org.apache.tomcat.jakartaee.bcel.classfile.LocalVariableTypeTable;
import org.apache.tomcat.jakartaee.bcel.classfile.MethodParameters;
import org.apache.tomcat.jakartaee.bcel.classfile.Module;
import org.apache.tomcat.jakartaee.bcel.classfile.ModuleMainClass;
import org.apache.tomcat.jakartaee.bcel.classfile.ModulePackages;
import org.apache.tomcat.jakartaee.bcel.classfile.NestHost;
import org.apache.tomcat.jakartaee.bcel.classfile.NestMembers;
import org.apache.tomcat.jakartaee.bcel.classfile.Node;
import org.apache.tomcat.jakartaee.bcel.classfile.PMGClass;
import org.apache.tomcat.jakartaee.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.tomcat.jakartaee.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.tomcat.jakartaee.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.tomcat.jakartaee.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.tomcat.jakartaee.bcel.classfile.Signature;
import org.apache.tomcat.jakartaee.bcel.classfile.SourceFile;
import org.apache.tomcat.jakartaee.bcel.classfile.StackMap;
import org.apache.tomcat.jakartaee.bcel.classfile.Synthetic;
import org.apache.tomcat.jakartaee.bcel.classfile.Unknown;
import org.apache.tomcat.jakartaee.bcel.classfile.UnknownAttributeReader;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public abstract class Attribute
implements Cloneable,
Node {
    private static final boolean debug = Boolean.getBoolean(Attribute.class.getCanonicalName() + ".debug");
    private static final Map<String, Object> READERS = new HashMap<String, Object>();
    public static final Attribute[] EMPTY_ARRAY = new Attribute[0];
    @java.lang.Deprecated
    protected int name_index;
    @java.lang.Deprecated
    protected int length;
    @java.lang.Deprecated
    protected byte tag;
    @java.lang.Deprecated
    protected ConstantPool constant_pool;

    @java.lang.Deprecated
    public static void addAttributeReader(String name, AttributeReader attributeReader) {
        READERS.put(name, attributeReader);
    }

    public static void addAttributeReader(String name, UnknownAttributeReader unknownAttributeReader) {
        READERS.put(name, unknownAttributeReader);
    }

    protected static void println(String msg) {
        if (debug) {
            System.err.println(msg);
        }
    }

    public static Attribute readAttribute(DataInput file, ConstantPool constant_pool) throws IOException {
        int tag = -1;
        int name_index = file.readUnsignedShort();
        String name = constant_pool.getConstantUtf8(name_index).getBytes();
        int length = file.readInt();
        for (int i = 0; i < 27; i = (int)((byte)(i + 1))) {
            if (!name.equals(Const.getAttributeName(i))) continue;
            tag = i;
            break;
        }
        switch (tag) {
            case -1: {
                Object r = READERS.get(name);
                if (r instanceof UnknownAttributeReader) {
                    return ((UnknownAttributeReader)r).createAttribute(name_index, length, file, constant_pool);
                }
                return new Unknown(name_index, length, file, constant_pool);
            }
            case 1: {
                return new ConstantValue(name_index, length, file, constant_pool);
            }
            case 0: {
                return new SourceFile(name_index, length, file, constant_pool);
            }
            case 2: {
                return new Code(name_index, length, file, constant_pool);
            }
            case 3: {
                return new ExceptionTable(name_index, length, file, constant_pool);
            }
            case 4: {
                return new LineNumberTable(name_index, length, file, constant_pool);
            }
            case 5: {
                return new LocalVariableTable(name_index, length, file, constant_pool);
            }
            case 6: {
                return new InnerClasses(name_index, length, file, constant_pool);
            }
            case 7: {
                return new Synthetic(name_index, length, file, constant_pool);
            }
            case 8: {
                return new Deprecated(name_index, length, file, constant_pool);
            }
            case 9: {
                return new PMGClass(name_index, length, file, constant_pool);
            }
            case 10: {
                return new Signature(name_index, length, file, constant_pool);
            }
            case 11: {
                Attribute.println("Warning: Obsolete StackMap attribute ignored.");
                return new Unknown(name_index, length, file, constant_pool);
            }
            case 12: {
                return new RuntimeVisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 13: {
                return new RuntimeInvisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 14: {
                return new RuntimeVisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 15: {
                return new RuntimeInvisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 16: {
                return new AnnotationDefault(name_index, length, file, constant_pool);
            }
            case 17: {
                return new LocalVariableTypeTable(name_index, length, file, constant_pool);
            }
            case 18: {
                return new EnclosingMethod(name_index, length, file, constant_pool);
            }
            case 19: {
                return new StackMap(name_index, length, file, constant_pool);
            }
            case 20: {
                return new BootstrapMethods(name_index, length, file, constant_pool);
            }
            case 21: {
                return new MethodParameters(name_index, length, file, constant_pool);
            }
            case 22: {
                return new Module(name_index, length, file, constant_pool);
            }
            case 23: {
                return new ModulePackages(name_index, length, file, constant_pool);
            }
            case 24: {
                return new ModuleMainClass(name_index, length, file, constant_pool);
            }
            case 25: {
                return new NestHost(name_index, length, file, constant_pool);
            }
            case 26: {
                return new NestMembers(name_index, length, file, constant_pool);
            }
        }
        throw new IllegalStateException("Unrecognized attribute type tag parsed: " + tag);
    }

    public static Attribute readAttribute(DataInputStream file, ConstantPool constant_pool) throws IOException {
        return Attribute.readAttribute((DataInput)file, constant_pool);
    }

    public static void removeAttributeReader(String name) {
        READERS.remove(name);
    }

    protected Attribute(byte tag, int name_index, int length, ConstantPool constant_pool) {
        this.tag = tag;
        this.name_index = name_index;
        this.length = length;
        this.constant_pool = constant_pool;
    }

    @Override
    public abstract void accept(Visitor var1);

    public Object clone() {
        Attribute attr = null;
        try {
            attr = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
        return attr;
    }

    public abstract Attribute copy(ConstantPool var1);

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.name_index);
        file.writeInt(this.length);
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final int getLength() {
        return this.length;
    }

    public String getName() {
        return this.constant_pool.getConstantUtf8(this.name_index).getBytes();
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public final void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public String toString() {
        return Const.getAttributeName(this.tag);
    }
}

