/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.util.S3ProxyUtil;
import com.amazon.aes.webservices.client.vmconversion.Importer;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.S3Object;
import java.io.File;
import java.net.URL;

public abstract class Uploadable
extends BaseCmd {
    public static final int DEFAULT_PART_SIZE = 10;
    public static final long ONE_MB = 0x100000L;
    public static final String DEFAULT_USER_THREADS = "20";
    public static final String USER_THREADS = "user-threads";
    public static final String USER_THREADS_ARG = "THREADS";
    public static final String[] USER_THREADS_DESC = new String[]{"Maximum number of threads to concurrently upload the file with. Defaults to ", "20 threads. [OPTIONAL]"};
    public static final int DEFAULT_EXPIRATION = 7;
    public static final String EXPIRES_ARG = "DAYS";
    public static final String[] EXPIRES_DESC = new String[]{"Validity period for the signed S3 URLS that allow EC2 to access your file.", "Defaults to 7 days. [OPTIONAL]"};
    protected String s3AccessId;
    protected String s3SecretKey;
    protected File imageFile;
    protected URL manifestUrl;
    protected String userThreads;
    protected int partSize = 10;
    protected int expires;
    protected boolean verifyFormat;
    protected boolean dryRun;
    protected AmazonS3Client s3Client;
    protected ConversionTaskDescription task;

    public Uploadable(String short_form, String long_form) {
        super(short_form, long_form);
    }

    public Uploadable(String short_form, String[] long_form) {
        super(short_form, long_form);
    }

    protected void validateAndSetupS3Access() throws GeneralError {
        this.assertOptionSet("owner-akid");
        this.s3AccessId = this.getOptionValue("owner-akid");
        this.assertOptionSet("owner-sak");
        this.s3SecretKey = this.getOptionValue("owner-sak");
        System.setProperty("max-thread-count", this.userThreads);
        String region = this.extractRegionFromUrl(this.getURL());
        ClientConfiguration clientConfig = new ClientConfiguration();
        S3ProxyUtil.populateS3ProxyProperties(clientConfig, this.getURL(), this.isOptionSet("verbose"));
        if (SIGV2_REGIONS.contains(region)) {
            this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(this.s3AccessId, this.s3SecretKey), clientConfig);
            if ("us-gov-west-1".equals(region)) {
                this.s3Client.setRegion(Region.getRegion((Regions)Regions.GovCloud));
            }
        } else {
            clientConfig = clientConfig.withSignerOverride("AWSS3V4SignerType");
            String endpoint = this.getURL().replaceFirst("ec2", "s3");
            this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(this.s3AccessId, this.s3SecretKey), clientConfig);
            this.s3Client.setEndpoint(endpoint, "s3", region);
        }
    }

    protected void validateParameters() throws GeneralError, VerificationException {
        this.verifyFormat = !this.isOptionSet("dont-verify-format");
        this.dryRun = this.isOptionSet("dry-run");
        this.userThreads = this.isOptionSet(USER_THREADS) ? this.getOptionValue(USER_THREADS) : DEFAULT_USER_THREADS;
        this.validateAndSetupS3Access();
        this.expires = this.isOptionSet("expires") ? Integer.parseInt(this.getOptionValue("expires")) : 7;
        try {
            String imageFilename = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
            this.imageFile = new File(imageFilename);
            if (!this.imageFile.exists()) {
                throw new VerificationException("File " + this.imageFile + " does not exist");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new VerificationException("Required argument 'disk-image' missing (-h for usage).");
        }
    }

    protected boolean uploadDisk(ImportVolumeConversionTask importTask, Jec2 jec2, String taskId) throws Exception {
        try {
            this.manifestUrl = new URL(importTask.getImportManifestUrl());
            int volumeSize = importTask.getVolumeSize();
            Long part = (long)this.partSize * 0x100000L;
            String format = importTask.getDiskImageFormat();
            ManifestFactory mf = new ManifestFactory((AmazonS3)this.s3Client);
            Manifest manifest = mf.createManifestUnlessExists(this.manifestUrl, this.imageFile, format, (long)volumeSize, part.longValue(), this.expires, this.dryRun);
            if (this.dryRun) {
                return true;
            }
            if (manifest == null) {
                System.err.println("Unexpected error, could not create manifest. ");
                return false;
            }
            String bucketName = ManifestFactory.getBucketName((S3Object)ManifestFactory.getManifestS3Object((URL)this.manifestUrl));
            Importer importer = new Importer(manifest, (AmazonS3)this.s3Client, bucketName, this.imageFile);
            importer.startOrResumeImport(jec2, taskId);
            System.out.print("The disk image for " + this.task.getTaskId() + " has been uploaded to Amazon S3\n" + "where it is being converted into an ");
            if (this.task.getTaskType().equals("ImportVolume")) {
                System.out.print("EBS volume");
            } else {
                System.out.print("EC2 instance");
            }
            System.out.print(".  You may monitor the\nprogress of this task by running ec2-describe-conversion-tasks.  When\nthe task is completed, you may use ec2-delete-disk-image to remove the\nimage from S3.\n");
            return true;
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    protected ImportVolumeConversionTask retrieveImportVolumeConversionTask(ConversionTaskDescription task) throws GeneralError {
        ImportVolumeConversionTask importTask = null;
        String tasktype = task.getTaskType();
        if (tasktype.equals("ImportVolume")) {
            importTask = task.getImportVolumeConversionTask();
        } else if (tasktype.equals("ImportInstance")) {
            importTask = (ImportVolumeConversionTask)task.getImportInstanceConversionTask().getVolumes().get(0);
        } else {
            throw new GeneralError("The task ID " + task + " is not a known task type.");
        }
        if (importTask == null) {
            throw new GeneralError("The task ID " + task + " has no details for uploading disk image");
        }
        return importTask;
    }
}

