/*
 * This declarations of the PIC16LF1454 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:04 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1454_H__
#define __PIC16LF1454_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define LATA_ADDR               0x010C
#define LATC_ADDR               0x010E
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define APFCON_ADDR             0x011D
#define ANSELA_ADDR             0x018C
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define VREGCON_ADDR            0x0197
#define RCREG_ADDR              0x0199
#define TXREG_ADDR              0x019A
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SPBRGH_ADDR             0x019C
#define RCSTA_ADDR              0x019D
#define TXSTA_ADDR              0x019E
#define BAUDCON_ADDR            0x019F
#define WPUA_ADDR               0x020C
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define CLKRCON_ADDR            0x039A
#define ACTCON_ADDR             0x039B
#define PWM1DCL_ADDR            0x0611
#define PWM1DCH_ADDR            0x0612
#define PWM1CON_ADDR            0x0613
#define PWM1CON0_ADDR           0x0613
#define PWM2DCL_ADDR            0x0614
#define PWM2DCH_ADDR            0x0615
#define PWM2CON_ADDR            0x0616
#define PWM2CON0_ADDR           0x0616
#define UCON_ADDR               0x0E8E
#define USTAT_ADDR              0x0E8F
#define UIR_ADDR                0x0E90
#define UCFG_ADDR               0x0E91
#define UIE_ADDR                0x0E92
#define UEIR_ADDR               0x0E93
#define UFRM_ADDR               0x0E94
#define UFRMH_ADDR              0x0E94
#define UFRML_ADDR              0x0E95
#define UADDR_ADDR              0x0E96
#define UEIE_ADDR               0x0E97
#define UEP0_ADDR               0x0E98
#define UEP1_ADDR               0x0E99
#define UEP2_ADDR               0x0E9A
#define UEP3_ADDR               0x0E9B
#define UEP4_ADDR               0x0E9C
#define UEP5_ADDR               0x0E9D
#define UEP6_ADDR               0x0E9E
#define UEP7_ADDR               0x0E9F
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned                      : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC                 : 6;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned                      : 1;
  unsigned SSP1IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned                      : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned ACTIF                : 1;
  unsigned USBIF                : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _ACTIF                  0x02
#define _USBIF                  0x04
#define _BCL1IF                 0x08
#define _OSFIF                  0x80

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISC              : 6;
    unsigned                    : 2;
    };
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned                      : 1;
  unsigned SSP1IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned                      : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned ACTIE                : 1;
  unsigned USBIE                : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _ACTIE                  0x02
#define _USBIE                  0x04
#define _BCL1IE                 0x08
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned TUN6               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 7;
    unsigned                    : 1;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _TUN6                   0x40

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLMULT           : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned IRCF               : 4;
    unsigned                    : 2;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x04
#define _IRCF1                  0x08
#define _IRCF2                  0x10
#define _IRCF3                  0x20
#define _SPLLMULT               0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLRDY               : 1;
  unsigned SOSCR                : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLRDY                 0x40
#define _SOSCR                  0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef union
  {
  struct
    {
    unsigned LATC0              : 1;
    unsigned LATC1              : 1;
    unsigned LATC2              : 1;
    unsigned LATC3              : 1;
    unsigned LATC4              : 1;
    unsigned LATC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATC               : 6;
    unsigned                    : 2;
    };
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned FVRRDY               : 1;
  unsigned FVREN                : 1;
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2SEL                : 1;
  unsigned T1GSEL               : 1;
  unsigned                      : 1;
  unsigned SSSEL                : 1;
  unsigned SDOSEL               : 1;
  unsigned CLKRSEL              : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _P2SEL                  0x04
#define _T1GSEL                 0x08
#define _SSSEL                  0x20
#define _SDOSEL                 0x40
#define _CLKRSEL                0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA4                  0x20

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef union
  {
  struct
    {
    unsigned ANSC0              : 1;
    unsigned ANSC1              : 1;
    unsigned ANSC2              : 1;
    unsigned ANSC3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSC               : 4;
    unsigned                    : 4;
    };
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef union
  {
  struct
    {
    unsigned VREGPM0            : 1;
    unsigned VREGPM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned VREGPM             : 2;
    unsigned                    : 6;
    };
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _VREGPM0                0x01
#define _VREGPM1                0x02

//==============================================================================

extern __at(0x0199) __sfr RCREG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SPBRGH;

//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUA3                : 1;
  unsigned WPUA4                : 1;
  unsigned WPUA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================

extern __at(0x0211) __sfr SSP1BUF;
extern __at(0x0211) __sfr SSPBUF;
extern __at(0x0212) __sfr SSP1ADD;
extern __at(0x0212) __sfr SSPADD;
extern __at(0x0213) __sfr SSP1MSK;
extern __at(0x0213) __sfr SSPMSK;

//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSP1M0             : 1;
    unsigned SSP1M1             : 1;
    unsigned SSP1M2             : 1;
    unsigned SSP1M3             : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1EN             : 1;
    unsigned SSP1OV             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1M              : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1M0                 0x01
#define _SSP1M1                 0x02
#define _SSP1M2                 0x04
#define _SSP1M3                 0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSP1EN                 0x20
#define _SSPOV                  0x40
#define _SSP1OV                 0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSP1M0             : 1;
    unsigned SSP1M1             : 1;
    unsigned SSP1M2             : 1;
    unsigned SSP1M3             : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1EN             : 1;
    unsigned SSP1OV             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1M              : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSP1M0          0x01
#define _SSPCON_SSP1M1          0x02
#define _SSPCON_SSP1M2          0x04
#define _SSPCON_SSP1M3          0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSP1EN          0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_SSP1OV          0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSP1M0             : 1;
    unsigned SSP1M1             : 1;
    unsigned SSP1M2             : 1;
    unsigned SSP1M3             : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1EN             : 1;
    unsigned SSP1OV             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1M              : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSP1M0         0x01
#define _SSPCON1_SSP1M1         0x02
#define _SSPCON1_SSP1M2         0x04
#define _SSPCON1_SSP1M3         0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSP1EN         0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_SSP1OV         0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef struct
  {
  unsigned IOCAP0               : 1;
  unsigned IOCAP1               : 1;
  unsigned                      : 1;
  unsigned IOCAP3               : 1;
  unsigned IOCAP4               : 1;
  unsigned IOCAP5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef struct
  {
  unsigned IOCAN0               : 1;
  unsigned IOCAN1               : 1;
  unsigned                      : 1;
  unsigned IOCAN3               : 1;
  unsigned IOCAN4               : 1;
  unsigned IOCAN5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef struct
  {
  unsigned IOCAF0               : 1;
  unsigned IOCAF1               : 1;
  unsigned                      : 1;
  unsigned IOCAF3               : 1;
  unsigned IOCAF4               : 1;
  unsigned IOCAF5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        CLKRCON Bits

extern __at(0x039A) __sfr CLKRCON;

typedef union
  {
  struct
    {
    unsigned CLKRDIV0           : 1;
    unsigned CLKRDIV1           : 1;
    unsigned CLKRDIV2           : 1;
    unsigned CLKRCD0            : 1;
    unsigned CLKRCD1            : 1;
    unsigned CLKRSLR            : 1;
    unsigned CLKROE             : 1;
    unsigned CLKREN             : 1;
    };

  struct
    {
    unsigned CLKRDIV            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CLKRCD             : 2;
    unsigned                    : 3;
    };
  } __CLKRCONbits_t;

extern __at(0x039A) volatile __CLKRCONbits_t CLKRCONbits;

#define _CLKRDIV0               0x01
#define _CLKRDIV1               0x02
#define _CLKRDIV2               0x04
#define _CLKRCD0                0x08
#define _CLKRCD1                0x10
#define _CLKRSLR                0x20
#define _CLKROE                 0x40
#define _CLKREN                 0x80

//==============================================================================


//==============================================================================
//        ACTCON Bits

extern __at(0x039B) __sfr ACTCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned ACTORS               : 1;
  unsigned                      : 1;
  unsigned ACTLOCK              : 1;
  unsigned ACTSRC               : 1;
  unsigned                      : 1;
  unsigned ACTUD                : 1;
  unsigned ACTEN                : 1;
  } __ACTCONbits_t;

extern __at(0x039B) volatile __ACTCONbits_t ACTCONbits;

#define _ACTORS                 0x02
#define _ACTLOCK                0x08
#define _ACTSRC                 0x10
#define _ACTUD                  0x40
#define _ACTEN                  0x80

//==============================================================================


//==============================================================================
//        PWM1DCL Bits

extern __at(0x0611) __sfr PWM1DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1DCL0           : 1;
    unsigned PWM1DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM1DCL            : 2;
    };
  } __PWM1DCLbits_t;

extern __at(0x0611) volatile __PWM1DCLbits_t PWM1DCLbits;

#define _PWM1DCL0               0x40
#define _PWM1DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM1DCH Bits

extern __at(0x0612) __sfr PWM1DCH;

typedef struct
  {
  unsigned PWM1DCH0             : 1;
  unsigned PWM1DCH1             : 1;
  unsigned PWM1DCH2             : 1;
  unsigned PWM1DCH3             : 1;
  unsigned PWM1DCH4             : 1;
  unsigned PWM1DCH5             : 1;
  unsigned PWM1DCH6             : 1;
  unsigned PWM1DCH7             : 1;
  } __PWM1DCHbits_t;

extern __at(0x0612) volatile __PWM1DCHbits_t PWM1DCHbits;

#define _PWM1DCH0               0x01
#define _PWM1DCH1               0x02
#define _PWM1DCH2               0x04
#define _PWM1DCH3               0x08
#define _PWM1DCH4               0x10
#define _PWM1DCH5               0x20
#define _PWM1DCH6               0x40
#define _PWM1DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0613) __sfr PWM1CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CONbits_t;

extern __at(0x0613) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1POL                0x10
#define _PWM1OUT                0x20
#define _PWM1OE                 0x40
#define _PWM1EN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON0 Bits

extern __at(0x0613) __sfr PWM1CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CON0bits_t;

extern __at(0x0613) volatile __PWM1CON0bits_t PWM1CON0bits;

#define _PWM1CON0_PWM1POL       0x10
#define _PWM1CON0_PWM1OUT       0x20
#define _PWM1CON0_PWM1OE        0x40
#define _PWM1CON0_PWM1EN        0x80

//==============================================================================


//==============================================================================
//        PWM2DCL Bits

extern __at(0x0614) __sfr PWM2DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2DCL0           : 1;
    unsigned PWM2DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM2DCL            : 2;
    };
  } __PWM2DCLbits_t;

extern __at(0x0614) volatile __PWM2DCLbits_t PWM2DCLbits;

#define _PWM2DCL0               0x40
#define _PWM2DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM2DCH Bits

extern __at(0x0615) __sfr PWM2DCH;

typedef struct
  {
  unsigned PWM2DCH0             : 1;
  unsigned PWM2DCH1             : 1;
  unsigned PWM2DCH2             : 1;
  unsigned PWM2DCH3             : 1;
  unsigned PWM2DCH4             : 1;
  unsigned PWM2DCH5             : 1;
  unsigned PWM2DCH6             : 1;
  unsigned PWM2DCH7             : 1;
  } __PWM2DCHbits_t;

extern __at(0x0615) volatile __PWM2DCHbits_t PWM2DCHbits;

#define _PWM2DCH0               0x01
#define _PWM2DCH1               0x02
#define _PWM2DCH2               0x04
#define _PWM2DCH3               0x08
#define _PWM2DCH4               0x10
#define _PWM2DCH5               0x20
#define _PWM2DCH6               0x40
#define _PWM2DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0616) __sfr PWM2CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CONbits_t;

extern __at(0x0616) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2POL                0x10
#define _PWM2OUT                0x20
#define _PWM2OE                 0x40
#define _PWM2EN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON0 Bits

extern __at(0x0616) __sfr PWM2CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CON0bits_t;

extern __at(0x0616) volatile __PWM2CON0bits_t PWM2CON0bits;

#define _PWM2CON0_PWM2POL       0x10
#define _PWM2CON0_PWM2OUT       0x20
#define _PWM2CON0_PWM2OE        0x40
#define _PWM2CON0_PWM2EN        0x80

//==============================================================================


//==============================================================================
//        UCON Bits

extern __at(0x0E8E) __sfr UCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned SUSPND               : 1;
  unsigned RESUME               : 1;
  unsigned USBEN                : 1;
  unsigned PKTDIS               : 1;
  unsigned SE0                  : 1;
  unsigned PPBRST               : 1;
  unsigned                      : 1;
  } __UCONbits_t;

extern __at(0x0E8E) volatile __UCONbits_t UCONbits;

#define _SUSPND                 0x02
#define _RESUME                 0x04
#define _USBEN                  0x08
#define _PKTDIS                 0x10
#define _SE0                    0x20
#define _PPBRST                 0x40

//==============================================================================


//==============================================================================
//        USTAT Bits

extern __at(0x0E8F) __sfr USTAT;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned PPBI               : 1;
    unsigned DIR                : 1;
    unsigned ENDP0              : 1;
    unsigned ENDP1              : 1;
    unsigned ENDP2              : 1;
    unsigned ENDP3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ENDP               : 4;
    unsigned                    : 1;
    };
  } __USTATbits_t;

extern __at(0x0E8F) volatile __USTATbits_t USTATbits;

#define _PPBI                   0x02
#define _DIR                    0x04
#define _ENDP0                  0x08
#define _ENDP1                  0x10
#define _ENDP2                  0x20
#define _ENDP3                  0x40

//==============================================================================


//==============================================================================
//        UIR Bits

extern __at(0x0E90) __sfr UIR;

typedef struct
  {
  unsigned URSTIF               : 1;
  unsigned UERRIF               : 1;
  unsigned ACTVIF               : 1;
  unsigned TRNIF                : 1;
  unsigned IDLEIF               : 1;
  unsigned STALLIF              : 1;
  unsigned SOFIF                : 1;
  unsigned                      : 1;
  } __UIRbits_t;

extern __at(0x0E90) volatile __UIRbits_t UIRbits;

#define _URSTIF                 0x01
#define _UERRIF                 0x02
#define _ACTVIF                 0x04
#define _TRNIF                  0x08
#define _IDLEIF                 0x10
#define _STALLIF                0x20
#define _SOFIF                  0x40

//==============================================================================


//==============================================================================
//        UCFG Bits

extern __at(0x0E91) __sfr UCFG;

typedef union
  {
  struct
    {
    unsigned PPB0               : 1;
    unsigned PPB1               : 1;
    unsigned FSEN               : 1;
    unsigned                    : 1;
    unsigned UPUEN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned UTEYE              : 1;
    };

  struct
    {
    unsigned PPB                : 2;
    unsigned                    : 6;
    };
  } __UCFGbits_t;

extern __at(0x0E91) volatile __UCFGbits_t UCFGbits;

#define _PPB0                   0x01
#define _PPB1                   0x02
#define _FSEN                   0x04
#define _UPUEN                  0x10
#define _UTEYE                  0x80

//==============================================================================


//==============================================================================
//        UIE Bits

extern __at(0x0E92) __sfr UIE;

typedef struct
  {
  unsigned URSTIE               : 1;
  unsigned UERRIE               : 1;
  unsigned ACTVIE               : 1;
  unsigned TRNIE                : 1;
  unsigned IDLEIE               : 1;
  unsigned STALLIE              : 1;
  unsigned SOFIE                : 1;
  unsigned                      : 1;
  } __UIEbits_t;

extern __at(0x0E92) volatile __UIEbits_t UIEbits;

#define _URSTIE                 0x01
#define _UERRIE                 0x02
#define _ACTVIE                 0x04
#define _TRNIE                  0x08
#define _IDLEIE                 0x10
#define _STALLIE                0x20
#define _SOFIE                  0x40

//==============================================================================


//==============================================================================
//        UEIR Bits

extern __at(0x0E93) __sfr UEIR;

typedef struct
  {
  unsigned PIDEF                : 1;
  unsigned CRC5EF               : 1;
  unsigned CRC16EF              : 1;
  unsigned DFN8EF               : 1;
  unsigned BTOEF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEF                : 1;
  } __UEIRbits_t;

extern __at(0x0E93) volatile __UEIRbits_t UEIRbits;

#define _PIDEF                  0x01
#define _CRC5EF                 0x02
#define _CRC16EF                0x04
#define _DFN8EF                 0x08
#define _BTOEF                  0x10
#define _BTSEF                  0x80

//==============================================================================

extern __at(0x0E94) __sfr UFRM;

//==============================================================================
//        UFRMH Bits

extern __at(0x0E94) __sfr UFRMH;

typedef struct
  {
  unsigned FRM8                 : 1;
  unsigned FRM9                 : 1;
  unsigned FRM10                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UFRMHbits_t;

extern __at(0x0E94) volatile __UFRMHbits_t UFRMHbits;

#define _FRM8                   0x01
#define _FRM9                   0x02
#define _FRM10                  0x04

//==============================================================================


//==============================================================================
//        UFRML Bits

extern __at(0x0E95) __sfr UFRML;

typedef struct
  {
  unsigned FRM0                 : 1;
  unsigned FRM1                 : 1;
  unsigned FRM2                 : 1;
  unsigned FRM3                 : 1;
  unsigned FRM4                 : 1;
  unsigned FRM5                 : 1;
  unsigned FRM6                 : 1;
  unsigned FRM7                 : 1;
  } __UFRMLbits_t;

extern __at(0x0E95) volatile __UFRMLbits_t UFRMLbits;

#define _FRM0                   0x01
#define _FRM1                   0x02
#define _FRM2                   0x04
#define _FRM3                   0x08
#define _FRM4                   0x10
#define _FRM5                   0x20
#define _FRM6                   0x40
#define _FRM7                   0x80

//==============================================================================


//==============================================================================
//        UADDR Bits

extern __at(0x0E96) __sfr UADDR;

typedef union
  {
  struct
    {
    unsigned ADDR0              : 1;
    unsigned ADDR1              : 1;
    unsigned ADDR2              : 1;
    unsigned ADDR3              : 1;
    unsigned ADDR4              : 1;
    unsigned ADDR5              : 1;
    unsigned ADDR6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDR               : 7;
    unsigned                    : 1;
    };
  } __UADDRbits_t;

extern __at(0x0E96) volatile __UADDRbits_t UADDRbits;

#define _ADDR0                  0x01
#define _ADDR1                  0x02
#define _ADDR2                  0x04
#define _ADDR3                  0x08
#define _ADDR4                  0x10
#define _ADDR5                  0x20
#define _ADDR6                  0x40

//==============================================================================


//==============================================================================
//        UEIE Bits

extern __at(0x0E97) __sfr UEIE;

typedef struct
  {
  unsigned PIDEE                : 1;
  unsigned CRC5EE               : 1;
  unsigned CRC16EE              : 1;
  unsigned DFN8EE               : 1;
  unsigned BTOEE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEE                : 1;
  } __UEIEbits_t;

extern __at(0x0E97) volatile __UEIEbits_t UEIEbits;

#define _PIDEE                  0x01
#define _CRC5EE                 0x02
#define _CRC16EE                0x04
#define _DFN8EE                 0x08
#define _BTOEE                  0x10
#define _BTSEE                  0x80

//==============================================================================


//==============================================================================
//        UEP0 Bits

extern __at(0x0E98) __sfr UEP0;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP0bits_t;

extern __at(0x0E98) volatile __UEP0bits_t UEP0bits;

#define _EPSTALL                0x01
#define _EPINEN                 0x02
#define _EPOUTEN                0x04
#define _EPCONDIS               0x08
#define _EPHSHK                 0x10

//==============================================================================


//==============================================================================
//        UEP1 Bits

extern __at(0x0E99) __sfr UEP1;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP1bits_t;

extern __at(0x0E99) volatile __UEP1bits_t UEP1bits;

#define _UEP1_EPSTALL           0x01
#define _UEP1_EPINEN            0x02
#define _UEP1_EPOUTEN           0x04
#define _UEP1_EPCONDIS          0x08
#define _UEP1_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP2 Bits

extern __at(0x0E9A) __sfr UEP2;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP2bits_t;

extern __at(0x0E9A) volatile __UEP2bits_t UEP2bits;

#define _UEP2_EPSTALL           0x01
#define _UEP2_EPINEN            0x02
#define _UEP2_EPOUTEN           0x04
#define _UEP2_EPCONDIS          0x08
#define _UEP2_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP3 Bits

extern __at(0x0E9B) __sfr UEP3;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP3bits_t;

extern __at(0x0E9B) volatile __UEP3bits_t UEP3bits;

#define _UEP3_EPSTALL           0x01
#define _UEP3_EPINEN            0x02
#define _UEP3_EPOUTEN           0x04
#define _UEP3_EPCONDIS          0x08
#define _UEP3_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP4 Bits

extern __at(0x0E9C) __sfr UEP4;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP4bits_t;

extern __at(0x0E9C) volatile __UEP4bits_t UEP4bits;

#define _UEP4_EPSTALL           0x01
#define _UEP4_EPINEN            0x02
#define _UEP4_EPOUTEN           0x04
#define _UEP4_EPCONDIS          0x08
#define _UEP4_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP5 Bits

extern __at(0x0E9D) __sfr UEP5;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP5bits_t;

extern __at(0x0E9D) volatile __UEP5bits_t UEP5bits;

#define _UEP5_EPSTALL           0x01
#define _UEP5_EPINEN            0x02
#define _UEP5_EPOUTEN           0x04
#define _UEP5_EPCONDIS          0x08
#define _UEP5_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP6 Bits

extern __at(0x0E9E) __sfr UEP6;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP6bits_t;

extern __at(0x0E9E) volatile __UEP6bits_t UEP6bits;

#define _UEP6_EPSTALL           0x01
#define _UEP6_EPINEN            0x02
#define _UEP6_EPOUTEN           0x04
#define _UEP6_EPCONDIS          0x08
#define _UEP6_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP7 Bits

extern __at(0x0E9F) __sfr UEP7;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP7bits_t;

extern __at(0x0E9F) volatile __UEP7bits_t UEP7bits;

#define _UEP7_EPSTALL           0x01
#define _UEP7_EPINEN            0x02
#define _UEP7_EPOUTEN           0x04
#define _UEP7_EPCONDIS          0x08
#define _UEP7_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _STATUS_SHAD_C          0x01
#define _STATUS_SHAD_DC         0x02
#define _STATUS_SHAD_Z          0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0x3FF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0x3FFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0x3FFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0x2FFF  // Internal/External Switchover Mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover Mode is enabled.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 1FFFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0x3FFD  // 000h to 0FFFh write protected, 1000h to 1FFFh may be modified by PMCON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by PMCON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _CPUDIV_NOCLKDIV        0x3FCF  // NO CPU system divide.
#define _CPUDIV_CLKDIV2         0x3FDF  // CPU system clock divided by 2.
#define _CPUDIV_CLKDIV3         0x3FEF  // CPU system clock divided by 3.
#define _CPUDIV_CLKDIV6         0x3FFF  // CPU system clock divided by 6.
#define _USBLSCLK_24MHz         0x3FBF  // System clock expects 24 MHz, FS/LS USB CLKENs divide-by is set to 4.
#define _USBLSCLK_48MHz         0x3FFF  // System clock expects 48 MHz, FS/LS USB CLKENs divide-by is set to 8.
#define _PLLMULT_4x             0x3F7F  // 4x Output Frequency Selected.
#define _PLLMULT_3x             0x3FFF  // 3x Output Frequency Selected.
#define _PLLEN_DISABLED         0x3EFF  // 3x or 4x PLL Disabled.
#define _PLLEN_ENABLED          0x3FFF  // 3x or 4x PLL Enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ACTORS                  ACTCONbits.ACTORS               // bit 1
#define ACTLOCK                 ACTCONbits.ACTLOCK              // bit 3
#define ACTSRC                  ACTCONbits.ACTSRC               // bit 4
#define ACTUD                   ACTCONbits.ACTUD                // bit 6
#define ACTEN                   ACTCONbits.ACTEN                // bit 7

#define ANSA4                   ANSELAbits.ANSA4                // bit 5

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3

#define P2SEL                   APFCONbits.P2SEL                // bit 2
#define T1GSEL                  APFCONbits.T1GSEL               // bit 3
#define SSSEL                   APFCONbits.SSSEL                // bit 5
#define SDOSEL                  APFCONbits.SDOSEL               // bit 6
#define CLKRSEL                 APFCONbits.CLKRSEL              // bit 7

#define ABDEN                   BAUDCONbits.ABDEN               // bit 0
#define WUE                     BAUDCONbits.WUE                 // bit 1
#define BRG16                   BAUDCONbits.BRG16               // bit 3
#define SCKP                    BAUDCONbits.SCKP                // bit 4
#define RCIDL                   BAUDCONbits.RCIDL               // bit 6
#define ABDOVF                  BAUDCONbits.ABDOVF              // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CLKRDIV0                CLKRCONbits.CLKRDIV0            // bit 0
#define CLKRDIV1                CLKRCONbits.CLKRDIV1            // bit 1
#define CLKRDIV2                CLKRCONbits.CLKRDIV2            // bit 2
#define CLKRCD0                 CLKRCONbits.CLKRCD0             // bit 3
#define CLKRCD1                 CLKRCONbits.CLKRCD1             // bit 4
#define CLKRSLR                 CLKRCONbits.CLKRSLR             // bit 5
#define CLKROE                  CLKRCONbits.CLKROE              // bit 6
#define CLKREN                  CLKRCONbits.CLKREN              // bit 7

#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 2
#define IRCF1                   OSCCONbits.IRCF1                // bit 3
#define IRCF2                   OSCCONbits.IRCF2                // bit 4
#define IRCF3                   OSCCONbits.IRCF3                // bit 5
#define SPLLMULT                OSCCONbits.SPLLMULT             // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLRDY                  OSCSTATbits.PLLRDY              // bit 6
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5
#define TUN6                    OSCTUNEbits.TUN6                // bit 6

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define ACTIE                   PIE2bits.ACTIE                  // bit 1
#define USBIE                   PIE2bits.USBIE                  // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define ACTIF                   PIR2bits.ACTIF                  // bit 1
#define USBIF                   PIR2bits.USBIF                  // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5

#define PWM1POL                 PWM1CONbits.PWM1POL             // bit 4
#define PWM1OUT                 PWM1CONbits.PWM1OUT             // bit 5
#define PWM1OE                  PWM1CONbits.PWM1OE              // bit 6
#define PWM1EN                  PWM1CONbits.PWM1EN              // bit 7

#define PWM1DCH0                PWM1DCHbits.PWM1DCH0            // bit 0
#define PWM1DCH1                PWM1DCHbits.PWM1DCH1            // bit 1
#define PWM1DCH2                PWM1DCHbits.PWM1DCH2            // bit 2
#define PWM1DCH3                PWM1DCHbits.PWM1DCH3            // bit 3
#define PWM1DCH4                PWM1DCHbits.PWM1DCH4            // bit 4
#define PWM1DCH5                PWM1DCHbits.PWM1DCH5            // bit 5
#define PWM1DCH6                PWM1DCHbits.PWM1DCH6            // bit 6
#define PWM1DCH7                PWM1DCHbits.PWM1DCH7            // bit 7

#define PWM1DCL0                PWM1DCLbits.PWM1DCL0            // bit 6
#define PWM1DCL1                PWM1DCLbits.PWM1DCL1            // bit 7

#define PWM2POL                 PWM2CONbits.PWM2POL             // bit 4
#define PWM2OUT                 PWM2CONbits.PWM2OUT             // bit 5
#define PWM2OE                  PWM2CONbits.PWM2OE              // bit 6
#define PWM2EN                  PWM2CONbits.PWM2EN              // bit 7

#define PWM2DCH0                PWM2DCHbits.PWM2DCH0            // bit 0
#define PWM2DCH1                PWM2DCHbits.PWM2DCH1            // bit 1
#define PWM2DCH2                PWM2DCHbits.PWM2DCH2            // bit 2
#define PWM2DCH3                PWM2DCHbits.PWM2DCH3            // bit 3
#define PWM2DCH4                PWM2DCHbits.PWM2DCH4            // bit 4
#define PWM2DCH5                PWM2DCHbits.PWM2DCH5            // bit 5
#define PWM2DCH6                PWM2DCHbits.PWM2DCH6            // bit 6
#define PWM2DCH7                PWM2DCHbits.PWM2DCH7            // bit 7

#define PWM2DCL0                PWM2DCLbits.PWM2DCL0            // bit 6
#define PWM2DCL1                PWM2DCLbits.PWM2DCL1            // bit 7

#define RX9D                    RCSTAbits.RX9D                  // bit 0
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define SSP1M0                  SSP1CON1bits.SSP1M0             // bit 0
#define SSP1M1                  SSP1CON1bits.SSP1M1             // bit 1
#define SSP1M2                  SSP1CON1bits.SSP1M2             // bit 2
#define SSP1M3                  SSP1CON1bits.SSP1M3             // bit 3
#define CKP                     SSP1CON1bits.CKP                // bit 4
#define SSPEN                   SSP1CON1bits.SSPEN              // bit 5, shadows bit in SSP1CON1bits
#define SSP1EN                  SSP1CON1bits.SSP1EN             // bit 5, shadows bit in SSP1CON1bits
#define SSPOV                   SSP1CON1bits.SSPOV              // bit 6, shadows bit in SSP1CON1bits
#define SSP1OV                  SSP1CON1bits.SSP1OV             // bit 6, shadows bit in SSP1CON1bits
#define WCOL                    SSP1CON1bits.WCOL               // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5

#define TX9D                    TXSTAbits.TX9D                  // bit 0
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SENDB                   TXSTAbits.SENDB                 // bit 3
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define ADDR0                   UADDRbits.ADDR0                 // bit 0
#define ADDR1                   UADDRbits.ADDR1                 // bit 1
#define ADDR2                   UADDRbits.ADDR2                 // bit 2
#define ADDR3                   UADDRbits.ADDR3                 // bit 3
#define ADDR4                   UADDRbits.ADDR4                 // bit 4
#define ADDR5                   UADDRbits.ADDR5                 // bit 5
#define ADDR6                   UADDRbits.ADDR6                 // bit 6

#define PPB0                    UCFGbits.PPB0                   // bit 0
#define PPB1                    UCFGbits.PPB1                   // bit 1
#define FSEN                    UCFGbits.FSEN                   // bit 2
#define UPUEN                   UCFGbits.UPUEN                  // bit 4
#define UTEYE                   UCFGbits.UTEYE                  // bit 7

#define SUSPND                  UCONbits.SUSPND                 // bit 1
#define RESUME                  UCONbits.RESUME                 // bit 2
#define USBEN                   UCONbits.USBEN                  // bit 3
#define PKTDIS                  UCONbits.PKTDIS                 // bit 4
#define SE0                     UCONbits.SE0                    // bit 5
#define PPBRST                  UCONbits.PPBRST                 // bit 6

#define PIDEE                   UEIEbits.PIDEE                  // bit 0
#define CRC5EE                  UEIEbits.CRC5EE                 // bit 1
#define CRC16EE                 UEIEbits.CRC16EE                // bit 2
#define DFN8EE                  UEIEbits.DFN8EE                 // bit 3
#define BTOEE                   UEIEbits.BTOEE                  // bit 4
#define BTSEE                   UEIEbits.BTSEE                  // bit 7

#define PIDEF                   UEIRbits.PIDEF                  // bit 0
#define CRC5EF                  UEIRbits.CRC5EF                 // bit 1
#define CRC16EF                 UEIRbits.CRC16EF                // bit 2
#define DFN8EF                  UEIRbits.DFN8EF                 // bit 3
#define BTOEF                   UEIRbits.BTOEF                  // bit 4
#define BTSEF                   UEIRbits.BTSEF                  // bit 7

#define EPSTALL                 UEP0bits.EPSTALL                // bit 0
#define EPINEN                  UEP0bits.EPINEN                 // bit 1
#define EPOUTEN                 UEP0bits.EPOUTEN                // bit 2
#define EPCONDIS                UEP0bits.EPCONDIS               // bit 3
#define EPHSHK                  UEP0bits.EPHSHK                 // bit 4

#define FRM8                    UFRMHbits.FRM8                  // bit 0
#define FRM9                    UFRMHbits.FRM9                  // bit 1
#define FRM10                   UFRMHbits.FRM10                 // bit 2

#define FRM0                    UFRMLbits.FRM0                  // bit 0
#define FRM1                    UFRMLbits.FRM1                  // bit 1
#define FRM2                    UFRMLbits.FRM2                  // bit 2
#define FRM3                    UFRMLbits.FRM3                  // bit 3
#define FRM4                    UFRMLbits.FRM4                  // bit 4
#define FRM5                    UFRMLbits.FRM5                  // bit 5
#define FRM6                    UFRMLbits.FRM6                  // bit 6
#define FRM7                    UFRMLbits.FRM7                  // bit 7

#define URSTIE                  UIEbits.URSTIE                  // bit 0
#define UERRIE                  UIEbits.UERRIE                  // bit 1
#define ACTVIE                  UIEbits.ACTVIE                  // bit 2
#define TRNIE                   UIEbits.TRNIE                   // bit 3
#define IDLEIE                  UIEbits.IDLEIE                  // bit 4
#define STALLIE                 UIEbits.STALLIE                 // bit 5
#define SOFIE                   UIEbits.SOFIE                   // bit 6

#define URSTIF                  UIRbits.URSTIF                  // bit 0
#define UERRIF                  UIRbits.UERRIF                  // bit 1
#define ACTVIF                  UIRbits.ACTVIF                  // bit 2
#define TRNIF                   UIRbits.TRNIF                   // bit 3
#define IDLEIF                  UIRbits.IDLEIF                  // bit 4
#define STALLIF                 UIRbits.STALLIF                 // bit 5
#define SOFIF                   UIRbits.SOFIF                   // bit 6

#define PPBI                    USTATbits.PPBI                  // bit 1
#define DIR                     USTATbits.DIR                   // bit 2
#define ENDP0                   USTATbits.ENDP0                 // bit 3
#define ENDP1                   USTATbits.ENDP1                 // bit 4
#define ENDP2                   USTATbits.ENDP2                 // bit 5
#define ENDP3                   USTATbits.ENDP3                 // bit 6

#define VREGPM0                 VREGCONbits.VREGPM0             // bit 0
#define VREGPM1                 VREGCONbits.VREGPM1             // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1454_H__
