<?php

// platform_check.php @generated by Composer

$issues = array();

if (!(PHP_VERSION_ID >= 70300)) {
    $issues[] = 'Your Composer dependencies require a PHP version ">= 7.3.0". You are running ' . PHP_VERSION . '.';
}

$missingExtensions = array();
extension_loaded('curl') || $missingExtensions[] = 'curl';
extension_loaded('dom') || $missingExtensions[] = 'dom';
extension_loaded('fileinfo') || $missingExtensions[] = 'fileinfo';
extension_loaded('filter') || $missingExtensions[] = 'filter';
extension_loaded('gd') || $missingExtensions[] = 'gd';
extension_loaded('hash') || $missingExtensions[] = 'hash';
extension_loaded('json') || $missingExtensions[] = 'json';
extension_loaded('libxml') || $missingExtensions[] = 'libxml';
extension_loaded('openssl') || $missingExtensions[] = 'openssl';
extension_loaded('pcre') || $missingExtensions[] = 'pcre';
extension_loaded('pdo') || $missingExtensions[] = 'pdo';
extension_loaded('session') || $missingExtensions[] = 'session';
extension_loaded('sockets') || $missingExtensions[] = 'sockets';
extension_loaded('tokenizer') || $missingExtensions[] = 'tokenizer';
extension_loaded('xml') || $missingExtensions[] = 'xml';

if ($missingExtensions) {
    $issues[] = 'Your Composer dependencies require the following PHP extensions to be installed: ' . implode(', ', $missingExtensions) . '.';
}

if ($issues) {
    if (!headers_sent()) {
        header('HTTP/1.1 500 Internal Server Error');
    }
    if (!ini_get('display_errors')) {
        if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') {
            fwrite(STDERR, 'Composer detected issues in your platform:' . PHP_EOL.PHP_EOL . implode(PHP_EOL, $issues) . PHP_EOL.PHP_EOL);
        } elseif (!headers_sent()) {
            echo 'Composer detected issues in your platform:' . PHP_EOL.PHP_EOL . str_replace('You are running '.PHP_VERSION.'.', '', implode(PHP_EOL, $issues)) . PHP_EOL.PHP_EOL;
        }
    }
    trigger_error(
        'Composer detected issues in your platform: ' . implode(' ', $issues),
        E_USER_ERROR
    );
}
