/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPrivateKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomECPrivateKey
extends CustomPrivateKey
implements ECPrivateKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BigInteger privatekey;
    private final NamedGroup group;

    private CustomECPrivateKey() {
        this.privatekey = null;
        this.group = null;
    }

    public CustomECPrivateKey(BigInteger privatekey, NamedGroup group) {
        this.privatekey = privatekey;
        this.group = group;
    }

    @Override
    public BigInteger getS() {
        return this.privatekey;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ECParameterSpec ecParameters = this.getParams();
            ECPrivateKeySpec privKey = new ECPrivateKeySpec(this.privatekey, ecParameters);
            PrivateKey privateKey = KeyFactory.getInstance("EC").generatePrivate(privKey);
            return privateKey.getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new UnsupportedOperationException("Could not encode the private EC key", ex);
        }
    }

    @Override
    public ECParameterSpec getParams() {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(this.group.getJavaName()));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            return ecParameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException ex) {
            throw new UnsupportedOperationException("Could not generate ECParameterSpec", ex);
        }
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting EC private key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientEcPrivateKey(this.privatekey);
                context.setEcCertificateCurve(this.group);
                break;
            }
            case SERVER: {
                context.setServerEcPrivateKey(this.privatekey);
                context.setEcCertificateCurve(this.group);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientEcPrivateKey(this.privatekey);
                config.setDefaultEcCertificateCurve(this.group);
                break;
            }
            case SERVER: {
                config.setDefaultServerEcPrivateKey(this.privatekey);
                config.setDefaultEcCertificateCurve(this.group);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.privatekey);
        hash = 53 * hash + Objects.hashCode((Object)this.group);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomECPrivateKey other = (CustomECPrivateKey)obj;
        if (!Objects.equals(this.privatekey, other.privatekey)) {
            return false;
        }
        return this.group == other.group;
    }
}

