/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;

@BuiltinFunction(value={"tojson/0"})
public class ToJsonFunction
implements Function {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static String format(double val) {
        String repr;
        if (Double.isNaN(val)) {
            return "null";
        }
        if (Double.isInfinite(val) && val > 0.0) {
            val = Double.MAX_VALUE;
        }
        if (Double.isInfinite(val) && val < 0.0) {
            val = -1.7976931348623157E308;
        }
        if ((repr = Double.toString(val)).contains("E-")) {
            return repr.replace('E', 'e');
        }
        return repr.replace("E", "e+");
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        try {
            return Collections.singletonList(new TextNode(MAPPER.writeValueAsString((Object)in)));
        }
        catch (IOException e) {
            throw new JsonQueryException(e);
        }
    }

    static {
        SimpleModule module = new SimpleModule("JsonQuery", new Version(1, 0, 0, null, "net.thisptr", "jackson-jq"));
        module.addSerializer(DoubleNode.class, (JsonSerializer)new DoubleNodeSerializer());
        module.addSerializer(FloatNode.class, (JsonSerializer)new FloatNodeSerializer());
        MAPPER.registerModule((Module)module);
    }

    private static class FloatNodeSerializer
    extends JsonSerializer<FloatNode> {
        private FloatNodeSerializer() {
        }

        public void serialize(FloatNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRaw(ToJsonFunction.format(value.asDouble()));
        }
    }

    private static class DoubleNodeSerializer
    extends JsonSerializer<DoubleNode> {
        private DoubleNodeSerializer() {
        }

        public void serialize(DoubleNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRaw(ToJsonFunction.format(value.asDouble()));
        }
    }
}

