/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MultiJoin
extends AbstractRelNode {
    private final List<RelNode> inputs;
    private final RexNode joinFilter;
    private final RelDataType rowType;
    private final boolean isFullOuterJoin;
    private final List<@Nullable RexNode> outerJoinConditions;
    private final ImmutableList<JoinRelType> joinTypes;
    private final List<@Nullable ImmutableBitSet> projFields;
    public final ImmutableMap<Integer, ImmutableIntList> joinFieldRefCountsMap;
    private final @Nullable RexNode postJoinFilter;

    public MultiJoin(RelOptCluster cluster, List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, boolean isFullOuterJoin, List<? extends @Nullable RexNode> outerJoinConditions, List<JoinRelType> joinTypes, List<? extends @Nullable ImmutableBitSet> projFields, ImmutableMap<Integer, ImmutableIntList> joinFieldRefCountsMap, @Nullable RexNode postJoinFilter) {
        super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE));
        this.inputs = Lists.newArrayList(inputs);
        this.joinFilter = joinFilter;
        this.rowType = rowType;
        this.isFullOuterJoin = isFullOuterJoin;
        this.outerJoinConditions = ImmutableNullableList.copyOf(outerJoinConditions);
        assert (outerJoinConditions.size() == inputs.size());
        this.joinTypes = ImmutableList.copyOf(joinTypes);
        this.projFields = ImmutableNullableList.copyOf(projFields);
        this.joinFieldRefCountsMap = joinFieldRefCountsMap;
        this.postJoinFilter = postJoinFilter;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        this.inputs.set(ordinalInParent, p);
        this.recomputeDigest();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new MultiJoin(this.getCluster(), inputs, this.joinFilter, this.rowType, this.isFullOuterJoin, (List<? extends RexNode>)this.outerJoinConditions, (List<JoinRelType>)this.joinTypes, (List<? extends ImmutableBitSet>)this.projFields, this.joinFieldRefCountsMap, this.postJoinFilter);
    }

    private Map<Integer, int[]> cloneJoinFieldRefCountsMap() {
        HashMap<Integer, int[]> clonedMap = new HashMap<Integer, int[]>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            clonedMap.put(i, ((ImmutableIntList)this.joinFieldRefCountsMap.get((Object)i)).toIntArray());
        }
        return clonedMap;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        ArrayList<String> joinTypeNames = new ArrayList<String>();
        ArrayList<String> outerJoinConds = new ArrayList<String>();
        ArrayList<String> projFieldObjects = new ArrayList<String>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            joinTypeNames.add(((JoinRelType)((Object)this.joinTypes.get(i))).name());
            RexNode outerJoinCondition = this.outerJoinConditions.get(i);
            if (outerJoinCondition == null) {
                outerJoinConds.add("NULL");
            } else {
                outerJoinConds.add(outerJoinCondition.toString());
            }
            ImmutableBitSet projField = this.projFields.get(i);
            if (projField == null) {
                projFieldObjects.add("ALL");
                continue;
            }
            projFieldObjects.add(projField.toString());
        }
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("joinFilter", this.joinFilter).item("isFullOuterJoin", this.isFullOuterJoin).item("joinTypes", joinTypeNames).item("outerJoinConditions", outerJoinConds).item("projFields", projFieldObjects).itemIf("postJoinFilter", this.postJoinFilter, this.postJoinFilter != null);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode joinFilter = shuttle.apply(this.joinFilter);
        List<@Nullable RexNode> outerJoinConditions = shuttle.apply(this.outerJoinConditions);
        RexNode postJoinFilter = shuttle.apply(this.postJoinFilter);
        if (joinFilter == this.joinFilter && outerJoinConditions == this.outerJoinConditions && postJoinFilter == this.postJoinFilter) {
            return this;
        }
        return new MultiJoin(this.getCluster(), this.inputs, joinFilter, this.rowType, this.isFullOuterJoin, (List<? extends RexNode>)outerJoinConditions, (List<JoinRelType>)this.joinTypes, (List<? extends ImmutableBitSet>)this.projFields, this.joinFieldRefCountsMap, postJoinFilter);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    public boolean isFullOuterJoin() {
        return this.isFullOuterJoin;
    }

    public List<@Nullable RexNode> getOuterJoinConditions() {
        return this.outerJoinConditions;
    }

    public List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    public List<@Nullable ImmutableBitSet> getProjFields() {
        return this.projFields;
    }

    public ImmutableMap<Integer, ImmutableIntList> getJoinFieldRefCountsMap() {
        return this.joinFieldRefCountsMap;
    }

    public Map<Integer, int[]> getCopyJoinFieldRefCountsMap() {
        return this.cloneJoinFieldRefCountsMap();
    }

    public @Nullable RexNode getPostJoinFilter() {
        return this.postJoinFilter;
    }

    boolean containsOuter() {
        for (JoinRelType joinType : this.joinTypes) {
            if (!joinType.isOuterJoin()) continue;
            return true;
        }
        return false;
    }
}

