/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineDynamicStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DYNAMICSTATECOUNT;
    public static final int PDYNAMICSTATES;

    public VkPipelineDynamicStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineDynamicStateCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineDynamicStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineDynamicStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineDynamicStateCreateFlags")
    public int flags() {
        return VkPipelineDynamicStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int dynamicStateCount() {
        return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDynamicState const *")
    public IntBuffer pDynamicStates() {
        return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
    }

    public VkPipelineDynamicStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo flags(@NativeType(value="VkPipelineDynamicStateCreateFlags") int value) {
        VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo pDynamicStates(@Nullable @NativeType(value="VkDynamicState const *") IntBuffer value) {
        VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(int sType, long pNext, int flags, @Nullable IntBuffer pDynamicStates) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pDynamicStates(pDynamicStates);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(VkPipelineDynamicStateCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineDynamicStateCreateInfo malloc() {
        return (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo calloc() {
        return (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPipelineDynamicStateCreateInfo create(long address) {
        return (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkPipelineDynamicStateCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPipelineDynamicStateCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineDynamicStateCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPipelineDynamicStateCreateInfo mallocStack() {
        return VkPipelineDynamicStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDynamicStateCreateInfo callocStack() {
        return VkPipelineDynamicStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDynamicStateCreateInfo mallocStack(MemoryStack stack) {
        return (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo callocStack(MemoryStack stack) {
        return (VkPipelineDynamicStateCreateInfo)VkPipelineDynamicStateCreateInfo.wrap(VkPipelineDynamicStateCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineDynamicStateCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndynamicStateCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DYNAMICSTATECOUNT);
    }

    @Nullable
    public static IntBuffer npDynamicStates(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDYNAMICSTATES)), (int)VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndynamicStateCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DYNAMICSTATECOUNT, value);
    }

    public static void npDynamicStates(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDYNAMICSTATES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDYNAMICSTATES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineDynamicStateCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkPipelineDynamicStateCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineDynamicStateCreateInfo.__member((int)4), VkPipelineDynamicStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineDynamicStateCreateInfo.__member((int)4), VkPipelineDynamicStateCreateInfo.__member((int)4), VkPipelineDynamicStateCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DYNAMICSTATECOUNT = layout.offsetof(3);
        PDYNAMICSTATES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineDynamicStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineDynamicStateCreateInfo ELEMENT_FACTORY = VkPipelineDynamicStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPipelineDynamicStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineDynamicStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineDynamicStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineDynamicStateCreateFlags")
        public int flags() {
            return VkPipelineDynamicStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int dynamicStateCount() {
            return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDynamicState const *")
        public IntBuffer pDynamicStates() {
            return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineDynamicStateCreateFlags") int value) {
            VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pDynamicStates(@Nullable @NativeType(value="VkDynamicState const *") IntBuffer value) {
            VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
            return this;
        }
    }
}

